/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ErrorDetails;
import com.google.api.gax.rpc.OutOfRangeException;
import com.google.cloud.storage.AsyncStorageTaskException;
import com.google.cloud.storage.BidiResumableWrite;
import com.google.cloud.storage.BidiWriteCtx;
import com.google.cloud.storage.ChunkSegmenter;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.GrpcUtils;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnbufferedWritableByteChannelSession;
import com.google.cloud.storage.UploadFailureScenario;
import com.google.cloud.storage.Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.ChecksummedData;
import com.google.storage.v2.ObjectChecksums;
import io.grpc.Status;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GapicBidiUnbufferedWritableByteChannel
implements UnbufferedWritableByteChannelSession.UnbufferedWritableByteChannel {
    private final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write;
    private final Retrying.RetrierWithAlg retrier;
    private final SettableApiFuture<BidiWriteObjectResponse> resultFuture;
    private final ChunkSegmenter chunkSegmenter;
    private final BidiWriteCtx<BidiResumableWrite> writeCtx;
    private final GrpcCallContext context;
    private final BidiObserver responseObserver;
    private volatile ApiStreamObserver<BidiWriteObjectRequest> stream;
    private boolean open = true;
    private boolean first = true;
    private boolean finished = false;
    private volatile BidiWriteObjectRequest lastWrittenRequest;
    private volatile RewindableContent currentContent;

    GapicBidiUnbufferedWritableByteChannel(BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write, Retrying.RetrierWithAlg retrier, SettableApiFuture<BidiWriteObjectResponse> resultFuture, ChunkSegmenter chunkSegmenter, BidiWriteCtx<BidiResumableWrite> writeCtx, Supplier<GrpcCallContext> baseContextSupplier) {
        this.write = write;
        this.retrier = retrier;
        this.resultFuture = resultFuture;
        this.chunkSegmenter = chunkSegmenter;
        this.writeCtx = writeCtx;
        this.responseObserver = new BidiObserver();
        String bucketName = writeCtx.getRequestFactory().bucketName();
        this.context = GrpcUtils.contextWithBucketName(bucketName, baseContextSupplier.get());
    }

    @Override
    public long write(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException {
        return this.internalWrite(srcs, srcsOffset, srcsLength, false);
    }

    @Override
    public long writeAndClose(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long written = this.internalWrite(srcs, offset, length, true);
        this.close();
        return written;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        try {
            if (!this.finished) {
                BidiWriteObjectRequest message;
                this.lastWrittenRequest = message = this.finishMessage();
                this.flush(Collections.singletonList(message));
            } else if (this.stream != null) {
                this.stream.onCompleted();
                this.responseObserver.await();
            }
        }
        finally {
            this.open = false;
            this.stream = null;
            this.lastWrittenRequest = null;
        }
    }

    @VisibleForTesting
    BidiWriteCtx<BidiResumableWrite> getWriteCtx() {
        return this.writeCtx;
    }

    private long internalWrite(ByteBuffer[] srcs, int srcsOffset, int srcsLength, boolean finalize) throws ClosedChannelException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        long begin = this.writeCtx.getConfirmedBytes().get();
        this.currentContent = RewindableContent.of(srcs, srcsOffset, srcsLength);
        ChunkSegmenter.ChunkSegment[] data = this.chunkSegmenter.segmentBuffers(srcs, srcsOffset, srcsLength, finalize);
        if (data.length == 0) {
            this.currentContent = null;
            return 0L;
        }
        ArrayList<BidiWriteObjectRequest> messages = new ArrayList<BidiWriteObjectRequest>();
        for (int i = 0; i < data.length; ++i) {
            ChunkSegmenter.ChunkSegment datum = data[i];
            Crc32cValue.Crc32cLengthKnown crc32c = datum.getCrc32c();
            ByteString b = datum.getB();
            int contentSize = b.size();
            long offset = this.writeCtx.getTotalSentBytes().getAndAdd(contentSize);
            Crc32cValue.Crc32cLengthKnown cumulative = this.writeCtx.getCumulativeCrc32c().accumulateAndGet(crc32c, this.chunkSegmenter.getHasher()::nullSafeConcat);
            ChecksummedData.Builder checksummedData = ChecksummedData.newBuilder().setContent(b);
            if (crc32c != null) {
                checksummedData.setCrc32C(crc32c.getValue());
            }
            BidiWriteObjectRequest.Builder builder = this.writeCtx.newRequestBuilder();
            if (!this.first) {
                builder.clearUploadId();
                builder.clearObjectChecksums();
            } else {
                this.first = false;
            }
            builder.setWriteOffset(offset).setChecksummedData(checksummedData.build());
            if (!datum.isOnlyFullBlocks()) {
                builder.setFinishWrite(true);
                if (cumulative != null) {
                    builder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(cumulative.getValue()).build());
                }
                this.finished = true;
            }
            if (i == data.length - 1 && !this.finished) {
                if (finalize) {
                    builder.setFinishWrite(true);
                    this.finished = true;
                } else {
                    builder.setFlush(true).setStateLookup(true);
                }
            }
            BidiWriteObjectRequest build = builder.build();
            messages.add(build);
        }
        if (finalize && !this.finished) {
            messages.add(this.finishMessage());
            this.finished = true;
        }
        try {
            this.flush(messages);
        }
        catch (RuntimeException e) {
            this.open = false;
            this.resultFuture.setException((Throwable)e);
            throw e;
        }
        long end = this.writeCtx.getConfirmedBytes().get();
        long bytesConsumed = end - begin;
        return bytesConsumed;
    }

    private @NonNull BidiWriteObjectRequest finishMessage() {
        long offset = this.writeCtx.getTotalSentBytes().get();
        Crc32cValue.Crc32cLengthKnown crc32cValue = this.writeCtx.getCumulativeCrc32c().get();
        BidiWriteObjectRequest.Builder b = this.writeCtx.newRequestBuilder();
        if (!this.first) {
            b.clearUploadId().clearObjectChecksums();
        }
        b.setFinishWrite(true).setWriteOffset(offset);
        if (crc32cValue != null) {
            b.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(crc32cValue.getValue()).build());
        }
        BidiWriteObjectRequest message = b.build();
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiStreamObserver<BidiWriteObjectRequest> openedStream() {
        if (this.stream == null) {
            GapicBidiUnbufferedWritableByteChannel gapicBidiUnbufferedWritableByteChannel = this;
            synchronized (gapicBidiUnbufferedWritableByteChannel) {
                if (this.stream == null) {
                    this.responseObserver.reset();
                    this.stream = new GracefulOutboundStream(this.write.bidiStreamingCall((ApiStreamObserver)this.responseObserver, (ApiCallContext)this.context));
                }
            }
        }
        return this.stream;
    }

    private void flush(@NonNull List<BidiWriteObjectRequest> segments) {
        this.retrier.run(() -> {
            try {
                ApiStreamObserver<BidiWriteObjectRequest> opened = this.openedStream();
                for (BidiWriteObjectRequest message : segments) {
                    opened.onNext((Object)message);
                    this.lastWrittenRequest = message;
                }
                if (this.lastWrittenRequest.getFinishWrite()) {
                    opened.onCompleted();
                }
                this.responseObserver.await();
                return null;
            }
            catch (Throwable t) {
                this.stream = null;
                this.first = true;
                t.addSuppressed(new AsyncStorageTaskException());
                throw t;
            }
        }, Conversions.Decoder.identity());
    }

    private class BidiObserver
    implements ApiStreamObserver<BidiWriteObjectResponse> {
        private final Semaphore sem = new Semaphore(0);
        private volatile BidiWriteObjectResponse last;
        private volatile StorageException clientDetectedError;
        private volatile RuntimeException previousError;

        private BidiObserver() {
        }

        public void onNext(BidiWriteObjectResponse value) {
            boolean finalizing = GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest.getFinishWrite();
            if (!finalizing && value.hasPersistedSize()) {
                long persistedSize;
                long totalSentBytes = GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                if (totalSentBytes == (persistedSize = value.getPersistedSize())) {
                    GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                    this.ok(value);
                } else if (persistedSize < totalSentBytes) {
                    long delta = totalSentBytes - persistedSize;
                    GapicBidiUnbufferedWritableByteChannel.this.currentContent.rewindTo(delta);
                    GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getTotalSentBytes().set(persistedSize);
                    GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                    this.ok(value);
                } else {
                    this.clientDetectedError(UploadFailureScenario.SCENARIO_7.toStorageException(Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), (Message)value, GapicBidiUnbufferedWritableByteChannel.this.context, (Throwable)null));
                }
            } else if (finalizing && value.hasResource()) {
                long finalSize;
                long totalSentBytes = GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                if (totalSentBytes == (finalSize = value.getResource().getSize())) {
                    GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getConfirmedBytes().set(finalSize);
                    this.ok(value);
                } else if (finalSize < totalSentBytes) {
                    this.clientDetectedError(UploadFailureScenario.SCENARIO_4_1.toStorageException(Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), (Message)value, GapicBidiUnbufferedWritableByteChannel.this.context, (Throwable)null));
                } else {
                    this.clientDetectedError(UploadFailureScenario.SCENARIO_4_2.toStorageException(Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), (Message)value, GapicBidiUnbufferedWritableByteChannel.this.context, (Throwable)null));
                }
            } else if (!finalizing && value.hasResource()) {
                this.clientDetectedError(UploadFailureScenario.SCENARIO_1.toStorageException(Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), (Message)value, GapicBidiUnbufferedWritableByteChannel.this.context, (Throwable)null));
            } else if (finalizing && value.hasPersistedSize()) {
                long persistedSize;
                long totalSentBytes = GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getTotalSentBytes().get();
                if (totalSentBytes == (persistedSize = value.getPersistedSize())) {
                    GapicBidiUnbufferedWritableByteChannel.this.writeCtx.getConfirmedBytes().set(persistedSize);
                } else if (persistedSize < totalSentBytes) {
                    this.clientDetectedError(UploadFailureScenario.SCENARIO_3.toStorageException(Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), (Message)value, GapicBidiUnbufferedWritableByteChannel.this.context, (Throwable)null));
                } else {
                    this.clientDetectedError(UploadFailureScenario.SCENARIO_2.toStorageException(Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), (Message)value, GapicBidiUnbufferedWritableByteChannel.this.context, (Throwable)null));
                }
            } else {
                this.clientDetectedError(UploadFailureScenario.SCENARIO_0.toStorageException(Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), (Message)value, GapicBidiUnbufferedWritableByteChannel.this.context, (Throwable)null));
            }
        }

        public void onError(Throwable t) {
            OutOfRangeException oore;
            ErrorDetails ed;
            if (t instanceof OutOfRangeException && ((ed = (oore = (OutOfRangeException)t).getErrorDetails()) == null || ed.getErrorInfo() == null || !ed.getErrorInfo().getReason().equals("GRPC_MISMATCHED_UPLOAD_SIZE"))) {
                this.clientDetectedError(UploadFailureScenario.SCENARIO_5.toStorageException(Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), (Message)null, GapicBidiUnbufferedWritableByteChannel.this.context, (Throwable)oore));
                return;
            }
            if (t instanceof ApiException) {
                StorageException tmp = StorageException.asStorageException((ApiException)t);
                this.previousError = UploadFailureScenario.toStorageException(tmp.getCode(), tmp.getMessage(), tmp.getReason(), Utils.nullSafeList(GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest), null, GapicBidiUnbufferedWritableByteChannel.this.context, t);
                this.sem.release();
            } else if (t instanceof RuntimeException) {
                this.previousError = (RuntimeException)t;
                this.sem.release();
            }
        }

        public void onCompleted() {
            if (this.last != null && this.last.hasResource()) {
                GapicBidiUnbufferedWritableByteChannel.this.resultFuture.set((Object)this.last);
            }
            this.sem.release();
        }

        private void ok(BidiWriteObjectResponse value) {
            this.last = value;
            this.sem.release();
        }

        private void clientDetectedError(StorageException storageException) {
            GapicBidiUnbufferedWritableByteChannel.this.open = false;
            this.clientDetectedError = storageException;
            if (this.previousError != null && this.previousError != storageException) {
                storageException.addSuppressed(this.previousError);
                this.previousError = null;
            }
            if (this.previousError == null) {
                this.previousError = storageException;
            }
            this.sem.release();
        }

        void await() {
            try {
                this.sem.acquire();
            }
            catch (InterruptedException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
            StorageException e = this.clientDetectedError;
            RuntimeException err = this.previousError;
            this.clientDetectedError = null;
            this.previousError = null;
            if ((e != null || err != null) && GapicBidiUnbufferedWritableByteChannel.this.stream != null) {
                if (GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest != null && GapicBidiUnbufferedWritableByteChannel.this.lastWrittenRequest.getFinishWrite()) {
                    GapicBidiUnbufferedWritableByteChannel.this.stream.onCompleted();
                } else {
                    GapicBidiUnbufferedWritableByteChannel.this.stream.onError((Throwable)Status.CANCELLED.asRuntimeException());
                }
            }
            if (e != null) {
                throw e;
            }
            if (err != null) {
                throw err;
            }
        }

        public void reset() {
            this.sem.drainPermits();
            this.last = null;
            this.clientDetectedError = null;
            this.previousError = null;
        }
    }

    private static final class GracefulOutboundStream
    implements ApiStreamObserver<BidiWriteObjectRequest> {
        private final ApiStreamObserver<BidiWriteObjectRequest> delegate;
        private volatile boolean closing;

        private GracefulOutboundStream(ApiStreamObserver<BidiWriteObjectRequest> delegate) {
            this.delegate = delegate;
            this.closing = false;
        }

        public void onNext(BidiWriteObjectRequest value) {
            this.delegate.onNext((Object)value);
        }

        public void onError(Throwable t) {
            if (this.closing) {
                return;
            }
            this.closing = true;
            this.delegate.onError(t);
        }

        public void onCompleted() {
            if (this.closing) {
                return;
            }
            this.closing = true;
            this.delegate.onCompleted();
        }
    }
}

