/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.memoryview;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewIterator;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewIteratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewIteratorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMemoryViewIterator})
public final class MemoryViewIteratorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = MemoryViewIteratorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MemoryViewIteratorBuiltinsFactory.getFactories();
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(Object self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"self.isExhausted()"})
        static Object exhausted(VirtualFrame frame, MemoryViewIterator self) {
            throw NextNode.iteratorExhausted();
        }

        @Specialization(guards={"!self.isExhausted()"})
        static Object memoryiterNext(VirtualFrame frame, MemoryViewIterator self, @Bind Node inliningTarget, @Cached CExtNodes.PCallCapiFunction capiFunction, @Cached MemoryViewNodes.ReadItemAtNode readItemAtNode, @Cached PRaiseNode raiseNode) {
            PMemoryView seq = self.getSeq();
            if (self.getIndex() < self.getLength()) {
                seq.checkReleased(inliningTarget, raiseNode);
                Object ptr = seq.getBufferPointer();
                int offset = seq.getOffset() + seq.getBufferStrides()[0] * self.index++;
                if (seq.getBufferSuboffsets() != null && seq.getBufferSuboffsets()[0] >= 0) {
                    ptr = capiFunction.call(NativeCAPISymbol.FUN_ADD_SUBOFFSET, ptr, offset, seq.getBufferSuboffsets()[0]);
                    offset = 0;
                }
                return readItemAtNode.execute(frame, seq, ptr, offset);
            }
            self.clearSeq();
            throw NextNode.iteratorExhausted();
        }
    }
}

