/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.NativeTokenHolder;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.CommonCredentialsProvider;
import java.io.IOException;
import java.util.Date;

public class IdpTokenAuthPlugin
extends CommonCredentialsProvider {
    private static final String KEY_TOKEN = "token";
    private static final String KEY_TOKEN_TYPE = "token_type";
    private static final int DEFAULT_IDP_TOKEN_EXPIRY_IN_SEC = 900;
    private String token;
    private String token_type;

    @Override
    protected NativeTokenHolder getAuthToken() throws IOException {
        this.checkRequiredParameters();
        Date expiration = new Date(System.currentTimeMillis() + 900000L);
        return NativeTokenHolder.newInstance(this.token, expiration);
    }

    private void checkRequiredParameters() throws IOException {
        if (Utils.isNullOrEmpty(this.token)) {
            throw new IOException("IdC authentication failed: The token must be included in the connection parameters.");
        }
        if (Utils.isNullOrEmpty(this.token_type)) {
            throw new IOException("IdC authentication failed: The token type must be included in the connection parameters.");
        }
    }

    @Override
    public void addParameter(String key, String value) {
        super.addParameter(key, value);
        if (KEY_TOKEN.equalsIgnoreCase(key)) {
            this.token = value;
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("Setting token of length={0}", this.token.length());
            }
        } else if (KEY_TOKEN_TYPE.equalsIgnoreCase(key)) {
            this.token_type = value;
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("Setting token_type: {0}", this.token_type);
            }
        }
    }
}

