/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.ServerErrorMessage;
import java.sql.SQLException;

public class RedshiftException
extends SQLException {
    private static final long serialVersionUID = 1L;
    private ServerErrorMessage serverError;

    public RedshiftException(String msg, RedshiftState state, Throwable cause, RedshiftLogger logger) {
        this(msg, state, cause);
        if (RedshiftLogger.isEnable()) {
            logger.logError(this);
        }
    }

    public RedshiftException(String msg, RedshiftState state, Throwable cause) {
        super(msg, state == null ? null : state.getState(), cause);
    }

    public RedshiftException(String msg, RedshiftState state) {
        super(msg, state == null ? null : state.getState());
    }

    public RedshiftException(String msg, Throwable cause) {
        super(msg, null, cause);
    }

    public RedshiftException(String msg) {
        super(msg, "");
    }

    public RedshiftException(ServerErrorMessage serverError) {
        this(serverError, true);
    }

    public RedshiftException(ServerErrorMessage serverError, boolean detail) {
        super(detail ? serverError.getExternalErrorMessage() : serverError.getNonSensitiveErrorMessage(), serverError.getSQLState());
        this.serverError = serverError;
    }

    public ServerErrorMessage getServerErrorMessage() {
        return this.serverError;
    }

    public SQLException getSQLException() {
        return new SQLException(this.getMessage(), this.getSQLState(), this.getCause());
    }
}

