/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.exception;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class GenerationException
extends DataRuntimeException {
    private static final long serialVersionUID = 750771676962397920L;
    private static final int intNotSet_ = -1;
    private int lineNumber_ = -1;
    private int length_ = -1;
    private int columnNumber_ = -1;
    private int startPosition_ = -1;
    protected String methodName_ = null;
    protected String sqlStmt_ = null;

    protected GenerationException(String string, Throwable throwable, int n2, String string2, ASTNode aSTNode, MethodInfo methodInfo) {
        super(string, throwable, n2, string2);
        if (aSTNode != null) {
            this.lineNumber_ = this.getNodeLineNumber(aSTNode);
            this.columnNumber_ = this.getNodeColumnNumber(aSTNode);
            this.startPosition_ = aSTNode.getStartPosition();
            this.length_ = aSTNode.getLength();
            this.methodName_ = null;
            this.sqlStmt_ = null;
        } else if (methodInfo != null) {
            this.lineNumber_ = methodInfo.getLineNumber();
            this.columnNumber_ = methodInfo.getColumn();
            this.startPosition_ = methodInfo.getStartPosition();
            this.length_ = methodInfo.getLength();
            this.methodName_ = methodInfo.getMethodName();
            this.sqlStmt_ = methodInfo.getSql();
        }
    }

    @Override
    protected String getLocationInformation() {
        StringBuilder stringBuilder = new StringBuilder();
        if (-1 != this.lineNumber_) {
            stringBuilder.append("Line number: " + this.lineNumber_);
        }
        if (-1 != this.columnNumber_) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(";  ");
            }
            stringBuilder.append("Column number: " + this.columnNumber_);
        }
        if (null != this.methodName_ && 0 < this.methodName_.length()) {
            if (0 < stringBuilder.length()) {
                stringBuilder.append(";  ");
            }
            stringBuilder.append("Method name: " + this.methodName_);
        }
        return stringBuilder.toString();
    }

    public int getLineNumber() {
        return this.lineNumber_;
    }

    public void setLineNumber(int n2) {
        this.lineNumber_ = n2;
    }

    public int getColumnNumber() {
        return this.columnNumber_;
    }

    public void setColumnNumber(int n2) {
        this.columnNumber_ = n2;
    }

    public int getStartPosition() {
        return this.startPosition_;
    }

    public void setStartPosition(int n2) {
        this.startPosition_ = n2;
    }

    public int getLength() {
        return this.length_;
    }

    public void setLength(int n2) {
        this.length_ = n2;
    }

    private int getNodeLineNumber(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (aSTNode2 != null && aSTNode2.getNodeType() == 15) {
            CompilationUnit compilationUnit = (CompilationUnit)aSTNode2;
            return compilationUnit.getLineNumber(aSTNode.getStartPosition());
        }
        return -1;
    }

    private int getNodeColumnNumber(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (aSTNode2 != null && aSTNode2.getNodeType() == 15) {
            CompilationUnit compilationUnit = (CompilationUnit)aSTNode2;
            return compilationUnit.getColumnNumber(aSTNode.getStartPosition());
        }
        return -1;
    }

    public String getSqlStmt() {
        return this.sqlStmt_;
    }
}

