/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Checksum;

public final class Adler32
implements Checksum {
    private static final int BASE = 65521;
    private static final int NMAX = 5552;
    private long s1 = 1L;
    private long s2 = 0L;

    @Override
    public void reset(long l) {
        this.s1 = l & 0xFFFFL;
        this.s2 = l >> 16 & 0xFFFFL;
    }

    @Override
    public void reset() {
        this.s1 = 1L;
        this.s2 = 0L;
    }

    @Override
    public long getValue() {
        return this.s2 << 16 | this.s1;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 == 1) {
            this.s1 += (long)(byArray[n++] & 0xFF);
            this.s2 += this.s1;
            this.s1 %= 65521L;
            this.s2 %= 65521L;
            return;
        }
        int n4 = n2 / 5552;
        int n5 = n2 % 5552;
        while (n4-- > 0) {
            n3 = 5552;
            n2 -= n3;
            while (n3-- > 0) {
                this.s1 += (long)(byArray[n++] & 0xFF);
                this.s2 += this.s1;
            }
            this.s1 %= 65521L;
            this.s2 %= 65521L;
        }
        n3 = n5;
        n2 -= n3;
        while (n3-- > 0) {
            this.s1 += (long)(byArray[n++] & 0xFF);
            this.s2 += this.s1;
        }
        this.s1 %= 65521L;
        this.s2 %= 65521L;
    }

    @Override
    public Adler32 copy() {
        Adler32 adler32 = new Adler32();
        adler32.s1 = this.s1;
        adler32.s2 = this.s2;
        return adler32;
    }

    static long combine(long l, long l2, long l3) {
        long l4 = 65521L;
        long l5 = l3 % l4;
        long l6 = l & 0xFFFFL;
        long l7 = l5 * l6;
        l7 %= l4;
        l7 += (l >> 16 & 0xFFFFL) + (l2 >> 16 & 0xFFFFL) + l4 - l5;
        if ((l6 += (l2 & 0xFFFFL) + l4 - 1L) >= l4) {
            l6 -= l4;
        }
        if (l6 >= l4) {
            l6 -= l4;
        }
        if (l7 >= l4 << 1) {
            l7 -= l4 << 1;
        }
        if (l7 >= l4) {
            l7 -= l4;
        }
        return l6 | l7 << 16;
    }
}

