
/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * IPlatform.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_2;

import org.virtualbox_7_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Platform object for a virtual machine.

Accessed via{@link org.virtualbox_7_2.IMachine#getPlatform()}.

Interface ID: <code>{A670A023-E172-452C-B731-14EF855F4DA6}</code>
*/
public class IPlatform extends IUnknown
{

    public IPlatform(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Returns the platform architecture.

Changing this means settings for the previously selected architecture
will be discarded and replaced by defaults.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_NOTIMPL</code> - Not implemented yet.</dd>
</dl>

NOTE: Setting the platform architecture currently is
not implemented yet.

@return org.virtualbox_7_2.PlatformArchitecture
*/
    public org.virtualbox_7_2.PlatformArchitecture getArchitecture()
    {
        try
        {
            org.virtualbox_7_2.jaxws.PlatformArchitecture retVal = port.iPlatformGetArchitecture(obj);
            return org.virtualbox_7_2.PlatformArchitecture.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the platform architecture.

Changing this means settings for the previously selected architecture
will be discarded and replaced by defaults.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>E_NOTIMPL</code> - Not implemented yet.</dd>
</dl>

NOTE: Setting the platform architecture currently is
not implemented yet.

@param value org.virtualbox_7_2.PlatformArchitecture

*/
    public void setArchitecture(org.virtualbox_7_2.PlatformArchitecture value)
    {
        try
        {
        port.iPlatformSetArchitecture(obj, org.virtualbox_7_2.jaxws.PlatformArchitecture.fromValue(value.name()));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Returns the platform properties.
@return org.virtualbox_7_2.IPlatformProperties
*/
    public org.virtualbox_7_2.IPlatformProperties getProperties()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iPlatformGetProperties(obj);
            return (retVal.length() > 0) ? new org.virtualbox_7_2.IPlatformProperties(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Platform object for x86-specific platform properties.

Changes to this object will not necessarily be preserved unless{@link org.virtualbox_7_2.IPlatform#getArchitecture()}is set to{@link org.virtualbox_7_2.PlatformArchitecture#x86}.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>VBOX_E_PLATFORM_ARCH_NOT_SUPPORTED</code> - Current platform  architecture is not x86.</dd>
</dl>

@return org.virtualbox_7_2.IPlatformX86
*/
    public org.virtualbox_7_2.IPlatformX86 getX86()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iPlatformGetX86(obj);
            return (retVal.length() > 0) ? new org.virtualbox_7_2.IPlatformX86(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Platform object for ARM-specific platform properties.

Changes to this object will not necessarily be preserved unless{@link org.virtualbox_7_2.IPlatform#getArchitecture()}is set to{@link org.virtualbox_7_2.PlatformArchitecture#ARM}.
<p></p><dl><dt><b>Expected result codes:</b></dt>
<dd><code>VBOX_E_PLATFORM_ARCH_NOT_SUPPORTED</code> - Current platform  architecture is not ARM.</dd>
</dl>

@return org.virtualbox_7_2.IPlatformARM
*/
    public org.virtualbox_7_2.IPlatformARM getARM()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iPlatformGetARM(obj);
            return (retVal.length() > 0) ? new org.virtualbox_7_2.IPlatformARM(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Chipset type used in this VM.
@return org.virtualbox_7_2.ChipsetType
*/
    public org.virtualbox_7_2.ChipsetType getChipsetType()
    {
        try
        {
            org.virtualbox_7_2.jaxws.ChipsetType retVal = port.iPlatformGetChipsetType(obj);
            return org.virtualbox_7_2.ChipsetType.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Chipset type used in this VM.
@param value org.virtualbox_7_2.ChipsetType

*/
    public void setChipsetType(org.virtualbox_7_2.ChipsetType value)
    {
        try
        {
        port.iPlatformSetChipsetType(obj, org.virtualbox_7_2.jaxws.ChipsetType.fromValue(value.name()));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
IOMMU type used in this VM.
@return org.virtualbox_7_2.IommuType
*/
    public org.virtualbox_7_2.IommuType getIommuType()
    {
        try
        {
            org.virtualbox_7_2.jaxws.IommuType retVal = port.iPlatformGetIommuType(obj);
            return org.virtualbox_7_2.IommuType.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
IOMMU type used in this VM.
@param value org.virtualbox_7_2.IommuType

*/
    public void setIommuType(org.virtualbox_7_2.IommuType value)
    {
        try
        {
        port.iPlatformSetIommuType(obj, org.virtualbox_7_2.jaxws.IommuType.fromValue(value.name()));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
When set to  true, the RTC device of the virtual machine will run
in UTC time, otherwise in local time. Especially Unix guests prefer
the time in UTC.
@return Boolean
*/
    public Boolean getRTCUseUTC()
    {
        try
        {
            Boolean retVal = port.iPlatformGetRTCUseUTC(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
When set to  true, the RTC device of the virtual machine will run
in UTC time, otherwise in local time. Especially Unix guests prefer
the time in UTC.
@param value Boolean

*/
    public void setRTCUseUTC(Boolean value)
    {
        try
        {
        port.iPlatformSetRTCUseUTC(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IPlatform queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IPlatform(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
