"use strict";
/* v8 ignore start */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AshWriter = void 0;
const node_stream_1 = require("node:stream");
const consts_1 = require("./consts");
// import {logger} from '../../../utils/logger';
// const NS = 'zh:ember:uart:ash:writer';
class AshWriter extends node_stream_1.Readable {
    #writtenLen = 0;
    #bytesToWrite = Buffer.alloc(consts_1.ASH_MAX_FRAME_WITH_CRC_LEN);
    writeBytes() {
        // expensive and very verbose, enable locally only if necessary
        // logger.debug(`>>>> [FRAME raw=${buffer.toString('hex')}]`, NS);
        // copy, can't use ref
        const buffer = Buffer.from(this.#bytesToWrite.subarray(0, this.#writtenLen));
        this.#writtenLen = 0;
        // this.push(buffer);
        this.emit("data", buffer);
    }
    writeByte(byte) {
        this.#writtenLen = this.#bytesToWrite.writeUInt8(byte, this.#writtenLen);
    }
    writeAvailable() {
        if (this.readableLength < this.readableHighWaterMark) {
            return true;
        }
        this.writeFlush();
        return false;
    }
    /**
     * If there is anything to send, send to the port.
     */
    writeFlush() {
        if (this.#writtenLen > 0) {
            this.writeBytes();
        }
    }
    _read() { }
}
exports.AshWriter = AshWriter;
//# sourceMappingURL=writer.js.map