#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-K2kZTQa3lLKeE3wqfiuMh
key:                  arch-hs-0.12.1-K2kZTQa3lLKeE3wqfiuMh
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  e98c17954f15e8d0d5929685dca03494
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-K2kZTQa3lLKeE3wqfiuMh
extra-libraries:      alpm
include-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/arch-hs-0.12.1/include

depends:
    Cabal-3.10.3.0 Diff-0.5-Je25SsO7JvB1yEEgbSKPbT
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj
    algebraic-graphs-0.7-DdkHR12F1w276F3lRTB5e1
    arch-web-0.3.2-x9MYZAYDI475lNdjoXFQe base-4.18.3.0
    bytestring-0.11.5.4 conduit-1.3.6.1-5nRnREmQGNF6wlJgtv7D97
    conduit-extra-1.3.8-6F4zXdBdSsxH7FEVAMtdPi containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.301.0
    hackage-db-2.1.3-2Es3DGp79YeInLOnnKKZXz
    http-client-0.7.19-CS7nt6M2hIg4TRHBOC9VL7
    http-client-tls-0.3.6.4-HXUUJKGirCyJJRNpLsLsRH
    megaparsec-9.7.0-6iSCkwAigkw2HX9j1KdNdR
    microlens-0.4.14.0-4ENPj0tHNR0GzcdT8Xo5Q8
    microlens-th-0.4.3.17-F1IcXkuPeIB4kMaxwhk9vS
    neat-interpolation-0.5.1.4-6RdXSR71N5J9jIiSp6yZiS
    optparse-simple-0.1.1.4-2YFIZjormVzETZYFS7Zhwv
    polysemy-1.9.2.0-88ZzYO2XSS18iDJY45USpp
    prettyprinter-1.7.1-LHlHufkI3KGGUhqO6HPUXq
    prettyprinter-ansi-terminal-1.1.3-FutfUvwmWdcEw5f7JH4nYV
    servant-client-0.20.3.0-9yuBZSrbw2w2BB4BAIqK9N
    split-0.2.5-4lwOpp22KBrAKpI1IR2DHQ
    tar-conduit-0.4.1-Ja2tTpMIpTVHEnZKbYmZIq template-haskell-2.20.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

