/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;

public class CrossHair
extends GraphShape {
    private float width;
    private float height;
    private float lineWidth;

    public CrossHair(int n, float f, float f2, float f3) {
        super(n);
        this.width = f;
        this.height = f2;
        this.lineWidth = f3;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    public void setDimension(float f, float f2, float f3) {
        this.width = f;
        this.height = f2;
        this.lineWidth = f3;
        this.markShapeDirty();
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        OutlineShape outlineShape = new OutlineShape();
        float f = this.lineWidth / 2.0f;
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        float f4 = f2 / 2.0f;
        float f5 = f3 / 2.0f;
        outlineShape.moveTo(0.0f - f, 0.0f - f5, 0.0f);
        outlineShape.lineTo(0.0f + f, 0.0f - f5, 0.0f);
        outlineShape.lineTo(0.0f + f, 0.0f + f5, 0.0f);
        outlineShape.lineTo(0.0f - f, 0.0f + f5, 0.0f);
        outlineShape.closePath();
        outlineShape.moveTo(0.0f - f4, 0.0f - f, 0.0f);
        outlineShape.lineTo(0.0f + f4, 0.0f - f, 0.0f);
        outlineShape.lineTo(0.0f + f4, 0.0f + f, 0.0f);
        outlineShape.lineTo(0.0f - f4, 0.0f + f, 0.0f);
        outlineShape.closePath();
        outlineShape.setIsQuadraticNurbs();
        outlineShape.setSharpness(this.oshapeSharpness);
        this.resetGLRegion(gLProfile, gL2ES2, null, outlineShape);
        this.region.addOutlineShape(outlineShape, null, this.rgbaColor);
        this.box.resize(outlineShape.getBounds());
        this.setRotationPivot(this.box.getCenter());
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", dim " + this.getWidth() + " x " + this.getHeight();
    }
}

