/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Bits;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.LongDateTime;
import jogamp.graph.font.typecast.ot.table.Table;

public class HeadTable
implements Table {
    public static final int MAGIC = 1594834165;
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    public static final short GLYPH_DATA_FORMAT = 0;
    public static final short FONT_DIRECTION_MIXED = 0;
    public static final short FONT_DIRECTION_LEFT_TO_RIGHT = 1;
    public static final short FONT_DIRECTION_LEFT_TO_RIGHT_AND_NEUTRAL = 2;
    public static final short FONT_DIRECTION_RIGHT_TO_LEFT = -1;
    public static final short FONT_DIRECTION_RIGHT_TO_LEFT_AND_NEUTRAL = -2;
    private int _majorVersion = 1;
    private int _minorVersion = 0;
    private final int _fontRevision;
    private final int _checkSumAdjustment;
    private int _magicNumber = 1594834165;
    private final int _flags;
    private final int _unitsPerEm;
    private final long _created;
    private final long _modified;
    private final short _xMin;
    private final short _yMin;
    private final short _xMax;
    private final short _yMax;
    private final short _macStyle;
    private final short _lowestRecPPEM;
    private short _fontDirectionHint = (short)2;
    private final short _indexToLocFormat;
    private short _glyphDataFormat = 0;

    public HeadTable(DataInput dataInput) throws IOException {
        this._majorVersion = dataInput.readUnsignedShort();
        this._minorVersion = dataInput.readUnsignedShort();
        this._fontRevision = dataInput.readInt();
        this._checkSumAdjustment = dataInput.readInt();
        this._magicNumber = dataInput.readInt();
        this._flags = dataInput.readUnsignedShort();
        this._unitsPerEm = dataInput.readUnsignedShort();
        this._created = dataInput.readLong();
        this._modified = dataInput.readLong();
        this._xMin = dataInput.readShort();
        this._yMin = dataInput.readShort();
        this._xMax = dataInput.readShort();
        this._yMax = dataInput.readShort();
        this._macStyle = dataInput.readShort();
        this._lowestRecPPEM = dataInput.readShort();
        this._fontDirectionHint = dataInput.readShort();
        this._indexToLocFormat = dataInput.readShort();
        this._glyphDataFormat = dataInput.readShort();
    }

    @Override
    public int getType() {
        return 1751474532;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getVersionNumber() {
        return this._majorVersion << 16 | this._minorVersion;
    }

    public String getVersion() {
        return this._majorVersion + "." + this._minorVersion;
    }

    public int getFontRevision() {
        return this._fontRevision;
    }

    public int getCheckSumAdjustment() {
        return this._checkSumAdjustment;
    }

    public int getMagicNumber() {
        return this._magicNumber;
    }

    public int getFlags() {
        return this._flags;
    }

    public boolean isLeftSidebearingNormalized() {
        return Bits.bit(this._flags, 1);
    }

    public int getUnitsPerEm() {
        return this._unitsPerEm;
    }

    public long getCreated() {
        return this._created;
    }

    public long getModified() {
        return this._modified;
    }

    public short getXMin() {
        return this._xMin;
    }

    public short getYMin() {
        return this._yMin;
    }

    public short getXMax() {
        return this._xMax;
    }

    public short getYMax() {
        return this._yMax;
    }

    public short getMacStyle() {
        return this._macStyle;
    }

    public boolean isMacBold() {
        return Bits.bit(this._macStyle, 0);
    }

    public boolean isMacItalic() {
        return Bits.bit(this._macStyle, 1);
    }

    public boolean isMacUnderline() {
        return Bits.bit(this._macStyle, 2);
    }

    public boolean isMacOutline() {
        return Bits.bit(this._macStyle, 3);
    }

    public boolean isMacShadow() {
        return Bits.bit(this._macStyle, 4);
    }

    public boolean isMacCondensed() {
        return Bits.bit(this._macStyle, 5);
    }

    public boolean isMacExtended() {
        return Bits.bit(this._macStyle, 6);
    }

    public short getLowestRecPPEM() {
        return this._lowestRecPPEM;
    }

    public short getFontDirectionHint() {
        return this._fontDirectionHint;
    }

    public short getIndexToLocFormat() {
        return this._indexToLocFormat;
    }

    public boolean useShortEntries() {
        return this.getIndexToLocFormat() == 0;
    }

    public short getGlyphDataFormat() {
        return this._glyphDataFormat;
    }

    public String toString() {
        return "'head' Table - Font Header\n--------------------------\n  'head' version:      " + this.getVersion() + "\n  fontRevision:        " + Fixed.roundedFloatValue(this._fontRevision, 8) + "\n  checkSumAdjustment:  0x" + Integer.toHexString(this._checkSumAdjustment).toUpperCase() + "\n  magicNumber:         0x" + Integer.toHexString(this._magicNumber).toUpperCase() + "\n  flags:               0x" + Integer.toHexString(this._flags).toUpperCase() + "\n  unitsPerEm:          " + this._unitsPerEm + "\n  created:             " + LongDateTime.toDate(this._created) + "\n  modified:            " + LongDateTime.toDate(this._modified) + "\n  xMin:                " + this._xMin + "\n  yMin:                " + this._yMin + "\n  xMax:                " + this._xMax + "\n  yMax:                " + this._yMax + "\n  macStyle bits:       " + Integer.toHexString(this._macStyle).toUpperCase() + "\n  lowestRecPPEM:       " + this._lowestRecPPEM + "\n  fontDirectionHint:   " + this._fontDirectionHint + "\n  indexToLocFormat:    " + this._indexToLocFormat + "\n  glyphDataFormat:     " + this._glyphDataFormat;
    }
}

