#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-EvyPoyzZO6CJcNT8W3IjL0
key:                  gitit-0.15.1.2-EvyPoyzZO6CJcNT8W3IjL0
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  396aa4e7fa8a55e07d7b68577eb10a24
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-EvyPoyzZO6CJcNT8W3IjL0
depends:
    HStringTemplate-0.8.8-AlyGl92fXoxIAObU1HZpT2
    HTTP-4000.4.1-6l7hGT0zrEyB2PeNqMvh6F
    SHA-1.6.4.4-69yKsD90Hrj37T0pIhf9r2
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj base-4.18.3.0
    base64-bytestring-1.2.1.0-BS9gtxrEakSHvE7f2JUUy0
    blaze-html-0.9.2.0-8WIp6HTeEceATvvtNDLUeY bytestring-0.11.5.4
    containers-0.6.7 directory-1.3.8.5
    doctemplates-0.11.0.1-JixbNC6lJ67JuM9hdVzqFE
    feed-1.3.2.1-A7MfsqJUyK24hDJCEKuMIk filepath-1.4.301.0
    filestore-0.6.5.1-HV9DbLyRmtJHThTQC0augK ghc-9.6.7.20250817
    ghc-paths-0.1.0.12-FYbNroakwr3J9PgmQPEoze
    happstack-server-7.9.3-2PLiL3d9TVFL0cqCSE3BLV
    hoauth2-2.14.0-LyfTwylkaImKEgUJBhy2P1
    hslogger-1.3.2.0-9Q1B17t5tAJHzDYELWWJyh
    http-client-tls-0.3.6.4-HXUUJKGirCyJJRNpLsLsRH
    http-conduit-2.3.9.1-6NMT7isJoG35ZNJeS0m6Qu
    json-0.10-KipxLRsldpt9XhUKSOgeBw mtl-2.3.1
    network-3.1.4.0-BquykiICeEU8GLDFE071Z9
    network-bsd-2.8.1.0-ANtfn3S0DSq768fdcPCyhD
    network-uri-2.6.4.2-6QuJNuv1Ns4Gzjjs76diWh
    old-locale-1.0.0.7-HSvLS5bQrOr2jPp7CISS55
    old-time-1.1.0.4-7DjbqVsKRf12Y2J1NtDBv4
    pandoc-3.5-4K7r1iPVZt1Hze9jbncxkV
    pandoc-types-1.23.1-4krSuOvdDvuCnL51s2n70g parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.19.0
    random-1.2.1.3-GswEfj1SZ276IcAtylwQ0f
    recaptcha-0.1.0.4-Ll51WIEfhgH2bzshECp0Ad
    safe-0.3.21-40SDg1d9ZKLLr4MVwyQcdM
    skylighting-0.14.3-BbO3Gi2Xpfm1HgfKwq1VQc
    split-0.2.5-4lwOpp22KBrAKpI1IR2DHQ syb-0.7.3-4faDNy9a4q18QDGKds5is3
    tagsoup-0.14.8-4fd0dBXEIEC3rqDXgGWEOK
    temporary-1.3-3RiPejuWpFkF6pn2FQhudK text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-4BcjUYQzLGuKNVRJNzneck
    url-2.1.3-HHTJ7iIara6IlnTYt9LaEO
    utf8-string-1.0.2-shiuprzUpU7bW4pJ3bW0
    uuid-1.3.16-AHGvpyoTJFdJM7hKT80KV3 xhtml-3000.2.2.1
    xml-1.3.14-4HpQGm3DtXB96G8MyFm2th
    xml-conduit-1.9.1.4-9wjJD2LLb6N67VeyNzHCwl
    xml-types-0.3.8-O6B3Z1rgoK5oMm4hXwsMN
    xss-sanitize-0.3.7.2-9nLhzma9hZl48c3v3PJU58
    zlib-0.7.0.0-DS6Da0uFkVx9bSXatFvIRX

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

