#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bin
version:              0.1.4
visibility:           public
id:                   bin-0.1.4-6oYCjTJuXvGGGxTg5D2yzK
key:                  bin-0.1.4-6oYCjTJuXvGGGxTg5D2yzK
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Bin: binary natural numbers.
description:
    This package provides /binary natural numbers/ ("Data.Bin");
    also utilities to work on the type level with @DataKinds@ ("Data.Type.Bin").

    @
    data Bin
    \    = BZ       -- ^ zero
    \    | BP BinP  -- ^ non-zero

    data BinP
    \    = BE       -- ^ one
    \    | B0 BinP  -- ^ double
    \    | B1 BinP  -- ^ double plus 1
    @

    There are /ordinals/ in "Data.Bin.Pos" module, as well as
    fixed width integers in "Data.Wrd".

    Another implementation is at <https://hackage.haskell.org/package/nat>,
    this differs in naming, and provides promoted variant.

category:             Data, Dependent Types, Singletons, Math
abi:                  7ff4644b37043a9a0c9eebda4c6c3f84
exposed:              True
exposed-modules:
    Data.Bin Data.Bin.Pos Data.BinP Data.BinP.PosP Data.Type.Bin
    Data.Type.BinP Data.Wrd

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/bin-0.1.4
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/bin-0.1.4
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/bin-0.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bin
hs-libraries:         HSbin-0.1.4-6oYCjTJuXvGGGxTg5D2yzK
depends:
    QuickCheck-2.15.0.1-Lq4ECkPzV8iDkKvRhPZIAs base-4.18.3.0
    boring-0.2.2-B0K4fgTlMUXHr2U5ZQCHN dec-0.0.6-AdPc8DDWA5Q3XaBHBwRnKA
    deepseq-1.4.8.1 fin-0.3.2-DkRhHCLaUFlKVuYWJQ0N5d
    hashable-1.4.7.0-17jkMnZLQLs4o2IKp4JpPo
    some-1.0.6-FruGMyVfnG6aUOQ8KkFt2

haddock-interfaces:   /usr/share/doc/haskell-bin/html/bin.haddock
haddock-html:         /usr/share/doc/haskell-bin/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

