#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              2.5
visibility:           public
id:                   brick-2.5-JOnWOQLcNQWCBERbPPQnG2
key:                  brick-2.5-JOnWOQLcNQWCBERbPPQnG2
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2024
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  9f04cb91e51c5cbc00d66024682a4aff
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Normalize Brick.Keybindings.Parse
    Brick.Keybindings.Pretty Brick.Main Brick.Themes Brick.Types
    Brick.Util Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/brick-2.5
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/brick-2.5
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/brick-2.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-2.5-JOnWOQLcNQWCBERbPPQnG2
depends:
    base-4.18.3.0 bimap-0.5.0-2edkbjmNDniChCVKiJwMwF
    bytestring-0.11.5.4 config-ini-0.2.7.0-L3iYfOLYBWl7Kh04mWqkvJ
    containers-0.6.7 data-clist-0.2-8s7L54ZngVZBtTXzB4346W
    deepseq-1.4.8.1 directory-1.3.8.5 exceptions-0.10.7
    filepath-1.4.301.0 microlens-0.4.14.0-4ENPj0tHNR0GzcdT8Xo5Q8
    microlens-mtl-0.2.1.0-BPqflcywilRLKDKsRXDgDa
    microlens-th-0.4.3.17-F1IcXkuPeIB4kMaxwhk9vS mtl-2.3.1 stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2
    text-zipper-0.13-DWC4Z7JxMfcDWZvR9cCZxL
    unix-compat-0.7.4.1-KQpzxaZRaJzE7ZcvOnYp8s
    vector-0.13.2.0-BINMV7y6ibUKgFTnLXEi1A
    vty-6.2-24OTVSAh8AUKPMJVuGQjH5
    vty-crossplatform-0.4.0.0-BBLjeOQnXjcJfW68rQCmIH
    word-wrap-0.5-8h2kX3V4pIaFavDc620f1l

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

