#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 encoding
version:              0.10.2
visibility:           public
id:                   encoding-0.10.2-6eIjoAHUBt89wLoutlfUYD
key:                  encoding-0.10.2-6eIjoAHUBt89wLoutlfUYD
license:              BSD-3-Clause
maintainer:           daniel@wagner-home.com, Andrey Prokopenko
author:               Henning Günther
homepage:             https://github.com/dmwit/encoding
synopsis:             A library for various character encodings
description:
    Haskell has excellect handling of unicode, the Char type covers all unicode chars. Unfortunately, there'\''s no possibility to read or write something to the outer world in an encoding other than ascii due to the lack of support for encodings. This library should help with that.

category:             Codec
abi:                  51ecb485bd711ae29d051817c9323ca7
exposed:              True
exposed-modules:
    Control.Throws Data.Encoding Data.Encoding.ASCII
    Data.Encoding.BootString Data.Encoding.ByteSink
    Data.Encoding.ByteSource Data.Encoding.CP1250 Data.Encoding.CP1251
    Data.Encoding.CP1252 Data.Encoding.CP1253 Data.Encoding.CP1254
    Data.Encoding.CP1255 Data.Encoding.CP1256 Data.Encoding.CP1257
    Data.Encoding.CP1258 Data.Encoding.CP437 Data.Encoding.CP737
    Data.Encoding.CP775 Data.Encoding.CP850 Data.Encoding.CP852
    Data.Encoding.CP855 Data.Encoding.CP857 Data.Encoding.CP860
    Data.Encoding.CP861 Data.Encoding.CP862 Data.Encoding.CP863
    Data.Encoding.CP864 Data.Encoding.CP865 Data.Encoding.CP866
    Data.Encoding.CP869 Data.Encoding.CP874 Data.Encoding.CP932
    Data.Encoding.Exception Data.Encoding.GB18030 Data.Encoding.ISO2022
    Data.Encoding.ISO2022JP Data.Encoding.ISO88591
    Data.Encoding.ISO885910 Data.Encoding.ISO885911
    Data.Encoding.ISO885913 Data.Encoding.ISO885914
    Data.Encoding.ISO885915 Data.Encoding.ISO885916
    Data.Encoding.ISO88592 Data.Encoding.ISO88593
    Data.Encoding.ISO88594 Data.Encoding.ISO88595
    Data.Encoding.ISO88596 Data.Encoding.ISO88597
    Data.Encoding.ISO88598 Data.Encoding.ISO88599
    Data.Encoding.JISX0201 Data.Encoding.JISX0208
    Data.Encoding.JISX0212 Data.Encoding.KOI8R Data.Encoding.KOI8U
    Data.Encoding.MacOSRoman Data.Encoding.ShiftJIS Data.Encoding.UTF16
    Data.Encoding.UTF32 Data.Encoding.UTF8 Data.Static
    System.IO.Encoding

hidden-modules:
    Data.Encoding.Base Data.Array.Static Data.Map.Static Data.CharMap

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/encoding-0.10.2
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/encoding-0.10.2
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/encoding-0.10.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-encoding
hs-libraries:         HSencoding-0.10.2-6eIjoAHUBt89wLoutlfUYD
include-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/encoding-0.10.2/include

includes:             system_encoding.h
depends:
    array-0.5.8.0 base-4.18.3.0 binary-0.8.9.1 bytestring-0.11.5.4
    containers-0.6.7
    extensible-exceptions-0.1.1.4-CNAlK8LvrH1EafsJXtad6L
    ghc-prim-0.10.0 mtl-2.3.1
    regex-compat-0.95.2.2-K7oxv3y9MR6EkVpN6XHsIK

haddock-interfaces:   /usr/share/doc/haskell-encoding/html/encoding.haddock
haddock-html:         /usr/share/doc/haskell-encoding/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

