#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 feed
version:              1.3.2.1
visibility:           public
id:                   feed-1.3.2.1-A7MfsqJUyK24hDJCEKuMIk
key:                  feed-1.3.2.1-A7MfsqJUyK24hDJCEKuMIk
license:              BSD-3-Clause
maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Sigbjorn Finne <sof@forkIO.com>
homepage:             https://github.com/haskell-party/feed
synopsis:             Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.
description:
    Interfacing with RSS (v 0.9x, 2.x, 1.0) + Atom feeds.

    To help working with the multiple feed formats we'\''ve
    ended up with, this set of modules provides parsers,
    pretty printers and some utility code for querying
    and just generally working with a concrete representation
    of feeds in Haskell.

    See here for an example of how to create an Atom feed:
    <https://github.com/haskell-party/feed/blob/master/tests/Example/CreateAtom.hs>

    For basic reading and editing of feeds, consult
    the documentation of the Text.Feed.* hierarchy.

category:             Text
abi:                  b5b07122ac0b3a1df5308e9b6ddfc739
exposed:              True
exposed-modules:
    Text.Atom.Feed Text.Atom.Feed.Export Text.Atom.Feed.Import
    Text.Atom.Feed.Link Text.Atom.Feed.Validate Text.Atom.Pub
    Text.Atom.Pub.Export Text.DublinCore.Types Text.Feed.Constructor
    Text.Feed.Export Text.Feed.Import Text.Feed.Query
    Text.Feed.Translate Text.Feed.Types Text.Feed.Util Text.RSS.Export
    Text.RSS.Import Text.RSS.Syntax Text.RSS1.Export Text.RSS1.Import
    Text.RSS1.Syntax Text.RSS1.Utils

hidden-modules:       Data.Text.Util Data.XML.Compat
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/feed-1.3.2.1
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/feed-1.3.2.1
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/feed-1.3.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-feed
hs-libraries:         HSfeed-1.3.2.1-A7MfsqJUyK24hDJCEKuMIk
depends:
    base-4.18.3.0 base-compat-0.14.1-FK5GrXzRHJlIaqVbFVqjup
    bytestring-0.11.5.4 old-locale-1.0.0.7-HSvLS5bQrOr2jPp7CISS55
    old-time-1.1.0.4-7DjbqVsKRf12Y2J1NtDBv4
    safe-0.3.21-40SDg1d9ZKLLr4MVwyQcdM text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-DIWgkHGP9mx2wx7sQucXXs
    utf8-string-1.0.2-shiuprzUpU7bW4pJ3bW0
    xml-conduit-1.9.1.4-9wjJD2LLb6N67VeyNzHCwl
    xml-types-0.3.8-O6B3Z1rgoK5oMm4hXwsMN

haddock-interfaces:   /usr/share/doc/haskell-feed/html/feed.haddock
haddock-html:         /usr/share/doc/haskell-feed/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

