#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   gi-cairo-render
version:                0.1.2
visibility:             public
id:                     gi-cairo-render-0.1.2-7hLw3etgxJiJL643BzdxfY
key:                    gi-cairo-render-0.1.2-7hLw3etgxJiJL643BzdxfY
license:                BSD-3-Clause
copyright:
    (c) 2018 Kilian Kilger, (c) 2001-2010 The Gtk2Hs Team, (c) Paolo Martini 2005, (c) Abraham Egnor 2003, 2004, (c) Aetion Technologies LLC 2004

maintainer:             Kilian Kilger (kkilger@gmail.com)
author:                 Axel Simon, Duncan Coutts
stability:              experimental
homepage:               https://github.com/cohomology/gi-cairo-render
synopsis:               GI friendly Binding to the Cairo library.
description:
    Cairo is a library to render high quality vector graphics. There
    exist various backends that allows rendering to Gtk windows, PDF,
    PS, PNG and SVG documents, amongst others.

category:               Graphics
abi:                    0edfb6d8b2a413e6b9189b5912fd07c9
exposed:                True
exposed-modules:
    GI.Cairo.Render GI.Cairo.Render.Internal GI.Cairo.Render.Matrix
    GI.Cairo.Render.Types

hidden-modules:
    GI.Cairo.Render.Internal.Drawing.Cairo
    GI.Cairo.Render.Internal.Drawing.Paths
    GI.Cairo.Render.Internal.Drawing.Patterns
    GI.Cairo.Render.Internal.Drawing.Text
    GI.Cairo.Render.Internal.Drawing.Transformations
    GI.Cairo.Render.Internal.Fonts.FontOptions
    GI.Cairo.Render.Internal.Surfaces.Image
    GI.Cairo.Render.Internal.Surfaces.PNG
    GI.Cairo.Render.Internal.Surfaces.Surface
    GI.Cairo.Render.Internal.Utilities
    GI.Cairo.Render.Internal.Surfaces.PDF
    GI.Cairo.Render.Internal.Surfaces.PS
    GI.Cairo.Render.Internal.Surfaces.SVG
    GI.Cairo.Render.Internal.Region

import-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/gi-cairo-render-0.1.2

library-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/gi-cairo-render-0.1.2
    /usr/lib

library-dirs-static:
    /usr/lib/ghc-9.6.7.20250817/site-local/gi-cairo-render-0.1.2
    /usr/lib

dynamic-library-dirs:   /usr/lib /usr/lib
data-dir:               /usr/share/haskell-gi-cairo-render
hs-libraries:           HSgi-cairo-render-0.1.2-7hLw3etgxJiJL643BzdxfY
extra-libraries:        cairo-gobject gobject-2.0 glib-2.0 cairo png16 z
extra-libraries-static:
    cairo-gobject m dl gobject-2.0 glib-2.0 atomic m sysprof-capture-4
    pcre2-8 pthread ffi cairo m dl fontconfig m expat m freetype dl bz2
    brotlidec brotlicommon Xext Xrender X11 pthread xcb-render xcb-shm
    xcb Xau Xdmcp pixman-1 m png16 m m z

include-dirs:
    /usr/include/cairo /usr/include /usr/include/glib-2.0
    /usr/lib/glib-2.0/include /usr/include/sysprof-6
    /usr/include/freetype2 /usr/include/pixman-1 /usr/include/libpng16

depends:
    array-0.5.8.0 base-4.18.3.0 bytestring-0.11.5.4
    haskell-gi-base-0.26.9-Dh0Tv37sNz0L20Qf21meJc mtl-2.3.1 text-2.0.2
    utf8-string-1.0.2-shiuprzUpU7bW4pJ3bW0

haddock-interfaces:
    /usr/share/doc/haskell-gi-cairo-render/html/gi-cairo-render.haddock

haddock-html:           /usr/share/doc/haskell-gi-cairo-render/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

