#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 happstack-server
version:              7.9.3
visibility:           public
id:                   happstack-server-7.9.3-2PLiL3d9TVFL0cqCSE3BLV
key:                  happstack-server-7.9.3-2PLiL3d9TVFL0cqCSE3BLV
license:              BSD-3-Clause
maintainer:           Happstack team <happs@googlegroups.com>
author:               Happstack team, HAppS LLC
homepage:             http://happstack.com
synopsis:             Web related tools and services.
description:
    Happstack Server provides an HTTP server and a rich set of functions for routing requests, handling query parameters, generating responses, working with cookies, serving files, and more. For in-depth documentation see the Happstack Crash Course <http://happstack.com/docs/crashcourse/index.html>

category:             Web, Happstack
abi:                  759fc073427b4d3e2d29611a2809cf8d
exposed:              True
exposed-modules:
    Happstack.Server Happstack.Server.Auth Happstack.Server.Compression
    Happstack.Server.Cookie Happstack.Server.Error
    Happstack.Server.FileServe
    Happstack.Server.FileServe.BuildingBlocks Happstack.Server.I18N
    Happstack.Server.Internal.Compression
    Happstack.Server.Internal.Cookie Happstack.Server.Internal.Handler
    Happstack.Server.Internal.Listen
    Happstack.Server.Internal.LogFormat
    Happstack.Server.Internal.LowLevel
    Happstack.Server.Internal.MessageWrap
    Happstack.Server.Internal.Monads
    Happstack.Server.Internal.Multipart
    Happstack.Server.Internal.RFC822Headers
    Happstack.Server.Internal.Socket
    Happstack.Server.Internal.TimeoutIO
    Happstack.Server.Internal.TimeoutManager
    Happstack.Server.Internal.TimeoutSocket
    Happstack.Server.Internal.Types Happstack.Server.Monads
    Happstack.Server.Response Happstack.Server.Routing
    Happstack.Server.RqData Happstack.Server.SURI
    Happstack.Server.SimpleHTTP Happstack.Server.Types
    Happstack.Server.Validation

hidden-modules:
    Happstack.Server.Internal.Clock Happstack.Server.Internal.LazyLiner
    Happstack.Server.SURI.ParseURI Paths_happstack_server

import-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/happstack-server-7.9.3

library-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/happstack-server-7.9.3

library-dirs-static:
    /usr/lib/ghc-9.6.7.20250817/site-local/happstack-server-7.9.3

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-happstack-server
hs-libraries:         HShappstack-server-7.9.3-2PLiL3d9TVFL0cqCSE3BLV
depends:
    base-4.18.3.0 base64-bytestring-1.2.1.0-BS9gtxrEakSHvE7f2JUUy0
    blaze-html-0.9.2.0-8WIp6HTeEceATvvtNDLUeY bytestring-0.11.5.4
    containers-0.6.7 directory-1.3.8.5 exceptions-0.10.7
    extensible-exceptions-0.1.1.4-CNAlK8LvrH1EafsJXtad6L
    filepath-1.4.301.0 hslogger-1.3.2.0-9Q1B17t5tAJHzDYELWWJyh
    html-1.0.1.2-2ECuZcBgbxfLZZSDI80aad
    monad-control-1.0.3.1-FK5MwN7CLMeDFbgWPeqycv mtl-2.3.1
    network-3.1.4.0-BquykiICeEU8GLDFE071Z9
    network-uri-2.6.4.2-6QuJNuv1Ns4Gzjjs76diWh parsec-3.1.16.1
    process-1.6.19.0 sendfile-0.7.11.6-14Ow2DJpaZxHjCWetGCsQR
    syb-0.7.3-4faDNy9a4q18QDGKds5is3
    system-filepath-0.4.14.1-IxRDEIhRNLTId2Q9PfGCQC text-2.0.2
    threads-0.5.1.8-HPBepvnW4RJ4aI0dxA0iWM time-1.12.2
    transformers-0.6.1.0 transformers-base-0.4.6-KecQozQ2bJs3HLDcaEYSEy
    unix-2.8.6.0 utf8-string-1.0.2-shiuprzUpU7bW4pJ3bW0
    xhtml-3000.2.2.1 zlib-0.7.0.0-DS6Da0uFkVx9bSXatFvIRX

haddock-interfaces:
    /usr/share/doc/haskell-happstack-server/html/happstack-server.haddock

haddock-html:         /usr/share/doc/haskell-happstack-server/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

