#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.51.2
visibility:           public
id:                   hledger-lib-1.51.2-3BDuGcSS1L2Bebp30yTvL7
key:                  hledger-lib-1.51.2-3BDuGcSS1L2Bebp30yTvL7
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  1502c436c84cef7aa6a320b90d217467
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.BalanceData Hledger.Data.Balancing
    Hledger.Data.Currency Hledger.Data.Dates Hledger.Data.DayPartition
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period Hledger.Data.PeriodData
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.HtmlCommon Hledger.Write.Html.Lucid
    Hledger.Write.Ods Hledger.Write.Spreadsheet Text.Tabular.AsciiWide
    Text.WideString

hidden-modules:       Paths_hledger_lib
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/hledger-lib-1.51.2
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/hledger-lib-1.51.2
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/hledger-lib-1.51.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.51.2-3BDuGcSS1L2Bebp30yTvL7
depends:
    Decimal-0.5.2-3onDWPtp7xUFSBbOX9U0bB
    Glob-0.10.2-rVkQWpLq53EB1FOPxXj59
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj
    aeson-pretty-0.8.10-8anOyWTbAS8AdZOxeZakOK
    ansi-terminal-1.1-4EeIQsn6Wrq78PCXTndXTh array-0.5.8.0
    base-4.18.3.0 blaze-html-0.9.2.0-8WIp6HTeEceATvvtNDLUeY
    blaze-markup-0.8.3.0-AVC8fE8eFlN3Vkv62b7Q3K bytestring-0.11.5.4
    call-stack-0.4.0-CNBVTySS9dB7ZkKYIwNNi0
    cassava-0.5.4.1-JTeQQEztkdw1YqwHXQijYa
    cassava-megaparsec-2.1.1-72mp3GPRJeyBcneZMp4Art
    cmdargs-0.10.22-1ARObHkVbOT1HJZIaJM1AG
    colour-2.3.6-DoApLSa6gBO3p6mb77xRwR containers-0.6.7
    data-default-0.7.1.3-HKcyKL8L1MB9BLPHC3Cuts deepseq-1.4.8.1
    directory-1.3.8.5 doclayout-0.5-J0gBPrMFkRdKFXkZzBLWIL
    encoding-0.10.2-6eIjoAHUBt89wLoutlfUYD
    extra-1.7.16-6ZwXlNpxrkMIvGHgrs9GlE
    file-embed-0.0.16.0-Heqv1MGULDp1AU5LH7qKhb filepath-1.4.301.0
    hashtables-1.4.2-1eLJR8e38kkFGz3G15ucad
    lucid-2.11.20250303-F7GLijWD65d8Epd5pwLj8K
    megaparsec-9.7.0-6iSCkwAigkw2HX9j1KdNdR
    microlens-0.4.14.0-4ENPj0tHNR0GzcdT8Xo5Q8
    microlens-th-0.4.3.17-F1IcXkuPeIB4kMaxwhk9vS mtl-2.3.1
    parser-combinators-1.3.1-9vMhwhkmOfnJdFJIbGzYgC
    pretty-simple-4.1.4.0-28BuHbBrLRV5EcY4mEV489 process-1.6.19.0
    regex-tdfa-1.3.2.5-Epq9AbwCUJF5ybNEnhsg9i
    safe-0.3.21-40SDg1d9ZKLLr4MVwyQcdM
    tabular-0.2.2.8-Fk6RHZAgQbgAXbmw3wtbhl
    tasty-1.5.2-1URN3hwk0ElEsqpxhMRHaT
    tasty-hunit-0.10.2-EWBbmTGIprlIBgm72wWDKr template-haskell-2.20.0.0
    terminal-size-0.3.4-ERELAzA1ntr5GhYaq5Io1s text-2.0.2
    these-1.2.1-8yONRQ8fpJ8Up4VI4BEBS time-1.12.2
    timeit-2.0-3rjf8pWUG7zHO3IF6mVMhN transformers-0.6.1.0
    uglymemo-0.1.0.1-GNjZ8dXwuVlCyh2kFfkaav
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    utf8-string-1.0.2-shiuprzUpU7bW4pJ3bW0

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

