#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 jose
version:              0.10
visibility:           public
id:                   jose-0.10-2KjX3hWFEPH2LKbADVQTSQ
key:                  jose-0.10-2KjX3hWFEPH2LKbADVQTSQ
license:              Apache-2.0
copyright:            Copyright (C) 2013-2021  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    JSON Object Signing and Encryption (JOSE) and JSON Web Token (JWT) library

description:

    Implementation of JSON Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519).

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) and secp256k1 (RFC 8812) are supported.

    JWK Thumbprint (RFC 7638) is supported.

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  6a2b03ad9367a5ca12bd517dc44c3f7d
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.URI

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/jose-0.10
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/jose-0.10
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/jose-0.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-jose
hs-libraries:         HSjose-0.10-2KjX3hWFEPH2LKbADVQTSQ
depends:
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj base-4.18.3.0
    base64-bytestring-1.2.1.0-BS9gtxrEakSHvE7f2JUUy0
    bytestring-0.11.5.4 concise-0.1.0.1-Cav5VcB58NmGrYEIJOOjAJ
    containers-0.6.7 cryptonite-0.30-IL2WPKHlFI57ib52whBGGT
    lens-5.3.3-6TZOZw3Ux3V6t2rrVbYkS9
    memory-0.18.0-88e9qUoXE6r5vKO4tKELUs
    monad-time-0.4.0.0-I9pgMR4B2beCVKwC62Xr3j mtl-2.3.1
    network-uri-2.6.4.2-6QuJNuv1Ns4Gzjjs76diWh
    template-haskell-2.20.0.0 text-2.0.2 time-1.12.2
    x509-1.7.7-HyOJZLu2YIW86q8EXDPj2k

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

