#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lattices
version:              2.2.1
visibility:           public
id:                   lattices-2.2.1-CFMDGRvm2Fy2MuxVWo7uBu
key:                  lattices-2.2.1-CFMDGRvm2Fy2MuxVWo7uBu
license:              BSD-3-Clause
copyright:
    (C) 2010-2015 Maximilian Bolingbroke, 2016-2019 Oleg Grenrus

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    Maximilian Bolingbroke <batterseapower@hotmail.com>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             http://github.com/phadej/lattices/
synopsis:
    Fine-grained library for constructing and manipulating lattices

description:
    In mathematics, a lattice is a partially ordered set in which every two
    elements @x@ and @y@ have a unique supremum (also called a least upper bound, join, or @x /\\ y@)
    and a unique infimum (also called a greatest lower bound, meet, or @x \\/ y@).

    This package provide type-classes for different lattice types, as well
    as a class for the partial order.

category:             Math
abi:                  2547285112355707094628ed1cd59814
exposed:              True
exposed-modules:
    Algebra.Heyting Algebra.Heyting.Free Algebra.Heyting.Free.Expr
    Algebra.Lattice Algebra.Lattice.Divisibility
    Algebra.Lattice.Dropped Algebra.Lattice.Free
    Algebra.Lattice.Free.Final Algebra.Lattice.Levitated
    Algebra.Lattice.Lexicographic Algebra.Lattice.Lifted
    Algebra.Lattice.M2 Algebra.Lattice.M3 Algebra.Lattice.N5
    Algebra.Lattice.Op Algebra.Lattice.Ordered Algebra.Lattice.Unicode
    Algebra.Lattice.Wide Algebra.Lattice.ZeroHalfOne Algebra.PartialOrd
    Algebra.PartialOrd.Instances

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/lattices-2.2.1
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/lattices-2.2.1
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/lattices-2.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lattices
hs-libraries:         HSlattices-2.2.1-CFMDGRvm2Fy2MuxVWo7uBu
depends:
    QuickCheck-2.15.0.1-Lq4ECkPzV8iDkKvRhPZIAs base-4.18.3.0
    containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-17jkMnZLQLs4o2IKp4JpPo
    integer-logarithms-1.0.4-4N4Voh7udE2AK4oCYhuShB
    tagged-0.8.9-HMh4qZxoofeBZ9IcdInbXO transformers-0.6.1.0
    universe-base-1.1.4-7KfP8H50Oa1H63GGQUbqCm
    universe-reverse-instances-1.1.2-8XTLNzuRh7j29JmLpUhXnz
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg

haddock-interfaces:   /usr/share/doc/haskell-lattices/html/lattices.haddock
haddock-html:         /usr/share/doc/haskell-lattices/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

