#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lens-family-core
version:              2.1.3
visibility:           public
id:                   lens-family-core-2.1.3-79Avxgn2EcYFPd4oZIprFN
key:                  lens-family-core-2.1.3-79Avxgn2EcYFPd4oZIprFN
license:              BSD-3-Clause
copyright:
    Copyright (C) 2012,2013,2014,2017,2018,2019 Russell O'\''Connor

maintainer:           Russell O'\''Connor <roconnor@r6.ca>
author:               Russell O'\''Connor
stability:            experimental
synopsis:             Haskell 2022 Lens Families
description:
    This package provides first class(†) functional references in Van Laarhoven style supporting the following optics:

    * Lenses (view, over)

    * Traversals (toListOf, matching, over)

    * Setters (over)

    * Grates (zipWithOf, under, review)

    * Resetters (under)

    * Adapters (view, review)

    * Grids (toListOf, over / under, review)

    * Prisms (matching, over / under, review)

    * Getters (view)

    * Folders (toListOf)

    * Reviewers (review)

    (†) For optimal first-class support use the @lens-family@ package with rank 2 / rank N polymorphism.
    "Lens.Family.Clone" allows for first-class support of lenses and traversals for those who cannot support rank 2 polymorphism.

category:             Data, Lenses
abi:                  7a814d9f2ddcc074ee09158eed7bf95b
exposed:              True
exposed-modules:
    Lens.Family Lens.Family.Clone Lens.Family.State
    Lens.Family.State.Lazy Lens.Family.State.Strict Lens.Family.Stock
    Lens.Family.Unchecked

hidden-modules:
    Lens.Family.Identical Lens.Family.Phantom Lens.Family.State.Zoom

import-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/lens-family-core-2.1.3

library-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/lens-family-core-2.1.3

library-dirs-static:
    /usr/lib/ghc-9.6.7.20250817/site-local/lens-family-core-2.1.3

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lens-family-core
hs-libraries:         HSlens-family-core-2.1.3-79Avxgn2EcYFPd4oZIprFN
depends:              base-4.18.3.0 containers-0.6.7 transformers-0.6.1.0
haddock-interfaces:
    /usr/share/doc/haskell-lens-family-core/html/lens-family-core.haddock

haddock-html:         /usr/share/doc/haskell-lens-family-core/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

