#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.16.0.0
visibility:           public
id:                   lsp-test-0.16.0.0-D84rY6BY8CIBoTMvxoB6zo
key:                  lsp-test-0.16.0.0-D84rY6BY8CIBoTMvxoB6zo
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  0d0297dc28c6eb75b83996caf93111b9
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.1-9vMhwhkmOfnJdFJIbGzYgC:Control.Applicative.Combinators,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.2.0-LtwEReadCMOIwd99YMVxfK:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Message from lsp-types-2.0.2.0-LtwEReadCMOIwd99YMVxfK:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.2.0-LtwEReadCMOIwd99YMVxfK:Language.LSP.Protocol.Types,
    Language.LSP.Test

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/lsp-test-0.16.0.0
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/lsp-test-0.16.0.0
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/lsp-test-0.16.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.16.0.0-D84rY6BY8CIBoTMvxoB6zo
depends:
    Diff-0.5-Je25SsO7JvB1yEEgbSKPbT Glob-0.10.2-rVkQWpLq53EB1FOPxXj59
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj
    aeson-pretty-0.8.10-8anOyWTbAS8AdZOxeZakOK
    ansi-terminal-1.1-4EeIQsn6Wrq78PCXTndXTh
    async-2.2.5-1ovq96REeQVKYsP5cduurl base-4.18.3.0
    bytestring-0.11.5.4 co-log-core-0.3.2.5-72jbDYFNA8jDYkBPjhqE8r
    conduit-1.3.6.1-5nRnREmQGNF6wlJgtv7D97
    conduit-parse-0.2.1.1-2OnkB4plInIFo2j9sy0oL6 containers-0.6.7
    data-default-0.7.1.3-HKcyKL8L1MB9BLPHC3Cuts directory-1.3.8.5
    exceptions-0.10.7 filepath-1.4.301.0
    lens-5.3.3-6TZOZw3Ux3V6t2rrVbYkS9
    lens-aeson-1.2.3-4wTG2PnzXdDit7GSDrUlR
    lsp-2.2.0.0-KoSBgvG8s7nFbPNb04NfQR
    lsp-types-2.0.2.0-LtwEReadCMOIwd99YMVxfK mtl-2.3.1
    parser-combinators-1.3.1-9vMhwhkmOfnJdFJIbGzYgC process-1.6.19.0
    row-types-1.0.1.2-JtzTFDknLEkAcKyI0hBIOR
    some-1.0.6-FruGMyVfnG6aUOQ8KkFt2 text-2.0.2 time-1.12.2
    transformers-0.6.1.0 unix-2.8.6.0

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

