#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 pipes-safe
version:              2.3.5
visibility:           public
id:                   pipes-safe-2.3.5-EAZcYrm7l7z2DG3MvKCyqp
key:                  pipes-safe-2.3.5-EAZcYrm7l7z2DG3MvKCyqp
license:              BSD-3-Clause
copyright:            2013, 2014 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Safety for the pipes ecosystem
description:
    This package adds resource management and exception handling to the @pipes@
    ecosystem.

    Notable features include:

    * /Resource Safety/: Guarantee finalization using @finally@, @bracket@ and
    more

    * /Exception Safety/: Even against asynchronous exceptions!

    * /Laziness/: Only acquire resources when you need them

    * /Promptness/: Finalize resources early when you are done with them

    * /Native Exception Handling/: Catch and resume from exceptions inside pipes

    * /No Buy-in/: Mix resource-safe pipes with unmanaged pipes using @hoist@

category:             Control, Pipes, Error Handling
abi:                  5c07c0f978c135b52e4e57ebc3766c33
exposed:              True
exposed-modules:      Pipes.Safe Pipes.Safe.Prelude
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/pipes-safe-2.3.5
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/pipes-safe-2.3.5
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/pipes-safe-2.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-pipes-safe
hs-libraries:         HSpipes-safe-2.3.5-EAZcYrm7l7z2DG3MvKCyqp
depends:
    base-4.18.3.0 containers-0.6.7 exceptions-0.10.7
    monad-control-1.0.3.1-FK5MwN7CLMeDFbgWPeqycv mtl-2.3.1
    pipes-4.3.16-C5wtPVlnu3DGanv76WOVKN
    primitive-0.9.1.0-GYJhpUEcsq4755gfDRC2m0 transformers-0.6.1.0
    transformers-base-0.4.6-KecQozQ2bJs3HLDcaEYSEy

haddock-interfaces:   /usr/share/doc/haskell-pipes-safe/html/pipes-safe.haddock
haddock-html:         /usr/share/doc/haskell-pipes-safe/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

