#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 scotty
version:              0.22
visibility:           public
id:                   scotty-0.22-HJ8TI8CFE4p54M1Id1ZIgr
key:                  scotty-0.22-HJ8TI8CFE4p54M1Id1ZIgr
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  d1ccbeb256c49abb6cd384d5d11d117c
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/scotty-0.22
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/scotty-0.22
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/scotty-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.22-HJ8TI8CFE4p54M1Id1ZIgr
depends:
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj base-4.18.3.0
    blaze-builder-0.4.4.1-3S17E8wm5XE4Chq6ULhvf8 bytestring-0.11.5.4
    case-insensitive-1.2.1.0-EV7LFLdw26GITlLZKOJrjF
    cookie-0.5.0-2LVVVReBYptDvnCGLFWIlO
    data-default-class-0.1.2.2-25gAM82RrwXGN749A1StTw exceptions-0.10.7
    http-types-0.12.4-J3nJ0CyBWeuE063Mvy4vWu
    monad-control-1.0.3.1-FK5MwN7CLMeDFbgWPeqycv mtl-2.3.1
    network-3.1.4.0-BquykiICeEU8GLDFE071Z9
    regex-compat-0.95.2.2-K7oxv3y9MR6EkVpN6XHsIK
    resourcet-1.2.6-Lvj5aoxzR3EHgmyK4IpvQl stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.6.1.0
    transformers-base-0.4.6-KecQozQ2bJs3HLDcaEYSEy
    unliftio-0.2.25.1-4aKQNqWKzstFgx6o9VlG33
    wai-3.2.4-JgHVHVsCFCo843d0Qkrc1R
    wai-extra-3.1.18-I2p7ibCVxeF6XTTdsD3mtS
    warp-3.4.0-CuKNebcSzM14FP8PUPaUVP

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

