#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-GnkZvklK6UHDHIgKGWCHp0
key:                  snap-core-1.0.5.1-GnkZvklK6UHDHIgKGWCHp0
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  d361330f679df1dd748ba9b2ab5bb0ec
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/snap-core-1.0.5.1
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-GnkZvklK6UHDHIgKGWCHp0
depends:
    HUnit-1.6.2.0-3WxKawST6La9vkupaT87KS
    attoparsec-0.14.4-LMUtUfKC5plL7ZZhgWxit1 base-4.18.3.0
    bytestring-0.11.5.4 case-insensitive-1.2.1.0-EV7LFLdw26GITlLZKOJrjF
    containers-0.6.7 directory-1.3.8.5 filepath-1.4.301.0
    hashable-1.4.7.0-17jkMnZLQLs4o2IKp4JpPo
    io-streams-1.5.2.2-DlB4wJByExj5opN5FVe8Ta
    lifted-base-0.2.3.12-IVPotbRKgpV4XWohxm9AEV
    monad-control-1.0.3.1-FK5MwN7CLMeDFbgWPeqycv mtl-2.3.1
    network-3.1.4.0-BquykiICeEU8GLDFE071Z9
    network-uri-2.6.4.2-6QuJNuv1Ns4Gzjjs76diWh
    old-locale-1.0.0.7-HSvLS5bQrOr2jPp7CISS55
    random-1.2.1.3-GswEfj1SZ276IcAtylwQ0f
    readable-0.3.1-2y7UF5xxIFeJsaLEmwVT9f
    regex-posix-0.96.0.2-5io6mw87knoCnGAankEkLx text-2.0.2 time-1.12.2
    transformers-0.6.1.0 transformers-base-0.4.6-KecQozQ2bJs3HLDcaEYSEy
    unix-compat-0.7.4.1-KQpzxaZRaJzE7ZcvOnYp8s
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    vector-0.13.2.0-BINMV7y6ibUKgFTnLXEi1A

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

