#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tamarin-prover-utils
version:              1.10.0
visibility:           public
id:                   tamarin-prover-utils-1.10.0-C8dohoDBMgB7DZ9kSWUyGP
key:                  tamarin-prover-utils-1.10.0-C8dohoDBMgB7DZ9kSWUyGP
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  d52ad63b85f1e8a50df5732d3684665e
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.EnvTracer Debug.Trace.Ignore Extension.Data.ByteString
    Extension.Data.Label Extension.Data.Monoid Extension.Prelude
    Logic.Connectives System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/tamarin-prover-utils-1.10.0

library-dirs:
    /usr/lib/ghc-9.6.7.20250817/site-local/tamarin-prover-utils-1.10.0

library-dirs-static:
    /usr/lib/ghc-9.6.7.20250817/site-local/tamarin-prover-utils-1.10.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.10.0-C8dohoDBMgB7DZ9kSWUyGP
depends:
    SHA-1.6.4.4-69yKsD90Hrj37T0pIhf9r2 base-4.18.3.0
    base64-bytestring-1.2.1.0-BS9gtxrEakSHvE7f2JUUy0 binary-0.8.9.1
    blaze-builder-0.4.4.1-3S17E8wm5XE4Chq6ULhvf8 bytestring-0.11.5.4
    containers-0.6.7 deepseq-1.4.8.1 dlist-1.0-INK6ndPYH7QL7JTi9xHVWN
    exceptions-0.10.7 fclabels-2.0.5.1-5QbpyXvvZ401ZBp4hhrFF2
    graphviz-2999.20.2.1-2luQcOMaSrs6htx2yUs6BJ
    list-t-1.0.5.7-I7lku1OueTi9UPL0QuaE9t mtl-2.3.1 pretty-1.1.3.6
    safe-0.3.21-40SDg1d9ZKLLr4MVwyQcdM
    split-0.2.5-4lwOpp22KBrAKpI1IR2DHQ syb-0.7.3-4faDNy9a4q18QDGKds5is3
    text-2.0.2 time-1.12.2 transformers-0.6.1.0

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

