#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-28s9rPbwh4IJ0ikXjKWNG
key:                  tree-diff-0.3.0.1-28s9rPbwh4IJ0ikXjKWNG
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  bc4de8407a7fa8d1751b96dcc9964042
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-28s9rPbwh4IJ0ikXjKWNG
depends:
    QuickCheck-2.15.0.1-Lq4ECkPzV8iDkKvRhPZIAs
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj
    ansi-terminal-1.1-4EeIQsn6Wrq78PCXTndXTh
    ansi-wl-pprint-1.0.2-Eb1VqJKgdkMGPPWKTPMCMI base-4.18.3.0
    base-compat-0.14.1-FK5GrXzRHJlIaqVbFVqjup bytestring-0.11.5.4
    containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-17jkMnZLQLs4o2IKp4JpPo parsec-3.1.16.1
    parsers-0.12.12-5k7MT67aefj6qJ6rymnCGf pretty-1.1.3.6
    primitive-0.9.1.0-GYJhpUEcsq4755gfDRC2m0
    scientific-0.3.8.0-FwKzA73aVbXJ5rDpcJgYmo
    semialign-1.3.1-98hjaFujxCEBspsGczRRix
    strict-0.5.1-2qreVmQS6xqA7wSvTCBI0d
    tagged-0.8.9-HMh4qZxoofeBZ9IcdInbXO text-2.0.2
    these-1.2.1-8yONRQ8fpJ8Up4VI4BEBS time-1.12.2
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    uuid-types-1.0.6-L9Y6dI38zycBFxOZxyUWtz
    vector-0.13.2.0-BINMV7y6ibUKgFTnLXEi1A

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

