#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 websockets
version:              0.12.7.3
visibility:           public
id:                   websockets-0.12.7.3-8QU6mtlck0DDogEfYyJ3Wr
key:                  websockets-0.12.7.3-8QU6mtlck0DDogEfYyJ3Wr
license:              BSD-3-Clause
copyright:
    (c) 2010-2011 Siniša Biđin
    (c) 2011-2018 Jasper Van der Jeugt
    (c) 2011 Steffen Schuldenzucker
    (c) 2011 Alex Lang

maintainer:           Jasper Van der Jeugt <m@jaspervdj.be>
author:
    Siniša Biđin <sinisa@bidin.cc>
    Jasper Van der Jeugt <m@jaspervdj.be>
    Steffen Schuldenzucker <steffen.schuldenzucker@googlemail.com>
    Alex Lang <lang@tsurucapital.com>

stability:            experimental
homepage:             http://jaspervdj.be/websockets
synopsis:
    A sensible and clean way to write WebSocket-capable servers in Haskell.

description:
    This library allows you to write WebSocket-capable servers.

    An example server:
    <https://github.com/jaspervdj/websockets/blob/master/example/server.lhs>

    An example client:
    <https://github.com/jaspervdj/websockets/blob/master/example/client.hs>

    See also:

    * The specification of the WebSocket protocol:
    <http://www.whatwg.org/specs/web-socket-protocol/>

    * The JavaScript API for dealing with WebSockets:
    <http://www.w3.org/TR/websockets/>

category:             Network
abi:                  194da456d9b748d32d997ec2714b0f7a
exposed:              True
exposed-modules:
    Network.WebSockets Network.WebSockets.Client
    Network.WebSockets.Connection Network.WebSockets.Extensions
    Network.WebSockets.Stream

hidden-modules:
    Network.WebSockets.Connection.Options
    Network.WebSockets.Extensions.Description
    Network.WebSockets.Extensions.PermessageDeflate
    Network.WebSockets.Extensions.StrictUnicode Network.WebSockets.Http
    Network.WebSockets.Hybi13 Network.WebSockets.Hybi13.Demultiplex
    Network.WebSockets.Hybi13.Mask Network.WebSockets.Protocol
    Network.WebSockets.Server Network.WebSockets.Types

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/websockets-0.12.7.3
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/websockets-0.12.7.3
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/websockets-0.12.7.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-websockets
hs-libraries:         HSwebsockets-0.12.7.3-8QU6mtlck0DDogEfYyJ3Wr
depends:
    SHA-1.6.4.4-69yKsD90Hrj37T0pIhf9r2
    async-2.2.5-1ovq96REeQVKYsP5cduurl
    attoparsec-0.14.4-LMUtUfKC5plL7ZZhgWxit1 base-4.18.3.0
    base64-bytestring-1.2.1.0-BS9gtxrEakSHvE7f2JUUy0 binary-0.8.9.1
    bytestring-0.11.5.4 case-insensitive-1.2.1.0-EV7LFLdw26GITlLZKOJrjF
    clock-0.8.4-2BGbmbYOzBx2VIyZruSOCY containers-0.6.7
    entropy-0.4.1.11-B6vgyfFcyO6Auv5AGPyVrZ
    network-3.1.4.0-BquykiICeEU8GLDFE071Z9
    random-1.2.1.3-GswEfj1SZ276IcAtylwQ0f
    streaming-commons-0.2.3.1-ISd8sXN2MM9WL9aabYx2N text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-websockets/html/websockets.haddock
haddock-html:         /usr/share/doc/haskell-websockets/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

