#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.51.2
visibility:           public
id:                   hledger-web-1.51.2-5IM8csVjlycC7LVHVn9jaf
key:                  hledger-web-1.51.2-5IM8csVjlycC7LVHVn9jaf
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  87bbb574519e13cf349e41676a0846f3
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.App Hledger.Web.Application
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/hledger-web-1.51.2
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/hledger-web-1.51.2
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/hledger-web-1.51.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.51.2-5IM8csVjlycC7LVHVn9jaf
depends:
    Decimal-0.5.2-3onDWPtp7xUFSBbOX9U0bB
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj base-4.18.3.0
    base64-1.0-BsltlMCfj1TIX0KDjpe8DA
    blaze-html-0.9.2.0-8WIp6HTeEceATvvtNDLUeY
    blaze-markup-0.8.3.0-AVC8fE8eFlN3Vkv62b7Q3K bytestring-0.11.5.4
    case-insensitive-1.2.1.0-EV7LFLdw26GITlLZKOJrjF
    clientsession-0.9.3.0-HKjRHBmHWy27GDLVbBGOWV
    cmdargs-0.10.22-1ARObHkVbOT1HJZIaJM1AG
    conduit-1.3.6.1-5nRnREmQGNF6wlJgtv7D97
    conduit-extra-1.3.8-6F4zXdBdSsxH7FEVAMtdPi containers-0.6.7
    data-default-0.7.1.3-HKcyKL8L1MB9BLPHC3Cuts directory-1.3.8.5
    extra-1.7.16-6ZwXlNpxrkMIvGHgrs9GlE
    file-embed-0.0.16.0-Heqv1MGULDp1AU5LH7qKhb filepath-1.4.301.0
    githash-0.1.6.3-I8UQTgWKBOSFNbvtVSw20Y
    hjsmin-0.2.1-C64xDHoBcMdBqjYpgoqpmQ
    hledger-1.51.2-5BXszUVLZ7K4UZ5f9WSOjU
    hledger-lib-1.51.2-3BDuGcSS1L2Bebp30yTvL7
    hspec-2.11.4-9isqSVvT7QsDSt7HQZm1g2
    http-client-0.7.19-CS7nt6M2hIg4TRHBOC9VL7
    http-conduit-2.3.9.1-6NMT7isJoG35ZNJeS0m6Qu
    http-types-0.12.4-J3nJ0CyBWeuE063Mvy4vWu
    megaparsec-9.7.0-6iSCkwAigkw2HX9j1KdNdR mtl-2.3.1
    network-3.1.4.0-BquykiICeEU8GLDFE071Z9
    safe-0.3.21-40SDg1d9ZKLLr4MVwyQcdM
    shakespeare-2.1.7-CiegJBbI9nEtXJOrJ9qh0 template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unix-compat-0.7.4.1-KQpzxaZRaJzE7ZcvOnYp8s
    unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    utf8-string-1.0.2-shiuprzUpU7bW4pJ3bW0
    wai-3.2.4-JgHVHVsCFCo843d0Qkrc1R
    wai-cors-0.2.7-5ErTlsoofY4BXhbTaw3K7i
    wai-extra-3.1.18-I2p7ibCVxeF6XTTdsD3mtS
    wai-handler-launch-3.0.3.1-Ka3NuOJVFMJJOI3E9hxJFP
    warp-3.4.0-CuKNebcSzM14FP8PUPaUVP
    yaml-0.11.11.2-6Q9McMxy6rf3g61kBcfKcv
    yesod-1.6.2.1-A3BAJIor7xqKjHmhKiX5OS
    yesod-core-1.6.27.1-5WynbJ86foRFJegCUAAgcv
    yesod-form-1.7.9-3ix6B4UgN1xJSbzD1SuNAC
    yesod-static-1.6.1.0-BGlBOxwtG40GcOwp5zqHA
    yesod-test-1.6.23-AG799H12l31CRLa7J0PGua

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

