#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-7idcMbzadSQFEY09CVh25a
key:                  idris-1.3.4-7idcMbzadSQFEY09CVh25a
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  f6d8af9c4b7eb1978fb44ca8f0a84504
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.6.7.20250817/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.6.7.20250817/site-local/idris-1.3.4
library-dirs-static:  /usr/lib/ghc-9.6.7.20250817/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-7idcMbzadSQFEY09CVh25a
extra-libraries:      gmp
depends:
    aeson-2.2.0.0-C0AkopVKntgCgZgm8TP6Wj
    annotated-wl-pprint-0.7.0-BfnwRdCOYiiBGbN7HEuIto
    ansi-terminal-1.1-4EeIQsn6Wrq78PCXTndXTh
    ansi-wl-pprint-1.0.2-Eb1VqJKgdkMGPPWKTPMCMI array-0.5.8.0
    async-2.2.5-1ovq96REeQVKYsP5cduurl base-4.18.3.0
    base64-bytestring-1.2.1.0-BS9gtxrEakSHvE7f2JUUy0 binary-0.8.9.1
    blaze-html-0.9.2.0-8WIp6HTeEceATvvtNDLUeY
    blaze-markup-0.8.3.0-AVC8fE8eFlN3Vkv62b7Q3K bytestring-0.11.5.4
    cheapskate-0.1.1.2-7otQ3tTbQew6p2LOmmhVwN
    code-page-0.2.1-KL0sq19EuMI4bUG2N1N8uf containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.301.0
    fingertree-0.1.6.2-8ttFLgUD9nR3qiZ5iJngSM
    fsnotify-0.4.4.0-9jI3PiKgVLxDHEpdwEd1vk haskeline-0.8.2.1
    ieee754-0.8.0-GrjPLCdimrE81SrIB118wC
    libffi-0.2.1-I31kPfh3SzFAH6Y97HCmaD
    megaparsec-9.7.0-6iSCkwAigkw2HX9j1KdNdR mtl-2.3.1
    network-3.1.4.0-BquykiICeEU8GLDFE071Z9
    optparse-applicative-0.18.1.0-BYVre8yzbBOKektbxJ0fjC
    parser-combinators-1.3.1-9vMhwhkmOfnJdFJIbGzYgC pretty-1.1.3.6
    process-1.6.19.0 regex-tdfa-1.3.2.5-Epq9AbwCUJF5ybNEnhsg9i
    safe-0.3.21-40SDg1d9ZKLLr4MVwyQcdM
    split-0.2.5-4lwOpp22KBrAKpI1IR2DHQ
    terminal-size-0.3.4-ERELAzA1ntr5GhYaq5Io1s text-2.0.2 time-1.12.2
    transformers-0.6.1.0 uniplate-1.6.13-1hVfdUwJg9OIVMxxBjGlEn
    unix-2.8.6.0 unordered-containers-0.2.20.1-Kme465eYitW9JyEVR89fCg
    utf8-string-1.0.2-shiuprzUpU7bW4pJ3bW0
    vector-0.13.2.0-BINMV7y6ibUKgFTnLXEi1A
    vector-binary-instances-0.2.5.2-6uafN0eH5GC1WRTrKUzxT2
    zip-archive-0.4.3.2-1o9jVJzEKwrHfSEs0MeaEt

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg-9.6.7.20250817' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

