/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.api;

import io.opentracing.Span;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Configuration;
import net.jcip.annotations.ThreadSafe;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.JsonSchemaValidator;
import org.apache.solr.common.util.PathTrie;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.jersey.container.ContainerRequestUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.Method;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class V2HttpCall
extends HttpSolrCall {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Api api;
    private List<String> pathSegments;
    private String prefix;
    private boolean servedByJaxRs = false;
    HashMap<String, String> parts = new HashMap();
    static final Set<String> knownPrefixes = Set.of("cluster", "node", "collections", "cores", "c");

    public V2HttpCall(SolrDispatchFilter solrDispatchFilter, CoreContainer cc, HttpServletRequest request, HttpServletResponse response, boolean retry) {
        super(solrDispatchFilter, cc, request, response, retry);
    }

    @Override
    @SuppressForbidden(reason="Set the thread contextClassLoader for all 3rd party dependencies that we cannot control")
    protected void init() throws Exception {
        this.queryParams = SolrRequestParsers.parseQueryString(this.req.getQueryString());
        String path = this.path;
        String fullPath = path = path.substring(7);
        try {
            this.pathSegments = PathTrie.getPathSegments((String)path);
            if (this.pathSegments.size() == 0 || this.pathSegments.size() == 1 && path.endsWith("/_introspect")) {
                this.api = new Api(null){

                    @Override
                    public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
                        rsp.add("documentation", "https://solr.apache.org/guide/solr/latest/configuration-guide/v2-api.html");
                        rsp.add("description", "V2 API root path");
                    }
                };
                this.initAdminRequest(path);
                return;
            }
            this.prefix = this.pathSegments.get(0);
            boolean isCompositeApi = false;
            this.api = V2HttpCall.getApiInfo(this.cores.getRequestHandlers(), path, this.req.getMethod(), fullPath, this.parts);
            if (knownPrefixes.contains(this.prefix)) {
                if (this.api != null && !(isCompositeApi = this.api instanceof CompositeApi)) {
                    this.initAdminRequest(path);
                    return;
                }
            } else {
                if (this.api != null) {
                    this.initAdminRequest(path);
                    return;
                }
                assert (this.core == null);
            }
            if (this.pathSegments.size() > 1 && ("c".equals(this.prefix) || "collections".equals(this.prefix))) {
                this.origCorename = this.pathSegments.get(1);
                DocCollection collection = this.resolveDocCollection(this.queryParams.get("collection", this.origCorename));
                if (collection == null) {
                    if (!path.endsWith("/_introspect")) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no such collection or alias");
                    }
                } else {
                    if (List.of("delete").contains(this.req.getMethod().toLowerCase(Locale.ROOT))) {
                        this.initAdminRequest(path);
                        return;
                    }
                    boolean isPreferLeader = path.endsWith("/update") || path.contains("/update/");
                    this.core = this.getCoreByCollection(collection.getName(), isPreferLeader);
                    if (this.core == null) {
                        this.extractRemotePath(collection.getName(), collection.getName());
                        if (this.action == SolrDispatchFilter.Action.REMOTEQUERY) {
                            this.action = SolrDispatchFilter.Action.ADMIN_OR_REMOTEQUERY;
                            this.coreUrl = this.coreUrl.replace("/solr/", "/solr/____v2/c/");
                            this.path = path = path.substring(this.prefix.length() + collection.getName().length() + 2);
                            return;
                        }
                    }
                }
            } else if ("cores".equals(this.prefix)) {
                this.origCorename = this.pathSegments.get(1);
                this.core = this.cores.getCore(this.origCorename);
            }
            if (this.core == null) {
                this.initAdminRequest(path);
                return;
            }
            Thread.currentThread().setContextClassLoader(this.core.getResourceLoader().getClassLoader());
            this.path = path = path.substring(this.prefix.length() + this.pathSegments.get(1).length() + 2);
            Api apiInfo = V2HttpCall.getApiInfo(this.core.getRequestHandlers(), path, this.req.getMethod(), fullPath, this.parts);
            if (isCompositeApi && apiInfo instanceof CompositeApi) {
                ((CompositeApi)this.api).add(apiInfo);
            } else {
                this.api = apiInfo == null ? this.api : apiInfo;
            }
            this.parseRequest();
            this.addCollectionParamIfNeeded(this.getCollectionsList());
            this.action = SolrDispatchFilter.Action.PROCESS;
        }
        catch (RuntimeException rte) {
            log.error("Error in init()", (Throwable)rte);
            throw rte;
        }
        finally {
            if (this.action == null && this.api == null) {
                this.action = SolrDispatchFilter.Action.PROCESS;
            }
            if (this.solrReq != null) {
                this.solrReq.getContext().put("path", path);
            }
        }
    }

    private void initAdminRequest(String path) throws Exception {
        this.solrReq = SolrRequestParsers.DEFAULT.parse(null, path, this.req);
        this.solrReq.getContext().put(CoreContainer.class.getName(), this.cores);
        this.requestType = AuthorizationContext.RequestType.ADMIN;
        this.action = SolrDispatchFilter.Action.ADMIN;
    }

    protected void parseRequest() throws Exception {
        this.config = this.core.getSolrConfig();
        SolrRequestParsers parser = this.config.getRequestParsers();
        if (this.solrReq == null) {
            this.solrReq = parser.parse(this.core, this.path, this.req);
        }
    }

    protected DocCollection resolveDocCollection(String collectionStr) {
        if (!this.cores.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr not running in cloud mode ");
        }
        ZkStateReader zkStateReader = this.cores.getZkController().getZkStateReader();
        Supplier<DocCollection> logic = () -> {
            this.collectionsList = this.resolveCollectionListOrAlias(collectionStr);
            if (this.collectionsList.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request must be sent to a single collection or an alias that points to a single collection, but '" + collectionStr + "' resolves to " + this.collectionsList);
            }
            String collectionName = (String)this.collectionsList.get(0);
            return zkStateReader.getClusterState().getCollectionOrNull(collectionName);
        };
        DocCollection docCollection = logic.get();
        if (docCollection != null) {
            return docCollection;
        }
        try {
            zkStateReader.aliasesManager.update();
            zkStateReader.forceUpdateCollection((String)this.collectionsList.get(0));
        }
        catch (Exception e) {
            log.error("Error trying to update state while resolving collection.", (Throwable)e);
        }
        return logic.get();
    }

    public static Api getApiInfo(PluginBag<SolrRequestHandler> requestHandlers, String path, String method, String fullPath, Map<String, String> parts) {
        fullPath = fullPath == null ? path : fullPath;
        Api api = requestHandlers.v2lookup(path, method, parts);
        if (api == null && path.endsWith("/_introspect")) {
            api = requestHandlers.v2lookup(path, null, parts);
        }
        if (api == null) {
            return null;
        }
        if (api instanceof ApiBag.IntrospectApi) {
            final LinkedHashMap<String, Api> apis = new LinkedHashMap<String, Api>();
            for (String m : SolrRequest.SUPPORTED_METHODS) {
                Api x = requestHandlers.v2lookup(path, m, parts);
                if (x == null) continue;
                apis.put(m, x);
            }
            api = new CompositeApi(new Api(ApiBag.EMPTY_SPEC){

                @Override
                public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
                    String method = req.getParams().get("method");
                    HashSet<Api> added = new HashSet<Api>();
                    for (Map.Entry e : apis.entrySet()) {
                        if (method != null && !((String)e.getKey()).equals(method) || added.contains(e.getValue())) continue;
                        ((Api)e.getValue()).call(req, rsp);
                        added.add((Api)e.getValue());
                    }
                    RequestHandlerUtils.addExperimentalFormatWarning(rsp);
                }
            });
        }
        return api;
    }

    public List<String> getPathSegments() {
        return this.pathSegments;
    }

    private boolean invokeJerseyRequest(CoreContainer cores, SolrCore core, ApplicationHandler jerseyHandler, PluginBag<SolrRequestHandler> requestHandlers, SolrQueryResponse rsp) {
        return this.invokeJerseyRequest(cores, core, jerseyHandler, requestHandlers, rsp, Map.of());
    }

    private boolean invokeJerseyRequest(CoreContainer cores, SolrCore core, ApplicationHandler jerseyHandler, PluginBag<SolrRequestHandler> requestHandlers, SolrQueryResponse rsp, Map<String, String> additionalProperties) {
        ContainerRequest containerRequest = ContainerRequestUtils.createContainerRequest(this.req, this.response, (Configuration)jerseyHandler.getConfiguration());
        containerRequest.setProperty(RequestContextKeys.SOLR_QUERY_REQUEST, (Object)this.solrReq);
        containerRequest.setProperty(RequestContextKeys.SOLR_QUERY_RESPONSE, (Object)rsp);
        containerRequest.setProperty(RequestContextKeys.CORE_CONTAINER, (Object)cores);
        containerRequest.setProperty(RequestContextKeys.RESOURCE_TO_RH_MAPPING, (Object)requestHandlers.getJaxrsRegistry());
        containerRequest.setProperty(RequestContextKeys.HTTP_SERVLET_REQ, (Object)this.req);
        containerRequest.setProperty(RequestContextKeys.REQUEST_TYPE, (Object)this.requestType);
        containerRequest.setProperty(RequestContextKeys.SOLR_PARAMS, (Object)this.queryParams);
        containerRequest.setProperty("collection_name_list", (Object)this.collectionsList);
        containerRequest.setProperty(RequestContextKeys.HTTP_SERVLET_RSP, (Object)this.response);
        if (core != null) {
            containerRequest.setProperty(RequestContextKeys.SOLR_CORE, (Object)core);
        }
        if (additionalProperties != null) {
            for (Map.Entry<String, String> entry : additionalProperties.entrySet()) {
                containerRequest.setProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
        try {
            this.servedByJaxRs = true;
            jerseyHandler.handle(containerRequest);
            return containerRequest.getProperty("RESOURCE_NOT_FOUND") == null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void handleAdminOrRemoteRequest() throws IOException {
        Map<String, String> suppressNotFoundProp = Map.of("ERROR_IF_RESOURCE_NOT_FOUND", "true");
        SolrQueryResponse solrResp = new SolrQueryResponse();
        boolean jerseyResourceFound = this.invokeJerseyRequest(this.cores, null, this.cores.getJerseyApplicationHandler(), this.cores.getRequestHandlers(), solrResp, suppressNotFoundProp);
        if (jerseyResourceFound) {
            this.logAndFlushAdminRequest(solrResp);
            return;
        }
        this.sendRemoteQuery();
    }

    @Override
    protected void handleAdmin(SolrQueryResponse solrResp) {
        if (this.api == null) {
            this.invokeJerseyRequest(this.cores, null, this.cores.getJerseyApplicationHandler(), this.cores.getRequestHandlers(), solrResp);
        } else {
            SolrCore.preDecorateResponse(this.solrReq, solrResp);
            try {
                this.api.call(this.solrReq, solrResp);
            }
            catch (Exception e) {
                solrResp.setException(e);
            }
            finally {
                SolrCore.postDecorateResponse(this.handler, this.solrReq, solrResp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeCoreRequest(SolrQueryResponse rsp) {
        if (this.api == null) {
            Map<String, String> suppressNotFoundProp = Map.of("ERROR_IF_RESOURCE_NOT_FOUND", "true");
            boolean resourceFound = this.invokeJerseyRequest(this.cores, this.core, this.core.getJerseyApplicationHandler(), this.core.getRequestHandlers(), rsp, suppressNotFoundProp);
            if (!resourceFound) {
                this.response.getHeaderNames().stream().forEach(name -> this.response.setHeader(name, null));
                this.invokeJerseyRequest(this.cores, null, this.cores.getJerseyApplicationHandler(), this.cores.getRequestHandlers(), rsp);
            }
        } else {
            SolrCore.preDecorateResponse(this.solrReq, rsp);
            try {
                this.api.call(this.solrReq, rsp);
            }
            catch (Exception e) {
                rsp.setException(e);
            }
            finally {
                SolrCore.postDecorateResponse(this.handler, this.solrReq, rsp);
            }
        }
    }

    @Override
    protected void populateTracingSpan(Span span) {
        Map<String, String> pathTemplateValues;
        String coreOrColName = this.origCorename;
        if (coreOrColName == null && (coreOrColName = (pathTemplateValues = this.getUrlParts()).get("collection")) == null) {
            coreOrColName = pathTemplateValues.get("core");
        }
        if (coreOrColName != null) {
            span.setTag((Tag)Tags.DB_INSTANCE, (Object)coreOrColName);
        }
        String path = this.computeEndpointPath();
        String verb = this.req.getMethod().toLowerCase(Locale.ROOT);
        span.setOperationName(verb + ":" + path);
    }

    private String computeEndpointPath() {
        Map<Object, Object> pathTemplateValKey;
        Map<String, String> pathTemplateKeyVal = this.getUrlParts();
        if (pathTemplateKeyVal.isEmpty()) {
            pathTemplateValKey = Collections.emptyMap();
        } else if (pathTemplateKeyVal.size() == 1) {
            Map.Entry<String, String> entry = pathTemplateKeyVal.entrySet().iterator().next();
            pathTemplateValKey = Map.of(entry.getValue(), (String)entry.getKey());
        } else {
            pathTemplateValKey = new HashMap();
            for (Map.Entry entry : pathTemplateKeyVal.entrySet()) {
                pathTemplateValKey.put((String)entry.getValue(), (String)entry.getKey());
            }
        }
        StringBuilder builder = new StringBuilder();
        for (String segment : this.pathSegments) {
            builder.append('/');
            String key = (String)pathTemplateValKey.get(segment);
            if (key == null) {
                builder.append(segment);
                continue;
            }
            builder.append('{').append(key).append('}');
        }
        return builder.toString();
    }

    @Override
    protected void writeResponse(SolrQueryResponse solrRsp, QueryResponseWriter responseWriter, Method reqMethod) throws IOException {
        if (!this.servedByJaxRs) {
            super.writeResponse(solrRsp, responseWriter, reqMethod);
        }
    }

    @Override
    protected Object _getHandler() {
        return this.api;
    }

    public Map<String, String> getUrlParts() {
        return this.parts;
    }

    @Override
    protected ValidatingJsonMap getSpec() {
        return this.api == null ? null : this.api.getSpec();
    }

    @Override
    protected Map<String, JsonSchemaValidator> getValidators() {
        return this.api == null ? null : this.api.getCommandSchema();
    }

    public static class CompositeApi
    extends Api {
        private final List<Api> apis = new ArrayList<Api>();

        public CompositeApi(Api api) {
            super(ApiBag.EMPTY_SPEC);
            if (api != null) {
                this.apis.add(api);
            }
        }

        @Override
        public void call(SolrQueryRequest req, SolrQueryResponse rsp) {
            for (Api api : this.apis) {
                api.call(req, rsp);
            }
        }

        public CompositeApi add(Api api) {
            this.apis.add(api);
            return this;
        }
    }
}

