/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.IndexCommit;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.IndexFetcher;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.UpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicateFromLeader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer cc;
    private final String coreName;
    private volatile ReplicationHandler replicationProcess;
    private volatile long lastVersion = 0L;

    public ReplicateFromLeader(CoreContainer cc, String coreName) {
        this.cc = cc;
        this.coreName = coreName;
    }

    public void startReplication(boolean switchTransactionLog) {
        try (SolrCore core = this.cc.getCore(this.coreName);){
            Replica replica;
            CloudDescriptor cloudDescriptor;
            String calculatedPollIntervalString;
            if (core == null) {
                if (this.cc.isShutDown()) {
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore not found:" + this.coreName + " in " + CloudUtil.getLoadedCoreNamesAsString(this.cc));
            }
            SolrConfig.UpdateHandlerInfo uinfo = core.getSolrConfig().getUpdateHandlerInfo();
            String pollIntervalStr = "00:00:03";
            if (System.getProperty("jetty.testMode") != null) {
                pollIntervalStr = "00:00:01";
            }
            if ((calculatedPollIntervalString = ReplicateFromLeader.determinePollInterval(uinfo)) != null) {
                pollIntervalStr = calculatedPollIntervalString;
            }
            log.info("Will start replication from leader with poll interval: {}", (Object)pollIntervalStr);
            NamedList followerConfig = new NamedList();
            followerConfig.add("fetchFromLeader", (Object)Boolean.TRUE);
            boolean skipCommitOnLeaderVersionZero = switchTransactionLog;
            if (!skipCommitOnLeaderVersionZero && (cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor()) != null && (replica = this.cc.getZkController().getZkStateReader().getCollection(cloudDescriptor.getCollectionName()).getSlice(cloudDescriptor.getShardId()).getReplica(cloudDescriptor.getCoreNodeName())) != null && replica.getType() == Replica.Type.PULL) {
                skipCommitOnLeaderVersionZero = true;
            }
            followerConfig.add("skipCommitOnLeaderVersionZero", (Object)skipCommitOnLeaderVersionZero);
            followerConfig.add("pollInterval", (Object)pollIntervalStr);
            NamedList replicationConfig = new NamedList();
            replicationConfig.add("follower", (Object)followerConfig);
            String lastCommitVersion = ReplicateFromLeader.getCommitVersion(core);
            if (lastCommitVersion != null) {
                this.lastVersion = Long.parseLong(lastCommitVersion);
            }
            this.replicationProcess = new ReplicationHandler();
            if (switchTransactionLog) {
                this.replicationProcess.setPollListener((solrCore, fetchResult) -> {
                    if (fetchResult == IndexFetcher.IndexFetchResult.INDEX_FETCH_SUCCESS) {
                        String commitVersion = ReplicateFromLeader.getCommitVersion(core);
                        if (commitVersion == null) {
                            return;
                        }
                        if (Long.parseLong(commitVersion) == this.lastVersion) {
                            return;
                        }
                        UpdateLog updateLog = solrCore.getUpdateHandler().getUpdateLog();
                        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, (SolrParams)new ModifiableSolrParams());
                        CommitUpdateCommand cuc = new CommitUpdateCommand(req, false);
                        cuc.setVersion(Long.parseLong(commitVersion));
                        updateLog.commitAndSwitchToNewTlog(cuc);
                        this.lastVersion = Long.parseLong(commitVersion);
                    }
                });
            }
            this.replicationProcess.init(replicationConfig);
            this.replicationProcess.inform(core);
        }
    }

    public static String getCommitVersion(SolrCore solrCore) {
        IndexCommit commit = solrCore.getDeletionPolicy().getLatestCommit();
        try {
            String commitVersion = (String)commit.getUserData().get("commitCommandVer");
            if (commitVersion == null) {
                return null;
            }
            return commitVersion;
        }
        catch (Exception e) {
            log.warn("Cannot get commit command version from index commit point ", (Throwable)e);
            return null;
        }
    }

    public static String determinePollInterval(SolrConfig.UpdateHandlerInfo uinfo) {
        int hardCommitMaxTime = uinfo.autoCommmitMaxTime;
        int softCommitMaxTime = uinfo.autoSoftCommmitMaxTime;
        boolean hardCommitNewSearcher = uinfo.openSearcher;
        String pollIntervalStr = null;
        if (hardCommitMaxTime != -1) {
            pollIntervalStr = !(softCommitMaxTime == -1 || hardCommitNewSearcher && softCommitMaxTime > hardCommitMaxTime) ? ReplicateFromLeader.toPollIntervalStr(Math.max(hardCommitMaxTime, softCommitMaxTime) / 2) : ReplicateFromLeader.toPollIntervalStr(hardCommitMaxTime / 2);
        } else if (softCommitMaxTime != -1) {
            pollIntervalStr = ReplicateFromLeader.toPollIntervalStr(softCommitMaxTime / 2);
        }
        return pollIntervalStr;
    }

    private static String toPollIntervalStr(int ms) {
        int sec = ms / 1000;
        int hour = sec / 3600;
        int min = (sec %= 3600) / 60;
        return hour + ":" + min + ":" + (sec %= 60);
    }

    public void stopReplication() {
        if (this.replicationProcess != null) {
            this.replicationProcess.shutdown();
        }
    }
}

