/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.ConfigSetApiLockFactory;
import org.apache.solr.cloud.ConfigSetCmds;
import org.apache.solr.cloud.DistributedApiAsyncTracker;
import org.apache.solr.cloud.DistributedMultiLock;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.ZkDistributedCollectionLockFactory;
import org.apache.solr.cloud.ZkDistributedConfigSetLockFactory;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionApiLockFactory;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.DistributedCollectionCommandContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedCollectionConfigSetCommandRunner {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ZK_PATH_SEPARATOR = "/";
    private static final String ZK_DISTRIBUTED_API_ROOT = "/distributedapi";
    private static final String ZK_COLLECTION_LOCKS = "/distributedapi/collectionlocks";
    private static final String ZK_CONFIG_SET_LOCKS = "/distributedapi/configsetlocks";
    private static final String ZK_ASYNC_ROOT = "/distributedapi/async";
    private final ExecutorService distributedCollectionApiExecutorService;
    private final ExecutorService commandsExecutor;
    private final CoreContainer coreContainer;
    private final CollApiCmds.CommandMap commandMapper;
    private final CollectionCommandContext ccc;
    private final DistributedApiAsyncTracker asyncTaskTracker;
    private volatile boolean shuttingDown = false;

    public DistributedCollectionConfigSetCommandRunner(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        if (log.isInfoEnabled()) {
            log.info("Creating DistributedCollectionConfigSetCommandRunner. Collection and ConfigSet APIs are running distributed (not Overseer based)");
        }
        this.distributedCollectionApiExecutorService = new ExecutorUtil.MDCAwareThreadPoolExecutor(5, 10, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("DistributedCollectionApiExecutorService"));
        this.commandsExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(5, 20, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue(), (ThreadFactory)new SolrNamedThreadFactory("DistributedCollectionApiCommandExecutor"));
        this.ccc = new DistributedCollectionCommandContext(this.coreContainer, this.distributedCollectionApiExecutorService);
        this.commandMapper = new CollApiCmds.CommandMap(this.ccc);
        this.asyncTaskTracker = new DistributedApiAsyncTracker(this.ccc.getZkStateReader().getZkClient(), ZK_ASYNC_ROOT);
    }

    public Pair<RequestStatusState, OverseerSolrResponse> getAsyncTaskRequestStatus(String asyncId) throws Exception {
        return this.asyncTaskTracker.getAsyncTaskRequestStatus(asyncId);
    }

    public boolean deleteSingleAsyncId(String asyncId) throws Exception {
        return this.asyncTaskTracker.deleteSingleAsyncId(asyncId);
    }

    public void deleteAllAsyncIds() throws Exception {
        this.asyncTaskTracker.deleteAllAsyncIds();
    }

    public void runConfigSetCommand(SolrQueryResponse rsp, ConfigSetParams.ConfigSetAction action, Map<String, Object> result, long timeoutMs) throws Exception {
        Future<Void> taskFuture;
        if (this.shuttingDown) {
            throw new SolrException(SolrException.ErrorCode.CONFLICT, "Solr is shutting down, no more Config Set API tasks may be executed");
        }
        String configSetName = (String)result.get("name");
        String baseConfigSetName = ConfigSetCmds.getBaseConfigSetName(action, (String)result.get("baseConfigSet"));
        if (log.isInfoEnabled()) {
            log.info("Running Config Set API locally for " + action + " " + configSetName);
        }
        ConfigSetCommandRunner commandRunner = new ConfigSetCommandRunner(new ZkNodeProps(result), action, configSetName, baseConfigSetName);
        try {
            taskFuture = this.commandsExecutor.submit(commandRunner);
        }
        catch (RejectedExecutionException ree) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Too many executing commands", (Throwable)ree);
        }
        try {
            taskFuture.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, action + " " + configSetName + " timed out after " + timeoutMs + "ms");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, action + " " + configSetName + " interrupted", (Throwable)e);
        }
    }

    public OverseerSolrResponse runCollectionCommand(ZkNodeProps message, CollectionParams.CollectionAction action, long timeoutMs) {
        Future<OverseerSolrResponse> taskFuture;
        if (this.shuttingDown) {
            throw new SolrException(SolrException.ErrorCode.CONFLICT, "Solr is shutting down, no more Collection API tasks may be executed");
        }
        String asyncId = message.getStr("async");
        if (log.isInfoEnabled()) {
            log.info("Running Collection API locally for " + action.name() + " asyncId=" + asyncId);
        }
        if (!this.asyncTaskTracker.createNewAsyncJobTracker(asyncId)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Task with the same requestid already exists. (" + asyncId + ")");
        }
        CollectionCommandRunner commandRunner = new CollectionCommandRunner(message, action, asyncId);
        try {
            taskFuture = this.commandsExecutor.submit(commandRunner);
        }
        catch (RejectedExecutionException ree) {
            this.asyncTaskTracker.cancelAsyncId(asyncId);
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Too many executing commands", (Throwable)ree);
        }
        if (asyncId == null) {
            try {
                return taskFuture.get(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, action + " timed out after " + timeoutMs + "ms");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, action + " interrupted", (Throwable)e);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, action + " failed", (Throwable)e);
            }
        }
        NamedList resp = new NamedList();
        resp.add("requestid", (Object)asyncId);
        return new OverseerSolrResponse((NamedList<Object>)resp);
    }

    public void stopAndWaitForPendingTasksToComplete() {
        this.shuttingDown = true;
        this.commandsExecutor.shutdown();
        this.distributedCollectionApiExecutorService.shutdown();
        long TOTAL_WAIT_NS = 10000000000L;
        long start = System.nanoTime();
        try {
            this.commandsExecutor.awaitTermination(10000000000L, TimeUnit.NANOSECONDS);
            long remaining = 10000000000L - (System.nanoTime() - start);
            if (remaining > 0L) {
                this.distributedCollectionApiExecutorService.awaitTermination(remaining, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public static String getCollectionName(ZkNodeProps message) {
        return message.containsKey("collection") ? message.getStr("collection") : message.getStr("name");
    }

    private class ConfigSetCommandRunner
    implements Callable<Void> {
        private final ZkNodeProps message;
        private final ConfigSetParams.ConfigSetAction action;
        private final String configSetName;
        private final String baseConfigSetName;

        private ConfigSetCommandRunner(ZkNodeProps message, ConfigSetParams.ConfigSetAction action, String configSetName, String baseConfigSetName) {
            this.message = message;
            this.action = action;
            this.configSetName = configSetName;
            this.baseConfigSetName = baseConfigSetName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void call() throws IOException {
            DistributedMultiLock lock = new ConfigSetApiLockFactory(new ZkDistributedConfigSetLockFactory(DistributedCollectionConfigSetCommandRunner.this.ccc.getZkStateReader().getZkClient(), DistributedCollectionConfigSetCommandRunner.ZK_CONFIG_SET_LOCKS)).createConfigSetApiLock(this.configSetName, this.baseConfigSetName);
            try {
                log.debug("ConfigSetCommandRunner about to acquire lock for action {} config set {} base config set {}", new Object[]{this.action, this.configSetName, this.baseConfigSetName});
                lock.waitUntilAcquired();
                log.debug("ConfigSetCommandRunner. Lock acquired. Calling: {}, {}", (Object)this.action, (Object)this.message);
                switch (this.action) {
                    case CREATE: {
                        ConfigSetCmds.createConfigSet(this.message, DistributedCollectionConfigSetCommandRunner.this.coreContainer);
                        return null;
                    }
                    case DELETE: {
                        ConfigSetCmds.deleteConfigSet(this.message, DistributedCollectionConfigSetCommandRunner.this.coreContainer);
                        return null;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bug! Unknown Config Set action: " + this.action);
                    }
                }
            }
            finally {
                lock.release();
            }
        }
    }

    private class CollectionCommandRunner
    implements Callable<OverseerSolrResponse> {
        private final ZkNodeProps message;
        private final CollectionParams.CollectionAction action;
        private final String asyncId;

        private CollectionCommandRunner(ZkNodeProps message, CollectionParams.CollectionAction action, String asyncId) {
            this.message = message;
            this.action = action;
            this.asyncId = asyncId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OverseerSolrResponse call() {
            NamedList results;
            block13: {
                String collName = DistributedCollectionConfigSetCommandRunner.getCollectionName(this.message);
                String shardId = this.message.getStr("shard");
                String replicaName = this.message.getStr("replica");
                MDCLoggingContext.setCollection(collName);
                MDCLoggingContext.setShard(shardId);
                MDCLoggingContext.setReplica(replicaName);
                results = new NamedList();
                try {
                    DistributedMultiLock lock = new CollectionApiLockFactory(new ZkDistributedCollectionLockFactory(DistributedCollectionConfigSetCommandRunner.this.ccc.getZkStateReader().getZkClient(), DistributedCollectionConfigSetCommandRunner.ZK_COLLECTION_LOCKS)).createCollectionApiLock(this.action.lockLevel, collName, shardId, replicaName);
                    try {
                        log.debug("CollectionCommandRunner about to acquire lock for action {} lock level {}. {}/{}/{}", new Object[]{this.action, this.action.lockLevel, collName, shardId, replicaName});
                        lock.waitUntilAcquired();
                        DistributedCollectionConfigSetCommandRunner.this.asyncTaskTracker.setTaskRunning(this.asyncId);
                        log.debug("DistributedCollectionConfigSetCommandRunner.runCollectionCommand. Lock acquired. Calling: {}, {}", (Object)this.action, (Object)this.message);
                        CollApiCmds.CollectionApiCommand command = DistributedCollectionConfigSetCommandRunner.this.commandMapper.getActionCommand(this.action);
                        if (command != null) {
                            command.call(DistributedCollectionConfigSetCommandRunner.this.ccc.getSolrCloudManager().getClusterState(), this.message, (NamedList<Object>)results);
                            break block13;
                        }
                        DistributedCollectionConfigSetCommandRunner.this.asyncTaskTracker.cancelAsyncId(this.asyncId);
                        String message = "Bug: Unknown operation " + this.action;
                        log.error(message);
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, message);
                    }
                    finally {
                        try {
                            lock.release();
                        }
                        catch (SolrException se) {
                            log.error("Error when releasing collection locks for operation " + this.action, (Throwable)se);
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (collName == null) {
                        log.error("Operation {} failed", (Object)this.action, (Object)e);
                    } else {
                        log.error("Collection {}}, operation {} failed", new Object[]{collName, this.action, e});
                    }
                    results.add("Operation " + this.action + " caused exception:", (Object)e);
                    SimpleOrderedMap nl = new SimpleOrderedMap();
                    nl.add("msg", (Object)e.getMessage());
                    nl.add("rspCode", (Object)(e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1));
                    results.add("exception", (Object)nl);
                }
            }
            OverseerSolrResponse res = new OverseerSolrResponse((NamedList<Object>)results);
            DistributedCollectionConfigSetCommandRunner.this.asyncTaskTracker.setTaskCompleted(this.asyncId, res);
            return res;
        }
    }
}

