/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.CreateCollectionAPI;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collectionName}/shards/{shardName}/replicas")
public class CreateReplicaAPI
extends AdminAPIBase {
    @Inject
    public CreateReplicaAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @POST
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse createReplica(@PathParam(value="collectionName") String collectionName, @PathParam(value="shardName") String shardName, AddReplicaRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required request-body is missing");
        }
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", shardName);
        String resolvedCollectionName = this.resolveAndValidateAliasIfEnabled(collectionName, Boolean.TRUE.equals(requestBody.followAliases));
        ZkNodeProps remoteMessage = CreateReplicaAPI.createRemoteMessage(resolvedCollectionName, shardName, requestBody);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.ADDREPLICA, remoteMessage, requestBody.asyncId);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, String shardName, AddReplicaRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("shard", shardName);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "name", requestBody.name);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "_route_", requestBody.route);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "node", requestBody.node);
        if (CollectionUtil.isNotEmpty(requestBody.nodeSet)) {
            remoteMessage.put("createNodeSet", String.join((CharSequence)",", requestBody.nodeSet));
        }
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "skipNodeAssignment", requestBody.skipNodeAssignment);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "instanceDir", requestBody.instanceDir);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "dataDir", requestBody.dataDir);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "ulogDir", requestBody.ulogDir);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "type", requestBody.type);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "waitForFinalState", requestBody.waitForFinalState);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "nrtReplicas", requestBody.nrtReplicas);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "tlogReplicas", requestBody.tlogReplicas);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "pullReplicas", requestBody.pullReplicas);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "followAliases", requestBody.followAliases);
        CreateReplicaAPI.insertIfNotNull(remoteMessage, "async", requestBody.asyncId);
        if (requestBody.properties != null) {
            requestBody.properties.entrySet().forEach(entry -> remoteMessage.put("property." + (String)entry.getKey(), entry.getValue()));
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static class AddReplicaRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty
        public String name;
        @JsonProperty
        public String type;
        @JsonProperty
        public String instanceDir;
        @JsonProperty
        public String dataDir;
        @JsonProperty
        public String ulogDir;
        @JsonProperty
        public String route;
        @JsonProperty
        public Integer nrtReplicas;
        @JsonProperty
        public Integer tlogReplicas;
        @JsonProperty
        public Integer pullReplicas;
        @JsonProperty
        public Boolean waitForFinalState;
        @JsonProperty
        public Boolean followAliases;
        @JsonProperty(value="async")
        public String asyncId;
        @JsonProperty
        public String node;
        @JsonProperty(value="nodeSet")
        public List<String> nodeSet;
        @JsonProperty
        public Boolean skipNodeAssignment;
        @JsonProperty
        public Map<String, String> properties;

        public static AddReplicaRequestBody fromV1Params(SolrParams params) {
            AddReplicaRequestBody requestBody = new AddReplicaRequestBody();
            requestBody.name = params.get("name");
            requestBody.type = params.get("type");
            requestBody.instanceDir = params.get("instanceDir");
            requestBody.dataDir = params.get("dataDir");
            requestBody.ulogDir = params.get("ulogDir");
            requestBody.route = params.get("_route_");
            requestBody.nrtReplicas = params.getInt("nrtReplicas");
            requestBody.tlogReplicas = params.getInt("tlogReplicas");
            requestBody.pullReplicas = params.getInt("pullReplicas");
            requestBody.waitForFinalState = params.getBool("waitForFinalState");
            requestBody.followAliases = params.getBool("followAliases");
            requestBody.asyncId = params.get("async");
            requestBody.node = params.get("node");
            if (params.get("createNodeSet") != null) {
                requestBody.nodeSet = Arrays.asList(params.get("createNodeSet").split(","));
            }
            requestBody.skipNodeAssignment = params.getBool("skipNodeAssignment");
            requestBody.properties = CreateCollectionAPI.copyPrefixedPropertiesWithoutPrefix(params, new HashMap<String, String>(), "property.");
            return requestBody;
        }
    }
}

