/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/collections/{collectionName}/shards/{shardName}")
public class DeleteShardAPI
extends AdminAPIBase {
    @Inject
    public DeleteShardAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @DELETE
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse deleteShard(@PathParam(value="collectionName") String collectionName, @PathParam(value="shardName") String shardName, @QueryParam(value="deleteInstanceDir") Boolean deleteInstanceDir, @QueryParam(value="deleteDataDir") Boolean deleteDataDir, @QueryParam(value="deleteIndex") Boolean deleteIndex, @QueryParam(value="followAliases") Boolean followAliases, @QueryParam(value="async") String asyncId) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", shardName);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteShardAPI.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = DeleteShardAPI.createRemoteMessage(collectionName, shardName, deleteInstanceDir, deleteDataDir, deleteIndex, followAliases, asyncId);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.DELETESHARD, remoteMessage, asyncId);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, String shardName, Boolean deleteInstanceDir, Boolean deleteDataDir, Boolean deleteIndex, Boolean followAliases, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETESHARD.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("shard", shardName);
        DeleteShardAPI.insertIfNotNull(remoteMessage, "followAliases", followAliases);
        DeleteShardAPI.insertIfNotNull(remoteMessage, "deleteInstanceDir", deleteInstanceDir);
        DeleteShardAPI.insertIfNotNull(remoteMessage, "deleteDataDir", deleteDataDir);
        DeleteShardAPI.insertIfNotNull(remoteMessage, "deleteIndex", deleteIndex);
        DeleteShardAPI.insertIfNotNull(remoteMessage, "async", asyncId);
        return new ZkNodeProps(remoteMessage);
    }

    public static void invokeWithV1Params(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws Exception {
        SolrParams v1Params = solrQueryRequest.getParams();
        v1Params.required().check(new String[]{"collection", "shard"});
        DeleteShardAPI deleteShardApi = new DeleteShardAPI(coreContainer, solrQueryRequest, solrQueryResponse);
        SubResponseAccumulatingJerseyResponse v2Response = deleteShardApi.deleteShard(v1Params.get("collection"), v1Params.get("shard"), v1Params.getBool("deleteInstanceDir"), v1Params.getBool("deleteDataDir"), v1Params.getBool("deleteIndex"), v1Params.getBool("followAliases"), v1Params.get("async"));
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(solrQueryResponse, v2Response);
    }
}

