/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.neural;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class KnnQParser
extends QParser {
    static final String TOP_K = "topK";
    static final int DEFAULT_TOP_K = 10;

    public KnnQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        String denseVectorField = this.localParams.get("f");
        String vectorToSearch = this.localParams.get("v");
        int topK = this.localParams.getInt(TOP_K, 10);
        if (denseVectorField == null || denseVectorField.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "the Dense Vector field 'f' is missing");
        }
        if (vectorToSearch == null || vectorToSearch.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "the Dense Vector value 'v' to search is missing");
        }
        SchemaField schemaField = this.req.getCore().getLatestSchema().getField(denseVectorField);
        FieldType fieldType = schemaField.getType();
        if (!(fieldType instanceof DenseVectorField)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "only DenseVectorField is compatible with Knn Query Parser");
        }
        DenseVectorField denseVectorType = (DenseVectorField)fieldType;
        return denseVectorType.getKnnVectorQuery(schemaField.getName(), vectorToSearch, topK, this.getFilterQuery());
    }

    private Query getFilterQuery() throws SolrException, SyntaxError {
        String[] filterQueries;
        boolean isSubQuery;
        boolean bl = isSubQuery = this.recurseCount != 0;
        if (!this.isFilter() && !isSubQuery && (filterQueries = this.req.getParams().getParams("fq")) != null && filterQueries.length != 0) {
            try {
                List<Query> filters = QueryUtils.parseFilterQueries(this.req);
                SolrIndexSearcher.ProcessedFilter processedFilter = this.req.getSearcher().getProcessedFilter(null, filters);
                return processedFilter.filter;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        return null;
    }
}

