/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.configuration.providers.hadoop;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.EnumMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.configuration.SSLCredentialProvider;
import org.apache.solr.util.configuration.providers.AbstractSSLCredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopSSLCredentialProvider
extends AbstractSSLCredentialProvider {
    private Configuration hadoopConfigurationProvider;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public HadoopSSLCredentialProvider() {
        this(new Configuration());
    }

    public HadoopSSLCredentialProvider(Configuration hadoopConfigurationProvider) {
        if (StrUtils.isNullOrEmpty((String)System.getProperty("hadoop.security.credential.provider.path"))) {
            throw new RuntimeException("Cannot initialize Hadoop configuration provider without credential provider path. Use hadoop.security.credential.provider.path system property to configure.");
        }
        this.hadoopConfigurationProvider = hadoopConfigurationProvider;
        hadoopConfigurationProvider.set("hadoop.security.credential.provider.path", System.getProperty("hadoop.security.credential.provider.path"));
    }

    protected EnumMap<SSLCredentialProvider.CredentialType, String> getCredentialKeyMap() {
        return DEFAULT_CREDENTIAL_KEY_MAP;
    }

    protected String getCredential(String keystoreKey) {
        try {
            char[] password = this.hadoopConfigurationProvider.getPassword(keystoreKey);
            return password == null ? null : String.valueOf(password);
        }
        catch (IOException e) {
            log.error("Could not read password from Hadoop Credential Store: {}", (Object)keystoreKey, (Object)e);
            return null;
        }
    }
}

