/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlNameMatchers {
    private static final BaseMatcher CASE_SENSITIVE = new BaseMatcher(true);
    private static final BaseMatcher CASE_INSENSITIVE = new BaseMatcher(false);

    private SqlNameMatchers() {
    }

    public static SqlNameMatcher withCaseSensitive(boolean caseSensitive) {
        return caseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
    }

    public static SqlNameMatcher liberal() {
        return new LiberalNameMatcher();
    }

    private static class LiberalNameMatcher
    extends BaseMatcher {
        @Nullable List<String> matchedNames;

        LiberalNameMatcher() {
            super(false);
        }

        @Override
        protected boolean listMatches(List<String> list0, List<String> list1) {
            boolean b = super.listMatches(list0, list1);
            if (b) {
                this.matchedNames = ImmutableList.copyOf(list1);
            }
            return b;
        }

        @Override
        protected void matched(List<String> prefixNames, List<String> names) {
            this.matchedNames = ImmutableList.copyOf(Util.startsWith(names, prefixNames) ? Util.skip(names, prefixNames.size()) : names);
        }

        @Override
        public List<String> bestMatch() {
            return Objects.requireNonNull(this.matchedNames, "matchedNames");
        }
    }

    private static class BaseMatcher
    implements SqlNameMatcher {
        private final boolean caseSensitive;

        BaseMatcher(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        @Override
        public boolean matches(String string, String name) {
            return this.caseSensitive ? string.equals(name) : string.equalsIgnoreCase(name);
        }

        protected boolean listMatches(List<String> list0, List<String> list1) {
            if (list0.size() != list1.size()) {
                return false;
            }
            for (int i = 0; i < list0.size(); ++i) {
                String s1;
                String s0 = list0.get(i);
                if (this.matches(s0, s1 = list1.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public <K extends List<String>, V> @Nullable V get(Map<K, V> map, List<String> prefixNames, List<String> names) {
            List<String> key = BaseMatcher.concat(prefixNames, names);
            if (this.caseSensitive) {
                return map.get(key);
            }
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (!this.listMatches(key, (List)entry.getKey())) continue;
                this.matched(prefixNames, (List)entry.getKey());
                return entry.getValue();
            }
            return null;
        }

        private static List<String> concat(List<String> prefixNames, List<String> names) {
            if (prefixNames.isEmpty()) {
                return names;
            }
            return ImmutableList.builder().addAll(prefixNames).addAll(names).build();
        }

        protected void matched(List<String> prefixNames, List<String> names) {
        }

        protected List<String> bestMatch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String bestString() {
            return SqlIdentifier.getString(this.bestMatch());
        }

        @Override
        public @Nullable RelDataTypeField field(RelDataType rowType, String fieldName) {
            return rowType.getField(fieldName, this.caseSensitive, false);
        }

        @Override
        public int frequency(Iterable<String> names, String name) {
            int n = 0;
            for (String s : names) {
                if (!this.matches(s, name)) continue;
                ++n;
            }
            return n;
        }

        @Override
        public Set<String> createSet() {
            return this.isCaseSensitive() ? new LinkedHashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        }
    }
}

