; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      --code-model=small < %s | FileCheck %s --check-prefixes=DEFAULT_SMALL64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      --code-model=large < %s | FileCheck %s --check-prefixes=DEFAULT_LARGE64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-shared-lib-tls-model-opt --code-model=small < %s | FileCheck %s --check-prefixes=TLS_MODEL_OPT_SMALL64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-shared-lib-tls-model-opt --code-model=large < %s | FileCheck %s --check-prefixes=TLS_MODEL_OPT_LARGE64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-shared-lib-tls-model-opt -ppc-aix-shared-lib-tls-model-opt-limit=2 \
; RUN:      --code-model=small < %s | FileCheck %s --check-prefixes=TLS_MODEL_OPT_LIMIT2_SMALL64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-shared-lib-tls-model-opt -ppc-aix-shared-lib-tls-model-opt-limit=2 \
; RUN:      --code-model=large < %s | FileCheck %s --check-prefixes=TLS_MODEL_OPT_LIMIT2_LARGE64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-shared-lib-tls-model-opt -ppc-aix-shared-lib-tls-model-opt-limit=3 \
; RUN:      --code-model=small < %s | FileCheck %s --check-prefixes=TLS_MODEL_OPT_LIMIT3_SMALL64
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-shared-lib-tls-model-opt -ppc-aix-shared-lib-tls-model-opt-limit=3 \
; RUN:      --code-model=large < %s | FileCheck %s --check-prefixes=TLS_MODEL_OPT_LIMIT3_LARGE64

@VarTLSLD1 = internal thread_local(localdynamic) global i32 42, align 4
@VarTLSLD2 = internal thread_local(localdynamic) global i32 0, align 4
@VarTLSLD3 = internal thread_local(localdynamic) global i32 0, align 4

; Tune function level TLS model settings:
; Use initial-exec when we have a function accessing only one TLS variable.
; Use local-dynamic when we have a function accessing a handful or more different TLS variables.

define i32 @Single_LD(i32 %P, i32 %Q) {
; DEFAULT_SMALL64-LABEL: Single_LD:
; DEFAULT_SMALL64:       # %bb.0: # %entry
; DEFAULT_SMALL64-NEXT:    mflr 0
; DEFAULT_SMALL64-NEXT:    stdu 1, -48(1)
; DEFAULT_SMALL64-NEXT:    and 6, 3, 4
; DEFAULT_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tlsldm) @"_$TLSML"
; DEFAULT_SMALL64-NEXT:    std 0, 64(1)
; DEFAULT_SMALL64-NEXT:    bla .__tls_get_mod[PR]
; DEFAULT_SMALL64-NEXT:    ld 4, L..C1(2) # target-flags(ppc-tlsld) @VarTLSLD1
; DEFAULT_SMALL64-NEXT:    cmpwi 6, -1
; DEFAULT_SMALL64-NEXT:    lwzx 3, 3, 4
; DEFAULT_SMALL64-NEXT:    addi 1, 1, 48
; DEFAULT_SMALL64-NEXT:    ld 0, 16(1)
; DEFAULT_SMALL64-NEXT:    mtlr 0
; DEFAULT_SMALL64-NEXT:    blr
;
; DEFAULT_LARGE64-LABEL: Single_LD:
; DEFAULT_LARGE64:       # %bb.0: # %entry
; DEFAULT_LARGE64-NEXT:    mflr 0
; DEFAULT_LARGE64-NEXT:    stdu 1, -48(1)
; DEFAULT_LARGE64-NEXT:    and 6, 3, 4
; DEFAULT_LARGE64-NEXT:    addis 3, L..C0@u(2)
; DEFAULT_LARGE64-NEXT:    addis 7, L..C1@u(2)
; DEFAULT_LARGE64-NEXT:    ld 3, L..C0@l(3)
; DEFAULT_LARGE64-NEXT:    std 0, 64(1)
; DEFAULT_LARGE64-NEXT:    bla .__tls_get_mod[PR]
; DEFAULT_LARGE64-NEXT:    ld 4, L..C1@l(7)
; DEFAULT_LARGE64-NEXT:    lwzx 3, 3, 4
; DEFAULT_LARGE64-NEXT:    cmpwi 6, -1
; DEFAULT_LARGE64-NEXT:    addi 1, 1, 48
; DEFAULT_LARGE64-NEXT:    ld 0, 16(1)
; DEFAULT_LARGE64-NEXT:    mtlr 0
; DEFAULT_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_SMALL64-LABEL: Single_LD:
; TLS_MODEL_OPT_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_SMALL64-NEXT:    and 4, 3, 4
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tprel) @VarTLSLD1
; TLS_MODEL_OPT_SMALL64-NEXT:    cmpwi 4, -1
; TLS_MODEL_OPT_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LARGE64-LABEL: Single_LD:
; TLS_MODEL_OPT_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LARGE64-NEXT:    and 4, 3, 4
; TLS_MODEL_OPT_LARGE64-NEXT:    addis 3, L..C0@u(2)
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 3, L..C0@l(3)
; TLS_MODEL_OPT_LARGE64-NEXT:    cmpwi 4, -1
; TLS_MODEL_OPT_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: Single_LD:
; TLS_MODEL_OPT_LIMIT2_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    and 4, 3, 4
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tprel) @VarTLSLD1
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    cmpwi 4, -1
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: Single_LD:
; TLS_MODEL_OPT_LIMIT2_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    and 4, 3, 4
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    addis 3, L..C0@u(2)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    ld 3, L..C0@l(3)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    cmpwi 4, -1
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT3_SMALL64-LABEL: Single_LD:
; TLS_MODEL_OPT_LIMIT3_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    and 4, 3, 4
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tprel) @VarTLSLD1
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    cmpwi 4, -1
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT3_LARGE64-LABEL: Single_LD:
; TLS_MODEL_OPT_LIMIT3_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    and 4, 3, 4
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    addis 3, L..C0@u(2)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    ld 3, L..C0@l(3)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    cmpwi 4, -1
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    blr
entry:
  %a = icmp slt i32 %P, 0
  %b = icmp slt i32 %Q, 0
  %c = and i1 %a, %b
  %tls1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD1)
  %load1 = load i32, ptr %tls1, align 4
  br i1 %c, label %bb1, label %return

bb1:
  %tls2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD1)
  %load2 = load i32, ptr %tls2, align 4
  ret i32 %load2

return:
  ret i32 %load1
}

define i32 @Two_LDs(i32 %P, i32 %Q) {
; DEFAULT_SMALL64-LABEL: Two_LDs:
; DEFAULT_SMALL64:       # %bb.0: # %entry
; DEFAULT_SMALL64-NEXT:    mflr 0
; DEFAULT_SMALL64-NEXT:    stdu 1, -48(1)
; DEFAULT_SMALL64-NEXT:    and 6, 3, 4
; DEFAULT_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tlsldm) @"_$TLSML"
; DEFAULT_SMALL64-NEXT:    std 0, 64(1)
; DEFAULT_SMALL64-NEXT:    bla .__tls_get_mod[PR]
; DEFAULT_SMALL64-NEXT:    cmpwi 6, -1
; DEFAULT_SMALL64-NEXT:    bgt 0, L..BB1_2
; DEFAULT_SMALL64-NEXT:  # %bb.1: # %bb1
; DEFAULT_SMALL64-NEXT:    ld 4, L..C2(2) # target-flags(ppc-tlsld) @VarTLSLD2
; DEFAULT_SMALL64-NEXT:    lwzx 3, 3, 4
; DEFAULT_SMALL64-NEXT:    b L..BB1_3
; DEFAULT_SMALL64-NEXT:  L..BB1_2: # %return
; DEFAULT_SMALL64-NEXT:    ld 4, L..C1(2) # target-flags(ppc-tlsld) @VarTLSLD1
; DEFAULT_SMALL64-NEXT:    lwzx 3, 3, 4
; DEFAULT_SMALL64-NEXT:  L..BB1_3: # %bb1
; DEFAULT_SMALL64-NEXT:    addi 1, 1, 48
; DEFAULT_SMALL64-NEXT:    ld 0, 16(1)
; DEFAULT_SMALL64-NEXT:    mtlr 0
; DEFAULT_SMALL64-NEXT:    blr
;
; DEFAULT_LARGE64-LABEL: Two_LDs:
; DEFAULT_LARGE64:       # %bb.0: # %entry
; DEFAULT_LARGE64-NEXT:    mflr 0
; DEFAULT_LARGE64-NEXT:    stdu 1, -48(1)
; DEFAULT_LARGE64-NEXT:    and 6, 3, 4
; DEFAULT_LARGE64-NEXT:    addis 3, L..C0@u(2)
; DEFAULT_LARGE64-NEXT:    std 0, 64(1)
; DEFAULT_LARGE64-NEXT:    ld 3, L..C0@l(3)
; DEFAULT_LARGE64-NEXT:    bla .__tls_get_mod[PR]
; DEFAULT_LARGE64-NEXT:    cmpwi 6, -1
; DEFAULT_LARGE64-NEXT:    bgt 0, L..BB1_2
; DEFAULT_LARGE64-NEXT:  # %bb.1: # %bb1
; DEFAULT_LARGE64-NEXT:    addis 4, L..C2@u(2)
; DEFAULT_LARGE64-NEXT:    ld 4, L..C2@l(4)
; DEFAULT_LARGE64-NEXT:    lwzx 3, 3, 4
; DEFAULT_LARGE64-NEXT:    b L..BB1_3
; DEFAULT_LARGE64-NEXT:  L..BB1_2: # %return
; DEFAULT_LARGE64-NEXT:    addis 4, L..C1@u(2)
; DEFAULT_LARGE64-NEXT:    ld 4, L..C1@l(4)
; DEFAULT_LARGE64-NEXT:    lwzx 3, 3, 4
; DEFAULT_LARGE64-NEXT:  L..BB1_3: # %bb1
; DEFAULT_LARGE64-NEXT:    addi 1, 1, 48
; DEFAULT_LARGE64-NEXT:    ld 0, 16(1)
; DEFAULT_LARGE64-NEXT:    mtlr 0
; DEFAULT_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_SMALL64-LABEL: Two_LDs:
; TLS_MODEL_OPT_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_SMALL64-NEXT:    mflr 0
; TLS_MODEL_OPT_SMALL64-NEXT:    stdu 1, -48(1)
; TLS_MODEL_OPT_SMALL64-NEXT:    and 6, 3, 4
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 3, L..C1(2) # target-flags(ppc-tlsldm) @"_$TLSML"
; TLS_MODEL_OPT_SMALL64-NEXT:    std 0, 64(1)
; TLS_MODEL_OPT_SMALL64-NEXT:    bla .__tls_get_mod[PR]
; TLS_MODEL_OPT_SMALL64-NEXT:    cmpwi 6, -1
; TLS_MODEL_OPT_SMALL64-NEXT:    bgt 0, L..BB1_2
; TLS_MODEL_OPT_SMALL64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 4, L..C2(2) # target-flags(ppc-tlsld) @VarTLSLD2
; TLS_MODEL_OPT_SMALL64-NEXT:    lwzx 3, 3, 4
; TLS_MODEL_OPT_SMALL64-NEXT:    b L..BB1_3
; TLS_MODEL_OPT_SMALL64-NEXT:  L..BB1_2: # %return
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 4, L..C3(2) # target-flags(ppc-tlsld) @VarTLSLD1
; TLS_MODEL_OPT_SMALL64-NEXT:    lwzx 3, 3, 4
; TLS_MODEL_OPT_SMALL64-NEXT:  L..BB1_3: # %bb1
; TLS_MODEL_OPT_SMALL64-NEXT:    addi 1, 1, 48
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 0, 16(1)
; TLS_MODEL_OPT_SMALL64-NEXT:    mtlr 0
; TLS_MODEL_OPT_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LARGE64-LABEL: Two_LDs:
; TLS_MODEL_OPT_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LARGE64-NEXT:    mflr 0
; TLS_MODEL_OPT_LARGE64-NEXT:    stdu 1, -48(1)
; TLS_MODEL_OPT_LARGE64-NEXT:    and 6, 3, 4
; TLS_MODEL_OPT_LARGE64-NEXT:    addis 3, L..C1@u(2)
; TLS_MODEL_OPT_LARGE64-NEXT:    std 0, 64(1)
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 3, L..C1@l(3)
; TLS_MODEL_OPT_LARGE64-NEXT:    bla .__tls_get_mod[PR]
; TLS_MODEL_OPT_LARGE64-NEXT:    cmpwi 6, -1
; TLS_MODEL_OPT_LARGE64-NEXT:    bgt 0, L..BB1_2
; TLS_MODEL_OPT_LARGE64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LARGE64-NEXT:    addis 4, L..C2@u(2)
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 4, L..C2@l(4)
; TLS_MODEL_OPT_LARGE64-NEXT:    lwzx 3, 3, 4
; TLS_MODEL_OPT_LARGE64-NEXT:    b L..BB1_3
; TLS_MODEL_OPT_LARGE64-NEXT:  L..BB1_2: # %return
; TLS_MODEL_OPT_LARGE64-NEXT:    addis 4, L..C3@u(2)
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 4, L..C3@l(4)
; TLS_MODEL_OPT_LARGE64-NEXT:    lwzx 3, 3, 4
; TLS_MODEL_OPT_LARGE64-NEXT:  L..BB1_3: # %bb1
; TLS_MODEL_OPT_LARGE64-NEXT:    addi 1, 1, 48
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 0, 16(1)
; TLS_MODEL_OPT_LARGE64-NEXT:    mtlr 0
; TLS_MODEL_OPT_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: Two_LDs:
; TLS_MODEL_OPT_LIMIT2_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    and 3, 3, 4
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    cmpwi 3, -1
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    bgt 0, L..BB1_2
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    ld 3, L..C1(2) # target-flags(ppc-tprel) @VarTLSLD2
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    blr
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:  L..BB1_2: # %return
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tprel) @VarTLSLD1
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: Two_LDs:
; TLS_MODEL_OPT_LIMIT2_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    and 3, 3, 4
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    cmpwi 3, -1
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    bgt 0, L..BB1_2
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    addis 3, L..C1@u(2)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    ld 3, L..C1@l(3)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    blr
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:  L..BB1_2: # %return
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    addis 3, L..C0@u(2)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    ld 3, L..C0@l(3)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT3_SMALL64-LABEL: Two_LDs:
; TLS_MODEL_OPT_LIMIT3_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    and 3, 3, 4
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    cmpwi 3, -1
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    bgt 0, L..BB1_2
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    ld 3, L..C1(2) # target-flags(ppc-tprel) @VarTLSLD2
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    blr
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:  L..BB1_2: # %return
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tprel) @VarTLSLD1
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT3_LARGE64-LABEL: Two_LDs:
; TLS_MODEL_OPT_LIMIT3_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    and 3, 3, 4
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    cmpwi 3, -1
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    bgt 0, L..BB1_2
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    addis 3, L..C1@u(2)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    ld 3, L..C1@l(3)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    blr
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:  L..BB1_2: # %return
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    addis 3, L..C0@u(2)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    ld 3, L..C0@l(3)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    blr
entry:
  %a = icmp slt i32 %P, 0
  %b = icmp slt i32 %Q, 0
  %c = and i1 %a, %b
  %tls1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD1)
  %load1 = load i32, ptr %tls1, align 4
  br i1 %c, label %bb1, label %return

bb1:
  %tls2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD2)
  %load2 = load i32, ptr %tls2, align 4
  ret i32 %load2

return:
  ret i32 %load1
}

define i32 @Three_LDs(i32 %P, i32 %Q) {
; DEFAULT_SMALL64-LABEL: Three_LDs:
; DEFAULT_SMALL64:       # %bb.0: # %entry
; DEFAULT_SMALL64-NEXT:    mflr 0
; DEFAULT_SMALL64-NEXT:    stdu 1, -48(1)
; DEFAULT_SMALL64-NEXT:    and 6, 3, 4
; DEFAULT_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tlsldm) @"_$TLSML"
; DEFAULT_SMALL64-NEXT:    std 0, 64(1)
; DEFAULT_SMALL64-NEXT:    bla .__tls_get_mod[PR]
; DEFAULT_SMALL64-NEXT:    cmpwi 6, -1
; DEFAULT_SMALL64-NEXT:    bgt 0, L..BB2_2
; DEFAULT_SMALL64-NEXT:  # %bb.1: # %bb1
; DEFAULT_SMALL64-NEXT:    ld 4, L..C2(2) # target-flags(ppc-tlsld) @VarTLSLD2
; DEFAULT_SMALL64-NEXT:    ld 5, L..C3(2) # target-flags(ppc-tlsld) @VarTLSLD3
; DEFAULT_SMALL64-NEXT:    lwzx 4, 3, 4
; DEFAULT_SMALL64-NEXT:    lwzx 3, 3, 5
; DEFAULT_SMALL64-NEXT:    add 3, 4, 3
; DEFAULT_SMALL64-NEXT:    b L..BB2_3
; DEFAULT_SMALL64-NEXT:  L..BB2_2: # %return
; DEFAULT_SMALL64-NEXT:    ld 4, L..C1(2) # target-flags(ppc-tlsld) @VarTLSLD1
; DEFAULT_SMALL64-NEXT:    lwzx 3, 3, 4
; DEFAULT_SMALL64-NEXT:  L..BB2_3: # %return
; DEFAULT_SMALL64-NEXT:    addi 1, 1, 48
; DEFAULT_SMALL64-NEXT:    ld 0, 16(1)
; DEFAULT_SMALL64-NEXT:    mtlr 0
; DEFAULT_SMALL64-NEXT:    blr
;
; DEFAULT_LARGE64-LABEL: Three_LDs:
; DEFAULT_LARGE64:       # %bb.0: # %entry
; DEFAULT_LARGE64-NEXT:    mflr 0
; DEFAULT_LARGE64-NEXT:    stdu 1, -48(1)
; DEFAULT_LARGE64-NEXT:    and 6, 3, 4
; DEFAULT_LARGE64-NEXT:    addis 3, L..C0@u(2)
; DEFAULT_LARGE64-NEXT:    std 0, 64(1)
; DEFAULT_LARGE64-NEXT:    ld 3, L..C0@l(3)
; DEFAULT_LARGE64-NEXT:    bla .__tls_get_mod[PR]
; DEFAULT_LARGE64-NEXT:    cmpwi 6, -1
; DEFAULT_LARGE64-NEXT:    bgt 0, L..BB2_2
; DEFAULT_LARGE64-NEXT:  # %bb.1: # %bb1
; DEFAULT_LARGE64-NEXT:    addis 4, L..C2@u(2)
; DEFAULT_LARGE64-NEXT:    addis 5, L..C3@u(2)
; DEFAULT_LARGE64-NEXT:    ld 4, L..C2@l(4)
; DEFAULT_LARGE64-NEXT:    ld 5, L..C3@l(5)
; DEFAULT_LARGE64-NEXT:    lwzx 4, 3, 4
; DEFAULT_LARGE64-NEXT:    lwzx 3, 3, 5
; DEFAULT_LARGE64-NEXT:    add 3, 4, 3
; DEFAULT_LARGE64-NEXT:    b L..BB2_3
; DEFAULT_LARGE64-NEXT:  L..BB2_2: # %return
; DEFAULT_LARGE64-NEXT:    addis 4, L..C1@u(2)
; DEFAULT_LARGE64-NEXT:    ld 4, L..C1@l(4)
; DEFAULT_LARGE64-NEXT:    lwzx 3, 3, 4
; DEFAULT_LARGE64-NEXT:  L..BB2_3: # %return
; DEFAULT_LARGE64-NEXT:    addi 1, 1, 48
; DEFAULT_LARGE64-NEXT:    ld 0, 16(1)
; DEFAULT_LARGE64-NEXT:    mtlr 0
; DEFAULT_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_SMALL64-LABEL: Three_LDs:
; TLS_MODEL_OPT_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_SMALL64-NEXT:    mflr 0
; TLS_MODEL_OPT_SMALL64-NEXT:    stdu 1, -48(1)
; TLS_MODEL_OPT_SMALL64-NEXT:    and 6, 3, 4
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 3, L..C1(2) # target-flags(ppc-tlsldm) @"_$TLSML"
; TLS_MODEL_OPT_SMALL64-NEXT:    std 0, 64(1)
; TLS_MODEL_OPT_SMALL64-NEXT:    bla .__tls_get_mod[PR]
; TLS_MODEL_OPT_SMALL64-NEXT:    cmpwi 6, -1
; TLS_MODEL_OPT_SMALL64-NEXT:    bgt 0, L..BB2_2
; TLS_MODEL_OPT_SMALL64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 4, L..C2(2) # target-flags(ppc-tlsld) @VarTLSLD2
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 5, L..C4(2) # target-flags(ppc-tlsld) @VarTLSLD3
; TLS_MODEL_OPT_SMALL64-NEXT:    lwzx 4, 3, 4
; TLS_MODEL_OPT_SMALL64-NEXT:    lwzx 3, 3, 5
; TLS_MODEL_OPT_SMALL64-NEXT:    add 3, 4, 3
; TLS_MODEL_OPT_SMALL64-NEXT:    b L..BB2_3
; TLS_MODEL_OPT_SMALL64-NEXT:  L..BB2_2: # %return
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 4, L..C3(2) # target-flags(ppc-tlsld) @VarTLSLD1
; TLS_MODEL_OPT_SMALL64-NEXT:    lwzx 3, 3, 4
; TLS_MODEL_OPT_SMALL64-NEXT:  L..BB2_3: # %return
; TLS_MODEL_OPT_SMALL64-NEXT:    addi 1, 1, 48
; TLS_MODEL_OPT_SMALL64-NEXT:    ld 0, 16(1)
; TLS_MODEL_OPT_SMALL64-NEXT:    mtlr 0
; TLS_MODEL_OPT_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LARGE64-LABEL: Three_LDs:
; TLS_MODEL_OPT_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LARGE64-NEXT:    mflr 0
; TLS_MODEL_OPT_LARGE64-NEXT:    stdu 1, -48(1)
; TLS_MODEL_OPT_LARGE64-NEXT:    and 6, 3, 4
; TLS_MODEL_OPT_LARGE64-NEXT:    addis 3, L..C1@u(2)
; TLS_MODEL_OPT_LARGE64-NEXT:    std 0, 64(1)
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 3, L..C1@l(3)
; TLS_MODEL_OPT_LARGE64-NEXT:    bla .__tls_get_mod[PR]
; TLS_MODEL_OPT_LARGE64-NEXT:    cmpwi 6, -1
; TLS_MODEL_OPT_LARGE64-NEXT:    bgt 0, L..BB2_2
; TLS_MODEL_OPT_LARGE64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LARGE64-NEXT:    addis 4, L..C2@u(2)
; TLS_MODEL_OPT_LARGE64-NEXT:    addis 5, L..C4@u(2)
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 4, L..C2@l(4)
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 5, L..C4@l(5)
; TLS_MODEL_OPT_LARGE64-NEXT:    lwzx 4, 3, 4
; TLS_MODEL_OPT_LARGE64-NEXT:    lwzx 3, 3, 5
; TLS_MODEL_OPT_LARGE64-NEXT:    add 3, 4, 3
; TLS_MODEL_OPT_LARGE64-NEXT:    b L..BB2_3
; TLS_MODEL_OPT_LARGE64-NEXT:  L..BB2_2: # %return
; TLS_MODEL_OPT_LARGE64-NEXT:    addis 4, L..C3@u(2)
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 4, L..C3@l(4)
; TLS_MODEL_OPT_LARGE64-NEXT:    lwzx 3, 3, 4
; TLS_MODEL_OPT_LARGE64-NEXT:  L..BB2_3: # %return
; TLS_MODEL_OPT_LARGE64-NEXT:    addi 1, 1, 48
; TLS_MODEL_OPT_LARGE64-NEXT:    ld 0, 16(1)
; TLS_MODEL_OPT_LARGE64-NEXT:    mtlr 0
; TLS_MODEL_OPT_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: Three_LDs:
; TLS_MODEL_OPT_LIMIT2_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    mflr 0
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    stdu 1, -48(1)
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    and 6, 3, 4
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    ld 3, L..C2(2) # target-flags(ppc-tlsldm) @"_$TLSML"
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    std 0, 64(1)
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    bla .__tls_get_mod[PR]
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    cmpwi 6, -1
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    bgt 0, L..BB2_2
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    ld 4, L..C3(2) # target-flags(ppc-tlsld) @VarTLSLD2
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    ld 5, L..C4(2) # target-flags(ppc-tlsld) @VarTLSLD3
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    lwzx 4, 3, 4
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    lwzx 3, 3, 5
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    add 3, 4, 3
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    b L..BB2_3
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:  L..BB2_2: # %return
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    ld 4, L..C5(2) # target-flags(ppc-tlsld) @VarTLSLD1
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    lwzx 3, 3, 4
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:  L..BB2_3: # %return
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    addi 1, 1, 48
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    ld 0, 16(1)
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    mtlr 0
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: Three_LDs:
; TLS_MODEL_OPT_LIMIT2_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    mflr 0
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    stdu 1, -48(1)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    and 6, 3, 4
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    addis 3, L..C2@u(2)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    std 0, 64(1)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    ld 3, L..C2@l(3)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    bla .__tls_get_mod[PR]
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    cmpwi 6, -1
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    bgt 0, L..BB2_2
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    addis 4, L..C3@u(2)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    addis 5, L..C4@u(2)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    ld 4, L..C3@l(4)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    ld 5, L..C4@l(5)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    lwzx 4, 3, 4
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    lwzx 3, 3, 5
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    add 3, 4, 3
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    b L..BB2_3
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:  L..BB2_2: # %return
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    addis 4, L..C5@u(2)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    ld 4, L..C5@l(4)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    lwzx 3, 3, 4
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:  L..BB2_3: # %return
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    addi 1, 1, 48
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    ld 0, 16(1)
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    mtlr 0
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT3_SMALL64-LABEL: Three_LDs:
; TLS_MODEL_OPT_LIMIT3_SMALL64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    and 3, 3, 4
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    cmpwi 3, -1
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    bgt 0, L..BB2_2
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    ld 3, L..C1(2) # target-flags(ppc-tprel) @VarTLSLD2
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    ld 4, L..C2(2) # target-flags(ppc-tprel) @VarTLSLD3
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    lwzx 4, 13, 4
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    add 3, 3, 4
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    blr
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:  L..BB2_2: # %return
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    ld 3, L..C0(2) # target-flags(ppc-tprel) @VarTLSLD1
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT:    blr
;
; TLS_MODEL_OPT_LIMIT3_LARGE64-LABEL: Three_LDs:
; TLS_MODEL_OPT_LIMIT3_LARGE64:       # %bb.0: # %entry
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    and 3, 3, 4
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    cmpwi 3, -1
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    bgt 0, L..BB2_2
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:  # %bb.1: # %bb1
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    addis 3, L..C1@u(2)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    addis 4, L..C2@u(2)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    ld 3, L..C1@l(3)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    ld 4, L..C2@l(4)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    lwzx 4, 13, 4
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    add 3, 3, 4
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    blr
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:  L..BB2_2: # %return
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    addis 3, L..C0@u(2)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    ld 3, L..C0@l(3)
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    lwzx 3, 13, 3
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT:    blr
entry:
  %a = icmp slt i32 %P, 0
  %b = icmp slt i32 %Q, 0
  %c = and i1 %a, %b
  %tls1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD1)
  %load1 = load i32, ptr %tls1, align 4
  br i1 %c, label %bb1, label %return

bb1:
  %tls2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD2)
  %load2 = load i32, ptr %tls2, align 4
  %tls3 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD3)
  %load3 = load i32, ptr %tls3, align 4
  %sum = add i32 %load2, %load3
  ret i32 %sum

return:
  ret i32 %load1
}

declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull)

; DEFAULT_SMALL64-LABEL: .toc
; DEFAULT_SMALL64-LABEL: L..C0:
; DEFAULT_SMALL64-NEXT: .tc _Renamed..5f24__TLSML[TC],_Renamed..5f24__TLSML[TC]@ml
; DEFAULT_SMALL64-NEXT: .rename _Renamed..5f24__TLSML[TC],"_$TLSML"
; DEFAULT_SMALL64-LABEL: L..C1:
; DEFAULT_SMALL64-NEXT: .tc VarTLSLD1[TC],VarTLSLD1[TL]@ld
; DEFAULT_SMALL64-LABEL: L..C2:
; DEFAULT_SMALL64-NEXT: .tc VarTLSLD2[TC],VarTLSLD2[UL]@ld
; DEFAULT_SMALL64-LABEL: L..C3:
; DEFAULT_SMALL64-NEXT: .tc VarTLSLD3[TC],VarTLSLD3[UL]@ld

; DEFAULT_LARGE64-LABEL: .toc
; DEFAULT_LARGE64-LABEL: L..C0:
; DEFAULT_LARGE64-NEXT: .tc _Renamed..5f24__TLSML[TC],_Renamed..5f24__TLSML[TC]@ml
; DEFAULT_LARGE64-NEXT: .rename _Renamed..5f24__TLSML[TC],"_$TLSML"
; DEFAULT_LARGE64-LABEL: L..C1:
; DEFAULT_LARGE64-NEXT: .tc VarTLSLD1[TE],VarTLSLD1[TL]@ld
; DEFAULT_LARGE64-LABEL: L..C2:
; DEFAULT_LARGE64-NEXT: .tc VarTLSLD2[TE],VarTLSLD2[UL]@ld
; DEFAULT_LARGE64-LABEL: L..C3:
; DEFAULT_LARGE64-NEXT: .tc VarTLSLD3[TE],VarTLSLD3[UL]@ld

; TLS_MODEL_OPT_SMALL64-LABEL: .toc
; TLS_MODEL_OPT_SMALL64-LABEL: L..C0:
; TLS_MODEL_OPT_SMALL64-NEXT: .tc VarTLSLD1[TC],VarTLSLD1[TL]@ie
; TLS_MODEL_OPT_SMALL64-LABEL: L..C1:
; TLS_MODEL_OPT_SMALL64-NEXT: .tc _Renamed..5f24__TLSML[TC],_Renamed..5f24__TLSML[TC]@ml
; TLS_MODEL_OPT_SMALL64-NEXT: .rename _Renamed..5f24__TLSML[TC],"_$TLSML"
; TLS_MODEL_OPT_SMALL64-LABEL: L..C2:
; TLS_MODEL_OPT_SMALL64-NEXT: .tc .VarTLSLD2[TC],VarTLSLD2[UL]@ld
; TLS_MODEL_OPT_SMALL64-LABEL: L..C3:
; TLS_MODEL_OPT_SMALL64-NEXT: .tc .VarTLSLD1[TC],VarTLSLD1[TL]@ld
; TLS_MODEL_OPT_SMALL64-LABEL: L..C4:
; TLS_MODEL_OPT_SMALL64-NEXT: .tc .VarTLSLD3[TC],VarTLSLD3[UL]@ld

; TLS_MODEL_OPT_LARGE64-LABEL: .toc
; TLS_MODEL_OPT_LARGE64-LABEL: L..C0:
; TLS_MODEL_OPT_LARGE64-NEXT: .tc VarTLSLD1[TE],VarTLSLD1[TL]@ie
; TLS_MODEL_OPT_LARGE64-LABEL: L..C1:
; TLS_MODEL_OPT_LARGE64-NEXT: .tc _Renamed..5f24__TLSML[TC],_Renamed..5f24__TLSML[TC]@ml
; TLS_MODEL_OPT_LARGE64-NEXT: .rename _Renamed..5f24__TLSML[TC],"_$TLSML"
; TLS_MODEL_OPT_LARGE64-LABEL: L..C2:
; TLS_MODEL_OPT_LARGE64-NEXT: .tc .VarTLSLD2[TE],VarTLSLD2[UL]@ld
; TLS_MODEL_OPT_LARGE64-LABEL: L..C3:
; TLS_MODEL_OPT_LARGE64-NEXT: .tc .VarTLSLD1[TE],VarTLSLD1[TL]@ld
; TLS_MODEL_OPT_LARGE64-LABEL: L..C4:
; TLS_MODEL_OPT_LARGE64-NEXT: .tc .VarTLSLD3[TE],VarTLSLD3[UL]@ld

; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: .toc
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: L..C0:
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT: .tc VarTLSLD1[TC],VarTLSLD1[TL]@ie
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: L..C1:
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT: .tc VarTLSLD2[TC],VarTLSLD2[UL]@ie
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: L..C2:
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT: .tc _Renamed..5f24__TLSML[TC],_Renamed..5f24__TLSML[TC]@ml
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT: .rename _Renamed..5f24__TLSML[TC],"_$TLSML"
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: L..C3:
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT: .tc .VarTLSLD2[TC],VarTLSLD2[UL]@ld
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: L..C4:
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT: .tc .VarTLSLD3[TC],VarTLSLD3[UL]@ld
; TLS_MODEL_OPT_LIMIT2_SMALL64-LABEL: L..C5:
; TLS_MODEL_OPT_LIMIT2_SMALL64-NEXT: .tc .VarTLSLD1[TC],VarTLSLD1[TL]@ld

; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: .toc
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: L..C0:
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT: .tc VarTLSLD1[TE],VarTLSLD1[TL]@ie
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: L..C1:
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT: .tc VarTLSLD2[TE],VarTLSLD2[UL]@ie
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: L..C2:
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT: .tc _Renamed..5f24__TLSML[TC],_Renamed..5f24__TLSML[TC]@ml
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT: .rename _Renamed..5f24__TLSML[TC],"_$TLSML"
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: L..C3:
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT: .tc .VarTLSLD2[TE],VarTLSLD2[UL]@ld
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: L..C4:
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT: .tc .VarTLSLD3[TE],VarTLSLD3[UL]@ld
; TLS_MODEL_OPT_LIMIT2_LARGE64-LABEL: L..C5:
; TLS_MODEL_OPT_LIMIT2_LARGE64-NEXT: .tc .VarTLSLD1[TE],VarTLSLD1[TL]@ld

; TLS_MODEL_OPT_LIMIT3_SMALL64-LABEL: .toc
; TLS_MODEL_OPT_LIMIT3_SMALL64-LABEL: L..C0:
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT: .tc VarTLSLD1[TC],VarTLSLD1[TL]@ie
; TLS_MODEL_OPT_LIMIT3_SMALL64-LABEL: L..C1:
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT: .tc VarTLSLD2[TC],VarTLSLD2[UL]@ie
; TLS_MODEL_OPT_LIMIT3_SMALL64-LABEL: L..C2:
; TLS_MODEL_OPT_LIMIT3_SMALL64-NEXT: .tc VarTLSLD3[TC],VarTLSLD3[UL]@ie

; TLS_MODEL_OPT_LIMIT3_LARGE64-LABEL: .toc
; TLS_MODEL_OPT_LIMIT3_LARGE64-LABEL: L..C0:
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT: .tc VarTLSLD1[TE],VarTLSLD1[TL]@ie
; TLS_MODEL_OPT_LIMIT3_LARGE64-LABEL: L..C1:
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT: .tc VarTLSLD2[TE],VarTLSLD2[UL]@ie
; TLS_MODEL_OPT_LIMIT3_LARGE64-LABEL: L..C2:
; TLS_MODEL_OPT_LIMIT3_LARGE64-NEXT: .tc VarTLSLD3[TE],VarTLSLD3[UL]@ie
