/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <glib-object.h>
#include "config.h"

#if ENABLE(Condition1) || ENABLE(Condition2)

#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>
#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "SerializedScriptValue.h"
#include "TestSerializedScriptValueInterface.h"
#include "WebKitDOMBinding.h"
#include "gobject/ConvertToUTF8String.h"
#include "webkit/WebKitDOMSerializedScriptValue.h"
#include "webkit/WebKitDOMSerializedScriptValuePrivate.h"
#include "webkit/WebKitDOMTestSerializedScriptValueInterface.h"
#include "webkit/WebKitDOMTestSerializedScriptValueInterfacePrivate.h"
#include "webkitdefines.h"
#include "webkitglobalsprivate.h"
#include "webkitmarshal.h"

namespace WebKit {
    
WebKitDOMTestSerializedScriptValueInterface* kit(WebCore::TestSerializedScriptValueInterface* obj)
{
    g_return_val_if_fail(obj, 0);

    if (gpointer ret = DOMObjectCache::get(obj))
        return static_cast<WebKitDOMTestSerializedScriptValueInterface*>(ret);

    return static_cast<WebKitDOMTestSerializedScriptValueInterface*>(DOMObjectCache::put(obj, WebKit::wrapTestSerializedScriptValueInterface(obj)));
}
    
} // namespace WebKit //

WebKitDOMSerializedScriptValue*
webkit_dom_test_serialized_script_value_interface_get_value(WebKitDOMTestSerializedScriptValueInterface* self)
{
    g_return_val_if_fail(self, 0);
    WebCore::JSMainThreadNullState state;
    WebCore::TestSerializedScriptValueInterface * item = WebKit::core(self);
    PassRefPtr<WebCore::SerializedScriptValue> g_res = WTF::getPtr(item->value());
    WebKitDOMSerializedScriptValue* res = WebKit::kit(g_res.get());
    return res;
}


G_DEFINE_TYPE(WebKitDOMTestSerializedScriptValueInterface, webkit_dom_test_serialized_script_value_interface, WEBKIT_TYPE_DOM_OBJECT)

namespace WebKit {

WebCore::TestSerializedScriptValueInterface* core(WebKitDOMTestSerializedScriptValueInterface* request)
{
    g_return_val_if_fail(request, 0);

    WebCore::TestSerializedScriptValueInterface* coreObject = static_cast<WebCore::TestSerializedScriptValueInterface*>(WEBKIT_DOM_OBJECT(request)->coreObject);
    g_return_val_if_fail(coreObject, 0);

    return coreObject;
}

} // namespace WebKit
enum {
    PROP_0,
    PROP_VALUE,
};


static void webkit_dom_test_serialized_script_value_interface_finalize(GObject* object)
{
    WebKitDOMObject* dom_object = WEBKIT_DOM_OBJECT(object);
    
    if (dom_object->coreObject) {
        WebCore::TestSerializedScriptValueInterface* coreObject = static_cast<WebCore::TestSerializedScriptValueInterface *>(dom_object->coreObject);

        WebKit::DOMObjectCache::forget(coreObject);
        coreObject->deref();

        dom_object->coreObject = NULL;
    }

    G_OBJECT_CLASS(webkit_dom_test_serialized_script_value_interface_parent_class)->finalize(object);
}

static void webkit_dom_test_serialized_script_value_interface_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    switch (prop_id) {
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
        break;
    }
}


static void webkit_dom_test_serialized_script_value_interface_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    WebKitDOMTestSerializedScriptValueInterface* self = WEBKIT_DOM_TEST_SERIALIZED_SCRIPT_VALUE_INTERFACE(object);
    WebCore::TestSerializedScriptValueInterface* coreSelf = WebKit::core(self);
    switch (prop_id) {
    case PROP_VALUE:
    {
        RefPtr<WebCore::SerializedScriptValue> ptr = coreSelf->value();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
        break;
    }
}


static void webkit_dom_test_serialized_script_value_interface_constructed(GObject* object)
{

    if (G_OBJECT_CLASS(webkit_dom_test_serialized_script_value_interface_parent_class)->constructed)
        G_OBJECT_CLASS(webkit_dom_test_serialized_script_value_interface_parent_class)->constructed(object);
}

static void webkit_dom_test_serialized_script_value_interface_class_init(WebKitDOMTestSerializedScriptValueInterfaceClass* requestClass)
{
    GObjectClass *gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->finalize = webkit_dom_test_serialized_script_value_interface_finalize;
    gobjectClass->set_property = webkit_dom_test_serialized_script_value_interface_set_property;
    gobjectClass->get_property = webkit_dom_test_serialized_script_value_interface_get_property;
    gobjectClass->constructed = webkit_dom_test_serialized_script_value_interface_constructed;

    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_object("value", /* name */
                                                           "test_serialized_script_value_interface_value", /* short description */
                                                           "read-only  WebKitDOMSerializedScriptValue* TestSerializedScriptValueInterface.value", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_SERIALIZED_SCRIPT_VALUE, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));


}

static void webkit_dom_test_serialized_script_value_interface_init(WebKitDOMTestSerializedScriptValueInterface* request)
{
}

namespace WebKit {
WebKitDOMTestSerializedScriptValueInterface* wrapTestSerializedScriptValueInterface(WebCore::TestSerializedScriptValueInterface* coreObject)
{
    g_return_val_if_fail(coreObject, 0);

    /* We call ref() rather than using a C++ smart pointer because we can't store a C++ object
     * in a C-allocated GObject structure.  See the finalize() code for the
     * matching deref().
     */
    coreObject->ref();

    return  WEBKIT_DOM_TEST_SERIALIZED_SCRIPT_VALUE_INTERFACE(g_object_new(WEBKIT_TYPE_DOM_TEST_SERIALIZED_SCRIPT_VALUE_INTERFACE,
                                               "core-object", coreObject, NULL));
}
} // namespace WebKit
#endif /* ENABLE(Condition1) || ENABLE(Condition2) */
