#!/bin/bash

# stop on any unhandled error
set -e

# @TODO: pipefail not in POSIX
set -o pipefail

# show commands (debug)
#set -x

# shellcheck source=src/container/output.inc.sh
source "/output.inc.sh"

# @TODO: Nag if remote git branches for debian/upstream/pristine-tar have newer stuff than locally (risk for new local changes to be in vain)

# @TODO: Nag if git tags are missing for past debian/changelog releases (i.e. forgot to run 'gbp tag')

# @TODO: Nag if local git tags have not been pushed (i.e. forgot to run 'gbp push')

# @TODO: find * -type f | xargs spellintian --picky
# @TODO: enchant-2 -d en -a debian/changelog # ispell line format, does not work for a human
# @TODO: aspell -d en -c debian/changelog # interactive mode, checks whole file not just latest entry
# @TODO: aspell --mode=debctrl -c debian/control
# @TODO: find -name *.md -exec aspell --mode=markdown -c "{}" +;
# @TODO: hunspell -d en_US debian/changelog # interactive mode

# @TODO: For each manpage run: LC_ALL=C.UTF-8 MANROFFSEQ='' MANWIDTH=80 man --warnings -E UTF-8 -l -Tutf8 -Z $MANPAGE >/dev/null

# @TODO: suspicious-source --verbose --directory . # no output if no findings, and most findings false positives

# @TODO: 'duck -v --color=always' check validity or URLS in debian/control, debian/upstream, debian/copyright etc

# @TODO: adequate # Findings for listdc++6 and libc6 out-of-the-box, but could
# be useful if current package installed and added to
# '/var/lib/adequate/pending' for limiting checks to it

# @TODO: find . -type f \( -iname '*.po' -o -iname '*.pot' -o -iname '*.mo' -o -iname '*.gmo' \) -exec i18nspector --jobs 1 {} +
# @TODO: find . -type f \( -iname '*.po' -o -iname '*.pot' \) -exec msgfmt --check --check-compatibility --check-accelerators --output-file=/dev/null {} \;

# @TODO: find . -type f \( -iname '*.yaml' -o -iname '*.yml' -o -iwholename ./debian/upstream/metadata -o -iwholename ./debian/upstream/edam \) -exec yamllint {} +

# @TODO: blhc --all --debian --line-numbers --color *.build
# or alternatively as Salsa-CI uses: blhc --debian --line-numbers --color ${SALSA_CI_BLHC_ARGS} ${WORKING_DIR}/*.build || [ $? -eq 1 ]
# However both versions result in blhc outputting 'No compiler commands' so I am not sure if it works at all?

# @TODO: diffoscope --html report.html old.deb new.deb

# Lintian brush needs to run first as it refuses to run if there are any
# uncommitted changes, potentially introduced by the other tools
log_info "Run all tools that may help improve the Debian packaging in an automated fashion"

# Produce a list of files for shellcheck to check. Ensure there is alreays at
# least one empty file in the list to avoid getting errors when no files were
# found.
SH_SCRIPTS="$(mktemp; grep -Irnw debian/ -e '^#!.*/sh' | sort -u | cut -d ':' -f 1 || true)"
BASH_SCRIPTS="$(mktemp; grep -Irnw debian/ -e '^#!.*/bash' | sort -u | cut -d ':' -f 1 || true)"

# Echo all commands so it is easy for users to re-run them manually
set -x

# Disable until lintian-brush re-enters Debian testing (and Ubuntu 26.04), see
# https://tracker.debian.org/pkg/lintian-brush
#lintian-brush --no-update-changelog --modern --uncertain

# Don't stop on errors as the tools below are likely to emit exit codes if they
# have findings but Debcraft should continue to execute and run all of them
set +e

debputy lint --spellcheck --auto-fix

debputy reformat --style black

codespell --write-changes --check-filenames --check-hidden \
  --skip="debian/changelog,debian/patches,debian/vendor,debian/source/lintian-overrides,*.lintian-overrides,*.po,*.pot" \
  debian/
# add overrides in debian/.codespellrc

lrc
# add overrides in debian/lrc.config

shellcheck -x --enable=all --shell=sh "$SH_SCRIPTS"
shellcheck -x --enable=all --shell=bash "$BASH_SCRIPTS"

set +x

if [ -n "$SH_SCRIPTS" ] || [ -n "$BASH_SCRIPTS" ]
then
  rm -f shellcheck-fixes.diff
  shellcheck -x --enable=all --format=diff --shell=sh "$SH_SCRIPTS" >> shellcheck-fixes.diff
  shellcheck -x --enable=all --format=diff --shell=bash "$BASH_SCRIPTS" >> shellcheck-fixes.diff

  # Apply patch if not empty, otherwise just remove it
  if [[ -s shellcheck-fixes.diff ]]
  then
    patch --strip=1 < shellcheck-fixes.diff
  else
    rm -f shellcheck-fixes.diff
  fi
fi

# Remove extra file generated by one of the tools above
rm -f .config/breezy/ignore || true
