// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/account_budget_proposal_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for
// [AccountBudgetProposalService.GetAccountBudgetProposal][google.ads.googleads.v1.services.AccountBudgetProposalService.GetAccountBudgetProposal].
type GetAccountBudgetProposalRequest struct {
	// Required. The resource name of the account-level budget proposal to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAccountBudgetProposalRequest) Reset()         { *m = GetAccountBudgetProposalRequest{} }
func (m *GetAccountBudgetProposalRequest) String() string { return proto.CompactTextString(m) }
func (*GetAccountBudgetProposalRequest) ProtoMessage()    {}
func (*GetAccountBudgetProposalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2316c2664e0be7e3, []int{0}
}

func (m *GetAccountBudgetProposalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAccountBudgetProposalRequest.Unmarshal(m, b)
}
func (m *GetAccountBudgetProposalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAccountBudgetProposalRequest.Marshal(b, m, deterministic)
}
func (m *GetAccountBudgetProposalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAccountBudgetProposalRequest.Merge(m, src)
}
func (m *GetAccountBudgetProposalRequest) XXX_Size() int {
	return xxx_messageInfo_GetAccountBudgetProposalRequest.Size(m)
}
func (m *GetAccountBudgetProposalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAccountBudgetProposalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAccountBudgetProposalRequest proto.InternalMessageInfo

func (m *GetAccountBudgetProposalRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for
// [AccountBudgetProposalService.MutateAccountBudgetProposal][google.ads.googleads.v1.services.AccountBudgetProposalService.MutateAccountBudgetProposal].
type MutateAccountBudgetProposalRequest struct {
	// Required. The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The operation to perform on an individual account-level budget proposal.
	Operation *AccountBudgetProposalOperation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAccountBudgetProposalRequest) Reset()         { *m = MutateAccountBudgetProposalRequest{} }
func (m *MutateAccountBudgetProposalRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAccountBudgetProposalRequest) ProtoMessage()    {}
func (*MutateAccountBudgetProposalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_2316c2664e0be7e3, []int{1}
}

func (m *MutateAccountBudgetProposalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAccountBudgetProposalRequest.Unmarshal(m, b)
}
func (m *MutateAccountBudgetProposalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAccountBudgetProposalRequest.Marshal(b, m, deterministic)
}
func (m *MutateAccountBudgetProposalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAccountBudgetProposalRequest.Merge(m, src)
}
func (m *MutateAccountBudgetProposalRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAccountBudgetProposalRequest.Size(m)
}
func (m *MutateAccountBudgetProposalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAccountBudgetProposalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAccountBudgetProposalRequest proto.InternalMessageInfo

func (m *MutateAccountBudgetProposalRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAccountBudgetProposalRequest) GetOperation() *AccountBudgetProposalOperation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *MutateAccountBudgetProposalRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation to propose the creation of a new account-level budget or
// edit/end/remove an existing one.
type AccountBudgetProposalOperation struct {
	// FieldMask that determines which budget fields are modified.  While budgets
	// may be modified, proposals that propose such modifications are final.
	// Therefore, update operations are not supported for proposals.
	//
	// Proposals that modify budgets have the 'update' proposal type.  Specifying
	// a mask for any other proposal type is considered an error.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AccountBudgetProposalOperation_Create
	//	*AccountBudgetProposalOperation_Remove
	Operation            isAccountBudgetProposalOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *AccountBudgetProposalOperation) Reset()         { *m = AccountBudgetProposalOperation{} }
func (m *AccountBudgetProposalOperation) String() string { return proto.CompactTextString(m) }
func (*AccountBudgetProposalOperation) ProtoMessage()    {}
func (*AccountBudgetProposalOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_2316c2664e0be7e3, []int{2}
}

func (m *AccountBudgetProposalOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccountBudgetProposalOperation.Unmarshal(m, b)
}
func (m *AccountBudgetProposalOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccountBudgetProposalOperation.Marshal(b, m, deterministic)
}
func (m *AccountBudgetProposalOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccountBudgetProposalOperation.Merge(m, src)
}
func (m *AccountBudgetProposalOperation) XXX_Size() int {
	return xxx_messageInfo_AccountBudgetProposalOperation.Size(m)
}
func (m *AccountBudgetProposalOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AccountBudgetProposalOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AccountBudgetProposalOperation proto.InternalMessageInfo

func (m *AccountBudgetProposalOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isAccountBudgetProposalOperation_Operation interface {
	isAccountBudgetProposalOperation_Operation()
}

type AccountBudgetProposalOperation_Create struct {
	Create *resources.AccountBudgetProposal `protobuf:"bytes,2,opt,name=create,proto3,oneof"`
}

type AccountBudgetProposalOperation_Remove struct {
	Remove string `protobuf:"bytes,1,opt,name=remove,proto3,oneof"`
}

func (*AccountBudgetProposalOperation_Create) isAccountBudgetProposalOperation_Operation() {}

func (*AccountBudgetProposalOperation_Remove) isAccountBudgetProposalOperation_Operation() {}

func (m *AccountBudgetProposalOperation) GetOperation() isAccountBudgetProposalOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AccountBudgetProposalOperation) GetCreate() *resources.AccountBudgetProposal {
	if x, ok := m.GetOperation().(*AccountBudgetProposalOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AccountBudgetProposalOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AccountBudgetProposalOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AccountBudgetProposalOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AccountBudgetProposalOperation_Create)(nil),
		(*AccountBudgetProposalOperation_Remove)(nil),
	}
}

// Response message for account-level budget mutate operations.
type MutateAccountBudgetProposalResponse struct {
	// The result of the mutate.
	Result               *MutateAccountBudgetProposalResult `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *MutateAccountBudgetProposalResponse) Reset()         { *m = MutateAccountBudgetProposalResponse{} }
func (m *MutateAccountBudgetProposalResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAccountBudgetProposalResponse) ProtoMessage()    {}
func (*MutateAccountBudgetProposalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_2316c2664e0be7e3, []int{3}
}

func (m *MutateAccountBudgetProposalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAccountBudgetProposalResponse.Unmarshal(m, b)
}
func (m *MutateAccountBudgetProposalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAccountBudgetProposalResponse.Marshal(b, m, deterministic)
}
func (m *MutateAccountBudgetProposalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAccountBudgetProposalResponse.Merge(m, src)
}
func (m *MutateAccountBudgetProposalResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAccountBudgetProposalResponse.Size(m)
}
func (m *MutateAccountBudgetProposalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAccountBudgetProposalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAccountBudgetProposalResponse proto.InternalMessageInfo

func (m *MutateAccountBudgetProposalResponse) GetResult() *MutateAccountBudgetProposalResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// The result for the account budget proposal mutate.
type MutateAccountBudgetProposalResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAccountBudgetProposalResult) Reset()         { *m = MutateAccountBudgetProposalResult{} }
func (m *MutateAccountBudgetProposalResult) String() string { return proto.CompactTextString(m) }
func (*MutateAccountBudgetProposalResult) ProtoMessage()    {}
func (*MutateAccountBudgetProposalResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_2316c2664e0be7e3, []int{4}
}

func (m *MutateAccountBudgetProposalResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAccountBudgetProposalResult.Unmarshal(m, b)
}
func (m *MutateAccountBudgetProposalResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAccountBudgetProposalResult.Marshal(b, m, deterministic)
}
func (m *MutateAccountBudgetProposalResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAccountBudgetProposalResult.Merge(m, src)
}
func (m *MutateAccountBudgetProposalResult) XXX_Size() int {
	return xxx_messageInfo_MutateAccountBudgetProposalResult.Size(m)
}
func (m *MutateAccountBudgetProposalResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAccountBudgetProposalResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAccountBudgetProposalResult proto.InternalMessageInfo

func (m *MutateAccountBudgetProposalResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAccountBudgetProposalRequest)(nil), "google.ads.googleads.v1.services.GetAccountBudgetProposalRequest")
	proto.RegisterType((*MutateAccountBudgetProposalRequest)(nil), "google.ads.googleads.v1.services.MutateAccountBudgetProposalRequest")
	proto.RegisterType((*AccountBudgetProposalOperation)(nil), "google.ads.googleads.v1.services.AccountBudgetProposalOperation")
	proto.RegisterType((*MutateAccountBudgetProposalResponse)(nil), "google.ads.googleads.v1.services.MutateAccountBudgetProposalResponse")
	proto.RegisterType((*MutateAccountBudgetProposalResult)(nil), "google.ads.googleads.v1.services.MutateAccountBudgetProposalResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/account_budget_proposal_service.proto", fileDescriptor_2316c2664e0be7e3)
}

var fileDescriptor_2316c2664e0be7e3 = []byte{
	// 711 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x95, 0x4d, 0x4f, 0xd4, 0x40,
	0x18, 0xc7, 0x6d, 0x31, 0x44, 0x66, 0xe1, 0xd2, 0xc4, 0xb8, 0x2e, 0x44, 0x96, 0xc2, 0x81, 0x6c,
	0x4c, 0xeb, 0x62, 0x62, 0x48, 0x09, 0x91, 0x59, 0x15, 0xf0, 0x80, 0x6c, 0xd6, 0x84, 0x83, 0x6c,
	0x6c, 0x66, 0xdb, 0xa1, 0x36, 0xb4, 0x9d, 0xda, 0x99, 0x6e, 0x42, 0x08, 0x1e, 0x38, 0x19, 0xaf,
	0x7e, 0x03, 0x8f, 0x9e, 0xfd, 0x14, 0x5c, 0xf5, 0x60, 0x38, 0x71, 0xf0, 0xa2, 0x1f, 0xc1, 0x93,
	0x69, 0x67, 0x66, 0xe9, 0x26, 0xbb, 0xdd, 0x44, 0x6e, 0x4f, 0xe7, 0xf9, 0xef, 0xef, 0x79, 0x9d,
	0x59, 0xb0, 0xed, 0x11, 0xe2, 0x05, 0xd8, 0x44, 0x2e, 0x35, 0xb9, 0x99, 0x59, 0xfd, 0xa6, 0x49,
	0x71, 0xd2, 0xf7, 0x1d, 0x4c, 0x4d, 0xe4, 0x38, 0x24, 0x8d, 0x98, 0xdd, 0x4b, 0x5d, 0x0f, 0x33,
	0x3b, 0x4e, 0x48, 0x4c, 0x28, 0x0a, 0x6c, 0x21, 0x30, 0xe2, 0x84, 0x30, 0xa2, 0xd5, 0xf9, 0x8f,
	0x0d, 0xe4, 0x52, 0x63, 0xc0, 0x31, 0xfa, 0x4d, 0x43, 0x72, 0x6a, 0x4f, 0xc7, 0x45, 0x4a, 0x30,
	0x25, 0x69, 0x52, 0x12, 0x8a, 0x87, 0xa8, 0x2d, 0x48, 0x40, 0xec, 0x9b, 0x28, 0x8a, 0x08, 0x43,
	0xcc, 0x27, 0x11, 0x15, 0xde, 0x7b, 0x05, 0xaf, 0x13, 0xf8, 0x38, 0x62, 0xc2, 0xb1, 0x58, 0x70,
	0x1c, 0xf9, 0x38, 0x70, 0xed, 0x1e, 0x7e, 0x87, 0xfa, 0x3e, 0x49, 0x84, 0xe0, 0x7e, 0x41, 0x20,
	0x73, 0x11, 0x2e, 0x51, 0x95, 0x99, 0x7f, 0xf5, 0xd2, 0x23, 0x01, 0x08, 0x11, 0x3d, 0xe6, 0x0a,
	0xfd, 0x03, 0x58, 0xdc, 0xc1, 0x0c, 0xf2, 0xc4, 0x5b, 0x79, 0xde, 0x6d, 0x91, 0x76, 0x07, 0xbf,
	0x4f, 0x31, 0x65, 0xda, 0x21, 0x98, 0x93, 0x58, 0x3b, 0x42, 0x21, 0xae, 0x2a, 0x75, 0x65, 0x75,
	0xa6, 0xf5, 0xe4, 0x0a, 0xaa, 0x7f, 0xe1, 0x23, 0x50, 0x68, 0x97, 0xb0, 0x62, 0x9f, 0x1a, 0x0e,
	0x09, 0xcd, 0xd1, 0xd4, 0x59, 0x09, 0x7b, 0x85, 0x42, 0xac, 0xff, 0x50, 0x80, 0xbe, 0x97, 0x32,
	0xc4, 0x70, 0x69, 0x0e, 0x2b, 0xa0, 0xe2, 0xa4, 0x94, 0x91, 0x10, 0x27, 0xb6, 0xef, 0x8a, 0x0c,
	0xa6, 0xae, 0xa0, 0xda, 0x01, 0xf2, 0xfc, 0xa5, 0xab, 0x39, 0x60, 0x86, 0xc4, 0x38, 0xc9, 0xfb,
	0x5a, 0x55, 0xeb, 0xca, 0x6a, 0x65, 0x6d, 0xcb, 0x98, 0x34, 0x58, 0x63, 0x64, 0xe0, 0x7d, 0xc9,
	0xe1, 0x51, 0xae, 0xb9, 0xda, 0x32, 0x98, 0xeb, 0xa3, 0xc0, 0x77, 0x11, 0xc3, 0x36, 0x89, 0x82,
	0x93, 0xea, 0x54, 0x5d, 0x59, 0xbd, 0xd3, 0x99, 0x95, 0x87, 0xfb, 0x51, 0x70, 0xa2, 0xff, 0x54,
	0xc0, 0x83, 0x72, 0xae, 0xb6, 0x01, 0x2a, 0x69, 0x9c, 0x53, 0xb2, 0x71, 0xe4, 0x94, 0xca, 0x5a,
	0x4d, 0xa6, 0x2b, 0x27, 0x66, 0x6c, 0x67, 0x13, 0xdb, 0x43, 0xf4, 0xb8, 0x03, 0xb8, 0x3c, 0xb3,
	0xb5, 0x0e, 0x98, 0x76, 0x12, 0x8c, 0x18, 0x16, 0x65, 0xae, 0x8f, 0x2d, 0x73, 0xb0, 0x9d, 0xa3,
	0xeb, 0xdc, 0xbd, 0xd5, 0x11, 0x24, 0xad, 0x0a, 0xa6, 0x13, 0x1c, 0x92, 0xbe, 0x18, 0x70, 0xe6,
	0xe1, 0xdf, 0xad, 0x4a, 0xa1, 0xaf, 0xfa, 0xb9, 0x02, 0x96, 0x4b, 0x27, 0x46, 0x63, 0x12, 0x51,
	0xac, 0x1d, 0x66, 0x38, 0x9a, 0x06, 0x4c, 0xa4, 0xf8, 0x6c, 0xf2, 0x24, 0xca, 0xb1, 0x69, 0xc0,
	0x3a, 0x02, 0xa9, 0xef, 0x82, 0xa5, 0x89, 0xe2, 0x6c, 0x52, 0x23, 0x16, 0x77, 0x78, 0x01, 0xd7,
	0xbe, 0xdd, 0x06, 0x0b, 0x23, 0x21, 0xaf, 0x79, 0x56, 0xda, 0x6f, 0x05, 0x54, 0xc7, 0x5d, 0x11,
	0x0d, 0x4e, 0x2e, 0x6a, 0xc2, 0xf5, 0xaa, 0xfd, 0xf7, 0xe8, 0xf4, 0xf6, 0x25, 0x1c, 0x2e, 0xf0,
	0xfc, 0xfb, 0xaf, 0xcf, 0xaa, 0xa5, 0xad, 0x67, 0xaf, 0xd2, 0xe9, 0x90, 0x67, 0x53, 0xde, 0x12,
	0x6a, 0x36, 0xe4, 0x33, 0x35, 0x4c, 0xa3, 0x66, 0xe3, 0x4c, 0xfb, 0xa4, 0x82, 0xf9, 0x92, 0xbe,
	0x6a, 0xcf, 0x6f, 0x38, 0x43, 0x5e, 0xf1, 0x8b, 0x9b, 0x6e, 0x42, 0xbe, 0x60, 0xfa, 0xdb, 0x4b,
	0x78, 0xb7, 0xf0, 0x28, 0x3c, 0x1c, 0xac, 0x68, 0xde, 0x86, 0x2d, 0x7d, 0x23, 0x6b, 0xc3, 0x75,
	0xdd, 0xa7, 0x05, 0xed, 0x66, 0xe3, 0x6c, 0x4c, 0x17, 0xac, 0x30, 0x8f, 0x6c, 0x29, 0x8d, 0xda,
	0xfc, 0x05, 0xac, 0x8e, 0x7b, 0xdb, 0x5a, 0x1f, 0x55, 0xb0, 0xe2, 0x90, 0x70, 0x62, 0x25, 0xad,
	0xa5, 0xb2, 0xe5, 0x6a, 0x67, 0xb7, 0xbc, 0xad, 0xbc, 0xd9, 0x15, 0x18, 0x8f, 0x04, 0x28, 0xf2,
	0x0c, 0x92, 0x78, 0xa6, 0x87, 0xa3, 0xfc, 0x0d, 0x30, 0xaf, 0x03, 0x8f, 0xff, 0x93, 0xdb, 0x90,
	0xc6, 0x17, 0x75, 0x6a, 0x07, 0xc2, 0xaf, 0x6a, 0x7d, 0x87, 0x03, 0xa1, 0x4b, 0x0d, 0x6e, 0x66,
	0xd6, 0x41, 0xd3, 0x10, 0x81, 0xe9, 0x85, 0x94, 0x74, 0xa1, 0x4b, 0xbb, 0x03, 0x49, 0xf7, 0xa0,
	0xd9, 0x95, 0x92, 0x3f, 0xea, 0x0a, 0x3f, 0xb7, 0x2c, 0xe8, 0x52, 0xcb, 0x1a, 0x88, 0x2c, 0xeb,
	0xa0, 0x69, 0x59, 0x52, 0xd6, 0x9b, 0xce, 0xf3, 0x7c, 0xfc, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x25,
	0x6a, 0x49, 0xcc, 0x8b, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AccountBudgetProposalServiceClient is the client API for AccountBudgetProposalService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AccountBudgetProposalServiceClient interface {
	// Returns an account-level budget proposal in full detail.
	GetAccountBudgetProposal(ctx context.Context, in *GetAccountBudgetProposalRequest, opts ...grpc.CallOption) (*resources.AccountBudgetProposal, error)
	// Creates, updates, or removes account budget proposals.  Operation statuses
	// are returned.
	MutateAccountBudgetProposal(ctx context.Context, in *MutateAccountBudgetProposalRequest, opts ...grpc.CallOption) (*MutateAccountBudgetProposalResponse, error)
}

type accountBudgetProposalServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAccountBudgetProposalServiceClient(cc grpc.ClientConnInterface) AccountBudgetProposalServiceClient {
	return &accountBudgetProposalServiceClient{cc}
}

func (c *accountBudgetProposalServiceClient) GetAccountBudgetProposal(ctx context.Context, in *GetAccountBudgetProposalRequest, opts ...grpc.CallOption) (*resources.AccountBudgetProposal, error) {
	out := new(resources.AccountBudgetProposal)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.AccountBudgetProposalService/GetAccountBudgetProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountBudgetProposalServiceClient) MutateAccountBudgetProposal(ctx context.Context, in *MutateAccountBudgetProposalRequest, opts ...grpc.CallOption) (*MutateAccountBudgetProposalResponse, error) {
	out := new(MutateAccountBudgetProposalResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.AccountBudgetProposalService/MutateAccountBudgetProposal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccountBudgetProposalServiceServer is the server API for AccountBudgetProposalService service.
type AccountBudgetProposalServiceServer interface {
	// Returns an account-level budget proposal in full detail.
	GetAccountBudgetProposal(context.Context, *GetAccountBudgetProposalRequest) (*resources.AccountBudgetProposal, error)
	// Creates, updates, or removes account budget proposals.  Operation statuses
	// are returned.
	MutateAccountBudgetProposal(context.Context, *MutateAccountBudgetProposalRequest) (*MutateAccountBudgetProposalResponse, error)
}

// UnimplementedAccountBudgetProposalServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAccountBudgetProposalServiceServer struct {
}

func (*UnimplementedAccountBudgetProposalServiceServer) GetAccountBudgetProposal(ctx context.Context, req *GetAccountBudgetProposalRequest) (*resources.AccountBudgetProposal, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccountBudgetProposal not implemented")
}
func (*UnimplementedAccountBudgetProposalServiceServer) MutateAccountBudgetProposal(ctx context.Context, req *MutateAccountBudgetProposalRequest) (*MutateAccountBudgetProposalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateAccountBudgetProposal not implemented")
}

func RegisterAccountBudgetProposalServiceServer(s *grpc.Server, srv AccountBudgetProposalServiceServer) {
	s.RegisterService(&_AccountBudgetProposalService_serviceDesc, srv)
}

func _AccountBudgetProposalService_GetAccountBudgetProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccountBudgetProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountBudgetProposalServiceServer).GetAccountBudgetProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.AccountBudgetProposalService/GetAccountBudgetProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountBudgetProposalServiceServer).GetAccountBudgetProposal(ctx, req.(*GetAccountBudgetProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountBudgetProposalService_MutateAccountBudgetProposal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAccountBudgetProposalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountBudgetProposalServiceServer).MutateAccountBudgetProposal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.AccountBudgetProposalService/MutateAccountBudgetProposal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountBudgetProposalServiceServer).MutateAccountBudgetProposal(ctx, req.(*MutateAccountBudgetProposalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AccountBudgetProposalService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.AccountBudgetProposalService",
	HandlerType: (*AccountBudgetProposalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAccountBudgetProposal",
			Handler:    _AccountBudgetProposalService_GetAccountBudgetProposal_Handler,
		},
		{
			MethodName: "MutateAccountBudgetProposal",
			Handler:    _AccountBudgetProposalService_MutateAccountBudgetProposal_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/account_budget_proposal_service.proto",
}
