// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/datacatalog/v1/datacatalog.proto

package datacatalog

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Entry resources in Data Catalog can be of different types e.g. a BigQuery
// Table entry is of type `TABLE`. This enum describes all the possible types
// Data Catalog contains.
type EntryType int32

const (
	// Default unknown type.
	EntryType_ENTRY_TYPE_UNSPECIFIED EntryType = 0
	// Output only. The type of entry that has a GoogleSQL schema, including
	// logical views.
	EntryType_TABLE EntryType = 2
	// Output only. The type of models, examples include
	// https://cloud.google.com/bigquery-ml/docs/bigqueryml-intro
	EntryType_MODEL EntryType = 5
	// Output only. An entry type which is used for streaming entries. Example:
	// Pub/Sub topic.
	EntryType_DATA_STREAM EntryType = 3
	// An entry type which is a set of files or objects. Example:
	// Cloud Storage fileset.
	EntryType_FILESET EntryType = 4
)

var EntryType_name = map[int32]string{
	0: "ENTRY_TYPE_UNSPECIFIED",
	2: "TABLE",
	5: "MODEL",
	3: "DATA_STREAM",
	4: "FILESET",
}

var EntryType_value = map[string]int32{
	"ENTRY_TYPE_UNSPECIFIED": 0,
	"TABLE":                  2,
	"MODEL":                  5,
	"DATA_STREAM":            3,
	"FILESET":                4,
}

func (x EntryType) String() string {
	return proto.EnumName(EntryType_name, int32(x))
}

func (EntryType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{0}
}

// Request message for
// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
type SearchCatalogRequest struct {
	// Required. The scope of this search request. A `scope` that has empty
	// `include_org_ids`, `include_project_ids` AND false
	// `include_gcp_public_datasets` is considered invalid. Data Catalog will
	// return an error in such a case.
	Scope *SearchCatalogRequest_Scope `protobuf:"bytes,6,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The query string in search query syntax. The query must be non-empty.
	//
	// Query strings can be simple as "x" or more qualified as:
	//
	// * name:x
	// * column:x
	// * description:y
	//
	// Note: Query tokens need to have a minimum of 3 characters for substring
	// matching to work correctly. See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference) for more information.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Number of results in the search page. If <=0 then defaults to 10. Max limit
	// for page_size is 1000. Throws an invalid argument for page_size > 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Pagination token returned in an earlier
	// [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1.SearchCatalogResponse.next_page_token], which
	// indicates that this is a continuation of a prior
	// [SearchCatalogRequest][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog]
	// call, and that the system should return the next page of data. If empty,
	// the first page is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specifies the ordering of results, currently supported case-sensitive
	// choices are:
	//
	//   * `relevance`, only supports descending
	//   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
	//     specified
	//
	// If not specified, defaults to `relevance` descending.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchCatalogRequest) Reset()         { *m = SearchCatalogRequest{} }
func (m *SearchCatalogRequest) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogRequest) ProtoMessage()    {}
func (*SearchCatalogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{0}
}

func (m *SearchCatalogRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogRequest.Unmarshal(m, b)
}
func (m *SearchCatalogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogRequest.Marshal(b, m, deterministic)
}
func (m *SearchCatalogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogRequest.Merge(m, src)
}
func (m *SearchCatalogRequest) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogRequest.Size(m)
}
func (m *SearchCatalogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogRequest proto.InternalMessageInfo

func (m *SearchCatalogRequest) GetScope() *SearchCatalogRequest_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (m *SearchCatalogRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchCatalogRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchCatalogRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchCatalogRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// The criteria that select the subspace used for query matching.
type SearchCatalogRequest_Scope struct {
	// The list of organization IDs to search within. To find your organization
	// ID, follow instructions in
	// https://cloud.google.com/resource-manager/docs/creating-managing-organization.
	IncludeOrgIds []string `protobuf:"bytes,2,rep,name=include_org_ids,json=includeOrgIds,proto3" json:"include_org_ids,omitempty"`
	// The list of project IDs to search within. To learn more about the
	// distinction between project names/IDs/numbers, go to
	// https://cloud.google.com/docs/overview/#projects.
	IncludeProjectIds []string `protobuf:"bytes,3,rep,name=include_project_ids,json=includeProjectIds,proto3" json:"include_project_ids,omitempty"`
	// If `true`, include Google Cloud Platform (GCP) public datasets in the
	// search results. Info on GCP public datasets is available at
	// https://cloud.google.com/public-datasets/. By default, GCP public
	// datasets are excluded.
	IncludeGcpPublicDatasets bool     `protobuf:"varint,7,opt,name=include_gcp_public_datasets,json=includeGcpPublicDatasets,proto3" json:"include_gcp_public_datasets,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *SearchCatalogRequest_Scope) Reset()         { *m = SearchCatalogRequest_Scope{} }
func (m *SearchCatalogRequest_Scope) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogRequest_Scope) ProtoMessage()    {}
func (*SearchCatalogRequest_Scope) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{0, 0}
}

func (m *SearchCatalogRequest_Scope) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Unmarshal(m, b)
}
func (m *SearchCatalogRequest_Scope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Marshal(b, m, deterministic)
}
func (m *SearchCatalogRequest_Scope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogRequest_Scope.Merge(m, src)
}
func (m *SearchCatalogRequest_Scope) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogRequest_Scope.Size(m)
}
func (m *SearchCatalogRequest_Scope) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogRequest_Scope.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogRequest_Scope proto.InternalMessageInfo

func (m *SearchCatalogRequest_Scope) GetIncludeOrgIds() []string {
	if m != nil {
		return m.IncludeOrgIds
	}
	return nil
}

func (m *SearchCatalogRequest_Scope) GetIncludeProjectIds() []string {
	if m != nil {
		return m.IncludeProjectIds
	}
	return nil
}

func (m *SearchCatalogRequest_Scope) GetIncludeGcpPublicDatasets() bool {
	if m != nil {
		return m.IncludeGcpPublicDatasets
	}
	return false
}

// Response message for
// [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
type SearchCatalogResponse struct {
	// Search results.
	Results []*SearchCatalogResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// The token that can be used to retrieve the next page of results.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchCatalogResponse) Reset()         { *m = SearchCatalogResponse{} }
func (m *SearchCatalogResponse) String() string { return proto.CompactTextString(m) }
func (*SearchCatalogResponse) ProtoMessage()    {}
func (*SearchCatalogResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{1}
}

func (m *SearchCatalogResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchCatalogResponse.Unmarshal(m, b)
}
func (m *SearchCatalogResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchCatalogResponse.Marshal(b, m, deterministic)
}
func (m *SearchCatalogResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchCatalogResponse.Merge(m, src)
}
func (m *SearchCatalogResponse) XXX_Size() int {
	return xxx_messageInfo_SearchCatalogResponse.Size(m)
}
func (m *SearchCatalogResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchCatalogResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchCatalogResponse proto.InternalMessageInfo

func (m *SearchCatalogResponse) GetResults() []*SearchCatalogResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchCatalogResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [CreateEntryGroup][google.cloud.datacatalog.v1.DataCatalog.CreateEntryGroup].
type CreateEntryGroupRequest struct {
	// Required. The name of the project this entry group is in. Example:
	//
	// * projects/{project_id}/locations/{location}
	//
	// Note that this EntryGroup and its child resources may not actually be
	// stored in the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the entry group to create.
	// The id must begin with a letter or underscore, contain only English
	// letters, numbers and underscores, and be at most 64 characters.
	EntryGroupId string `protobuf:"bytes,3,opt,name=entry_group_id,json=entryGroupId,proto3" json:"entry_group_id,omitempty"`
	// The entry group to create. Defaults to an empty entry group.
	EntryGroup           *EntryGroup `protobuf:"bytes,2,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateEntryGroupRequest) Reset()         { *m = CreateEntryGroupRequest{} }
func (m *CreateEntryGroupRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEntryGroupRequest) ProtoMessage()    {}
func (*CreateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{2}
}

func (m *CreateEntryGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEntryGroupRequest.Unmarshal(m, b)
}
func (m *CreateEntryGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEntryGroupRequest.Marshal(b, m, deterministic)
}
func (m *CreateEntryGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEntryGroupRequest.Merge(m, src)
}
func (m *CreateEntryGroupRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEntryGroupRequest.Size(m)
}
func (m *CreateEntryGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEntryGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEntryGroupRequest proto.InternalMessageInfo

func (m *CreateEntryGroupRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEntryGroupRequest) GetEntryGroupId() string {
	if m != nil {
		return m.EntryGroupId
	}
	return ""
}

func (m *CreateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if m != nil {
		return m.EntryGroup
	}
	return nil
}

// Request message for
// [UpdateEntryGroup][google.cloud.datacatalog.v1.DataCatalog.UpdateEntryGroup].
type UpdateEntryGroupRequest struct {
	// Required. The updated entry group. "name" field must be set.
	EntryGroup *EntryGroup `protobuf:"bytes,1,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	// The fields to update on the entry group. If absent or empty, all modifiable
	// fields are updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEntryGroupRequest) Reset()         { *m = UpdateEntryGroupRequest{} }
func (m *UpdateEntryGroupRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEntryGroupRequest) ProtoMessage()    {}
func (*UpdateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{3}
}

func (m *UpdateEntryGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEntryGroupRequest.Unmarshal(m, b)
}
func (m *UpdateEntryGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEntryGroupRequest.Marshal(b, m, deterministic)
}
func (m *UpdateEntryGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEntryGroupRequest.Merge(m, src)
}
func (m *UpdateEntryGroupRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEntryGroupRequest.Size(m)
}
func (m *UpdateEntryGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEntryGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEntryGroupRequest proto.InternalMessageInfo

func (m *UpdateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if m != nil {
		return m.EntryGroup
	}
	return nil
}

func (m *UpdateEntryGroupRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [GetEntryGroup][google.cloud.datacatalog.v1.DataCatalog.GetEntryGroup].
type GetEntryGroupRequest struct {
	// Required. The name of the entry group. For example,
	// `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The fields to return. If not set or empty, all fields are returned.
	ReadMask             *field_mask.FieldMask `protobuf:"bytes,2,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetEntryGroupRequest) Reset()         { *m = GetEntryGroupRequest{} }
func (m *GetEntryGroupRequest) String() string { return proto.CompactTextString(m) }
func (*GetEntryGroupRequest) ProtoMessage()    {}
func (*GetEntryGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{4}
}

func (m *GetEntryGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEntryGroupRequest.Unmarshal(m, b)
}
func (m *GetEntryGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEntryGroupRequest.Marshal(b, m, deterministic)
}
func (m *GetEntryGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEntryGroupRequest.Merge(m, src)
}
func (m *GetEntryGroupRequest) XXX_Size() int {
	return xxx_messageInfo_GetEntryGroupRequest.Size(m)
}
func (m *GetEntryGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEntryGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEntryGroupRequest proto.InternalMessageInfo

func (m *GetEntryGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetEntryGroupRequest) GetReadMask() *field_mask.FieldMask {
	if m != nil {
		return m.ReadMask
	}
	return nil
}

// Request message for
// [DeleteEntryGroup][google.cloud.datacatalog.v1.DataCatalog.DeleteEntryGroup].
type DeleteEntryGroupRequest struct {
	// Required. The name of the entry group. For example,
	// `projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If true, deletes all entries in the entry group.
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEntryGroupRequest) Reset()         { *m = DeleteEntryGroupRequest{} }
func (m *DeleteEntryGroupRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEntryGroupRequest) ProtoMessage()    {}
func (*DeleteEntryGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{5}
}

func (m *DeleteEntryGroupRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEntryGroupRequest.Unmarshal(m, b)
}
func (m *DeleteEntryGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEntryGroupRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEntryGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEntryGroupRequest.Merge(m, src)
}
func (m *DeleteEntryGroupRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEntryGroupRequest.Size(m)
}
func (m *DeleteEntryGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEntryGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEntryGroupRequest proto.InternalMessageInfo

func (m *DeleteEntryGroupRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteEntryGroupRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Request message for
// [ListEntryGroups][google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups].
type ListEntryGroupsRequest struct {
	// Required. The name of the location that contains the entry groups, which can be
	// provided in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return. Default is 10. Max limit is 1000.
	// Throws an invalid argument for `page_size > 1000`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Token that specifies which page is requested. If empty, the first page is
	// returned.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntryGroupsRequest) Reset()         { *m = ListEntryGroupsRequest{} }
func (m *ListEntryGroupsRequest) String() string { return proto.CompactTextString(m) }
func (*ListEntryGroupsRequest) ProtoMessage()    {}
func (*ListEntryGroupsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{6}
}

func (m *ListEntryGroupsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntryGroupsRequest.Unmarshal(m, b)
}
func (m *ListEntryGroupsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntryGroupsRequest.Marshal(b, m, deterministic)
}
func (m *ListEntryGroupsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntryGroupsRequest.Merge(m, src)
}
func (m *ListEntryGroupsRequest) XXX_Size() int {
	return xxx_messageInfo_ListEntryGroupsRequest.Size(m)
}
func (m *ListEntryGroupsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntryGroupsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntryGroupsRequest proto.InternalMessageInfo

func (m *ListEntryGroupsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEntryGroupsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEntryGroupsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [ListEntryGroups][google.cloud.datacatalog.v1.DataCatalog.ListEntryGroups].
type ListEntryGroupsResponse struct {
	// EntryGroup details.
	EntryGroups []*EntryGroup `protobuf:"bytes,1,rep,name=entry_groups,json=entryGroups,proto3" json:"entry_groups,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no items
	// remain in results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntryGroupsResponse) Reset()         { *m = ListEntryGroupsResponse{} }
func (m *ListEntryGroupsResponse) String() string { return proto.CompactTextString(m) }
func (*ListEntryGroupsResponse) ProtoMessage()    {}
func (*ListEntryGroupsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{7}
}

func (m *ListEntryGroupsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntryGroupsResponse.Unmarshal(m, b)
}
func (m *ListEntryGroupsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntryGroupsResponse.Marshal(b, m, deterministic)
}
func (m *ListEntryGroupsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntryGroupsResponse.Merge(m, src)
}
func (m *ListEntryGroupsResponse) XXX_Size() int {
	return xxx_messageInfo_ListEntryGroupsResponse.Size(m)
}
func (m *ListEntryGroupsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntryGroupsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntryGroupsResponse proto.InternalMessageInfo

func (m *ListEntryGroupsResponse) GetEntryGroups() []*EntryGroup {
	if m != nil {
		return m.EntryGroups
	}
	return nil
}

func (m *ListEntryGroupsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry].
type CreateEntryRequest struct {
	// Required. The name of the entry group this entry is in. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	//
	// Note that this Entry and its child resources may not actually be stored in
	// the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the entry to create.
	EntryId string `protobuf:"bytes,3,opt,name=entry_id,json=entryId,proto3" json:"entry_id,omitempty"`
	// Required. The entry to create.
	Entry                *Entry   `protobuf:"bytes,2,opt,name=entry,proto3" json:"entry,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateEntryRequest) Reset()         { *m = CreateEntryRequest{} }
func (m *CreateEntryRequest) String() string { return proto.CompactTextString(m) }
func (*CreateEntryRequest) ProtoMessage()    {}
func (*CreateEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{8}
}

func (m *CreateEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateEntryRequest.Unmarshal(m, b)
}
func (m *CreateEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateEntryRequest.Marshal(b, m, deterministic)
}
func (m *CreateEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateEntryRequest.Merge(m, src)
}
func (m *CreateEntryRequest) XXX_Size() int {
	return xxx_messageInfo_CreateEntryRequest.Size(m)
}
func (m *CreateEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateEntryRequest proto.InternalMessageInfo

func (m *CreateEntryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateEntryRequest) GetEntryId() string {
	if m != nil {
		return m.EntryId
	}
	return ""
}

func (m *CreateEntryRequest) GetEntry() *Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

// Request message for
// [UpdateEntry][google.cloud.datacatalog.v1.DataCatalog.UpdateEntry].
type UpdateEntryRequest struct {
	// Required. The updated entry. The "name" field must be set.
	Entry *Entry `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// The fields to update on the entry. If absent or empty, all modifiable
	// fields are updated.
	//
	// The following fields are modifiable:
	// * For entries with type `DATA_STREAM`:
	//    * `schema`
	// * For entries with type `FILESET`
	//    * `schema`
	//    * `display_name`
	//    * `description`
	//    * `gcs_fileset_spec`
	//    * `gcs_fileset_spec.file_patterns`
	// * For entries with `user_specified_type`
	//    * `schema`
	//    * `display_name`
	//    * `description`
	//    * user_specified_type
	//    * user_specified_system
	//    * linked_resource
	//    * source_system_timestamps
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateEntryRequest) Reset()         { *m = UpdateEntryRequest{} }
func (m *UpdateEntryRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateEntryRequest) ProtoMessage()    {}
func (*UpdateEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{9}
}

func (m *UpdateEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateEntryRequest.Unmarshal(m, b)
}
func (m *UpdateEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateEntryRequest.Marshal(b, m, deterministic)
}
func (m *UpdateEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateEntryRequest.Merge(m, src)
}
func (m *UpdateEntryRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateEntryRequest.Size(m)
}
func (m *UpdateEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateEntryRequest proto.InternalMessageInfo

func (m *UpdateEntryRequest) GetEntry() *Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (m *UpdateEntryRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteEntry][google.cloud.datacatalog.v1.DataCatalog.DeleteEntry].
type DeleteEntryRequest struct {
	// Required. The name of the entry. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteEntryRequest) Reset()         { *m = DeleteEntryRequest{} }
func (m *DeleteEntryRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteEntryRequest) ProtoMessage()    {}
func (*DeleteEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{10}
}

func (m *DeleteEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteEntryRequest.Unmarshal(m, b)
}
func (m *DeleteEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteEntryRequest.Marshal(b, m, deterministic)
}
func (m *DeleteEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteEntryRequest.Merge(m, src)
}
func (m *DeleteEntryRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteEntryRequest.Size(m)
}
func (m *DeleteEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteEntryRequest proto.InternalMessageInfo

func (m *DeleteEntryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [GetEntry][google.cloud.datacatalog.v1.DataCatalog.GetEntry].
type GetEntryRequest struct {
	// Required. The name of the entry. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetEntryRequest) Reset()         { *m = GetEntryRequest{} }
func (m *GetEntryRequest) String() string { return proto.CompactTextString(m) }
func (*GetEntryRequest) ProtoMessage()    {}
func (*GetEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{11}
}

func (m *GetEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetEntryRequest.Unmarshal(m, b)
}
func (m *GetEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetEntryRequest.Marshal(b, m, deterministic)
}
func (m *GetEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetEntryRequest.Merge(m, src)
}
func (m *GetEntryRequest) XXX_Size() int {
	return xxx_messageInfo_GetEntryRequest.Size(m)
}
func (m *GetEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetEntryRequest proto.InternalMessageInfo

func (m *GetEntryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [LookupEntry][google.cloud.datacatalog.v1.DataCatalog.LookupEntry].
type LookupEntryRequest struct {
	// Required. Represents either the Google Cloud Platform resource or SQL name
	// for a Google Cloud Platform resource.
	//
	// Types that are valid to be assigned to TargetName:
	//	*LookupEntryRequest_LinkedResource
	//	*LookupEntryRequest_SqlResource
	TargetName           isLookupEntryRequest_TargetName `protobuf_oneof:"target_name"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *LookupEntryRequest) Reset()         { *m = LookupEntryRequest{} }
func (m *LookupEntryRequest) String() string { return proto.CompactTextString(m) }
func (*LookupEntryRequest) ProtoMessage()    {}
func (*LookupEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{12}
}

func (m *LookupEntryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupEntryRequest.Unmarshal(m, b)
}
func (m *LookupEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupEntryRequest.Marshal(b, m, deterministic)
}
func (m *LookupEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupEntryRequest.Merge(m, src)
}
func (m *LookupEntryRequest) XXX_Size() int {
	return xxx_messageInfo_LookupEntryRequest.Size(m)
}
func (m *LookupEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LookupEntryRequest proto.InternalMessageInfo

type isLookupEntryRequest_TargetName interface {
	isLookupEntryRequest_TargetName()
}

type LookupEntryRequest_LinkedResource struct {
	LinkedResource string `protobuf:"bytes,1,opt,name=linked_resource,json=linkedResource,proto3,oneof"`
}

type LookupEntryRequest_SqlResource struct {
	SqlResource string `protobuf:"bytes,3,opt,name=sql_resource,json=sqlResource,proto3,oneof"`
}

func (*LookupEntryRequest_LinkedResource) isLookupEntryRequest_TargetName() {}

func (*LookupEntryRequest_SqlResource) isLookupEntryRequest_TargetName() {}

func (m *LookupEntryRequest) GetTargetName() isLookupEntryRequest_TargetName {
	if m != nil {
		return m.TargetName
	}
	return nil
}

func (m *LookupEntryRequest) GetLinkedResource() string {
	if x, ok := m.GetTargetName().(*LookupEntryRequest_LinkedResource); ok {
		return x.LinkedResource
	}
	return ""
}

func (m *LookupEntryRequest) GetSqlResource() string {
	if x, ok := m.GetTargetName().(*LookupEntryRequest_SqlResource); ok {
		return x.SqlResource
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LookupEntryRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LookupEntryRequest_LinkedResource)(nil),
		(*LookupEntryRequest_SqlResource)(nil),
	}
}

// Entry Metadata.
// A Data Catalog Entry resource represents another resource in Google
// Cloud Platform (such as a BigQuery dataset or a Pub/Sub topic) or
// outside of Google Cloud Platform. Clients can use the `linked_resource` field
// in the Entry resource to refer to the original resource ID of the source
// system.
//
// An Entry resource contains resource details, such as its schema. An Entry can
// also be used to attach flexible metadata, such as a
// [Tag][google.cloud.datacatalog.v1.Tag].
type Entry struct {
	// The Data Catalog resource name of the entry in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	//
	// Note that this Entry and its child resources may not actually be stored in
	// the location in this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource this metadata entry refers to.
	//
	// For Google Cloud Platform resources, `linked_resource` is the [full name of
	// the
	// resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
	// For example, the `linked_resource` for a table resource from BigQuery is:
	//
	// * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
	//
	// Output only when Entry is of type in the EntryType enum. For entries with
	// user_specified_type, this field is optional and defaults to an empty
	// string.
	LinkedResource string `protobuf:"bytes,9,opt,name=linked_resource,json=linkedResource,proto3" json:"linked_resource,omitempty"`
	// Required. Entry type.
	//
	// Types that are valid to be assigned to EntryType:
	//	*Entry_Type
	//	*Entry_UserSpecifiedType
	EntryType isEntry_EntryType `protobuf_oneof:"entry_type"`
	// The source system of the entry.
	//
	// Types that are valid to be assigned to System:
	//	*Entry_IntegratedSystem
	//	*Entry_UserSpecifiedSystem
	System isEntry_System `protobuf_oneof:"system"`
	// Type specification information.
	//
	// Types that are valid to be assigned to TypeSpec:
	//	*Entry_GcsFilesetSpec
	//	*Entry_BigqueryTableSpec
	//	*Entry_BigqueryDateShardedSpec
	TypeSpec isEntry_TypeSpec `protobuf_oneof:"type_spec"`
	// Display information such as title and description. A short name to identify
	// the entry, for example, "Analytics Data - Jan 2011". Default value is an
	// empty string.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry description, which can consist of several sentences or paragraphs
	// that describe entry contents. Default value is an empty string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Schema of the entry. An entry might not have any schema attached to it.
	Schema *Schema `protobuf:"bytes,5,opt,name=schema,proto3" json:"schema,omitempty"`
	// Timestamps about the underlying resource, not about this Data Catalog
	// entry. Output only when Entry is of type in the EntryType enum. For entries
	// with user_specified_type, this field is optional and defaults to an empty
	// timestamp.
	SourceSystemTimestamps *SystemTimestamps `protobuf:"bytes,7,opt,name=source_system_timestamps,json=sourceSystemTimestamps,proto3" json:"source_system_timestamps,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}          `json:"-"`
	XXX_unrecognized       []byte            `json:"-"`
	XXX_sizecache          int32             `json:"-"`
}

func (m *Entry) Reset()         { *m = Entry{} }
func (m *Entry) String() string { return proto.CompactTextString(m) }
func (*Entry) ProtoMessage()    {}
func (*Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{13}
}

func (m *Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entry.Unmarshal(m, b)
}
func (m *Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entry.Marshal(b, m, deterministic)
}
func (m *Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entry.Merge(m, src)
}
func (m *Entry) XXX_Size() int {
	return xxx_messageInfo_Entry.Size(m)
}
func (m *Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Entry proto.InternalMessageInfo

func (m *Entry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Entry) GetLinkedResource() string {
	if m != nil {
		return m.LinkedResource
	}
	return ""
}

type isEntry_EntryType interface {
	isEntry_EntryType()
}

type Entry_Type struct {
	Type EntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.datacatalog.v1.EntryType,oneof"`
}

type Entry_UserSpecifiedType struct {
	UserSpecifiedType string `protobuf:"bytes,16,opt,name=user_specified_type,json=userSpecifiedType,proto3,oneof"`
}

func (*Entry_Type) isEntry_EntryType() {}

func (*Entry_UserSpecifiedType) isEntry_EntryType() {}

func (m *Entry) GetEntryType() isEntry_EntryType {
	if m != nil {
		return m.EntryType
	}
	return nil
}

func (m *Entry) GetType() EntryType {
	if x, ok := m.GetEntryType().(*Entry_Type); ok {
		return x.Type
	}
	return EntryType_ENTRY_TYPE_UNSPECIFIED
}

func (m *Entry) GetUserSpecifiedType() string {
	if x, ok := m.GetEntryType().(*Entry_UserSpecifiedType); ok {
		return x.UserSpecifiedType
	}
	return ""
}

type isEntry_System interface {
	isEntry_System()
}

type Entry_IntegratedSystem struct {
	IntegratedSystem IntegratedSystem `protobuf:"varint,17,opt,name=integrated_system,json=integratedSystem,proto3,enum=google.cloud.datacatalog.v1.IntegratedSystem,oneof"`
}

type Entry_UserSpecifiedSystem struct {
	UserSpecifiedSystem string `protobuf:"bytes,18,opt,name=user_specified_system,json=userSpecifiedSystem,proto3,oneof"`
}

func (*Entry_IntegratedSystem) isEntry_System() {}

func (*Entry_UserSpecifiedSystem) isEntry_System() {}

func (m *Entry) GetSystem() isEntry_System {
	if m != nil {
		return m.System
	}
	return nil
}

func (m *Entry) GetIntegratedSystem() IntegratedSystem {
	if x, ok := m.GetSystem().(*Entry_IntegratedSystem); ok {
		return x.IntegratedSystem
	}
	return IntegratedSystem_INTEGRATED_SYSTEM_UNSPECIFIED
}

func (m *Entry) GetUserSpecifiedSystem() string {
	if x, ok := m.GetSystem().(*Entry_UserSpecifiedSystem); ok {
		return x.UserSpecifiedSystem
	}
	return ""
}

type isEntry_TypeSpec interface {
	isEntry_TypeSpec()
}

type Entry_GcsFilesetSpec struct {
	GcsFilesetSpec *GcsFilesetSpec `protobuf:"bytes,6,opt,name=gcs_fileset_spec,json=gcsFilesetSpec,proto3,oneof"`
}

type Entry_BigqueryTableSpec struct {
	BigqueryTableSpec *BigQueryTableSpec `protobuf:"bytes,12,opt,name=bigquery_table_spec,json=bigqueryTableSpec,proto3,oneof"`
}

type Entry_BigqueryDateShardedSpec struct {
	BigqueryDateShardedSpec *BigQueryDateShardedSpec `protobuf:"bytes,15,opt,name=bigquery_date_sharded_spec,json=bigqueryDateShardedSpec,proto3,oneof"`
}

func (*Entry_GcsFilesetSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryTableSpec) isEntry_TypeSpec() {}

func (*Entry_BigqueryDateShardedSpec) isEntry_TypeSpec() {}

func (m *Entry) GetTypeSpec() isEntry_TypeSpec {
	if m != nil {
		return m.TypeSpec
	}
	return nil
}

func (m *Entry) GetGcsFilesetSpec() *GcsFilesetSpec {
	if x, ok := m.GetTypeSpec().(*Entry_GcsFilesetSpec); ok {
		return x.GcsFilesetSpec
	}
	return nil
}

func (m *Entry) GetBigqueryTableSpec() *BigQueryTableSpec {
	if x, ok := m.GetTypeSpec().(*Entry_BigqueryTableSpec); ok {
		return x.BigqueryTableSpec
	}
	return nil
}

func (m *Entry) GetBigqueryDateShardedSpec() *BigQueryDateShardedSpec {
	if x, ok := m.GetTypeSpec().(*Entry_BigqueryDateShardedSpec); ok {
		return x.BigqueryDateShardedSpec
	}
	return nil
}

func (m *Entry) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Entry) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entry) GetSchema() *Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *Entry) GetSourceSystemTimestamps() *SystemTimestamps {
	if m != nil {
		return m.SourceSystemTimestamps
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Entry) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Entry_Type)(nil),
		(*Entry_UserSpecifiedType)(nil),
		(*Entry_IntegratedSystem)(nil),
		(*Entry_UserSpecifiedSystem)(nil),
		(*Entry_GcsFilesetSpec)(nil),
		(*Entry_BigqueryTableSpec)(nil),
		(*Entry_BigqueryDateShardedSpec)(nil),
	}
}

// EntryGroup Metadata.
// An EntryGroup resource represents a logical grouping of zero or more
// Data Catalog [Entry][google.cloud.datacatalog.v1.Entry] resources.
type EntryGroup struct {
	// The resource name of the entry group in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	//
	// Note that this EntryGroup and its child resources may not actually be
	// stored in the location in this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A short name to identify the entry group, for example,
	// "analytics data - jan 2011". Default value is an empty string.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Entry group description, which can consist of several sentences or
	// paragraphs that describe entry group contents. Default value is an empty
	// string.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Timestamps about this EntryGroup. Default value is empty timestamps.
	DataCatalogTimestamps *SystemTimestamps `protobuf:"bytes,4,opt,name=data_catalog_timestamps,json=dataCatalogTimestamps,proto3" json:"data_catalog_timestamps,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}          `json:"-"`
	XXX_unrecognized      []byte            `json:"-"`
	XXX_sizecache         int32             `json:"-"`
}

func (m *EntryGroup) Reset()         { *m = EntryGroup{} }
func (m *EntryGroup) String() string { return proto.CompactTextString(m) }
func (*EntryGroup) ProtoMessage()    {}
func (*EntryGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{14}
}

func (m *EntryGroup) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntryGroup.Unmarshal(m, b)
}
func (m *EntryGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntryGroup.Marshal(b, m, deterministic)
}
func (m *EntryGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntryGroup.Merge(m, src)
}
func (m *EntryGroup) XXX_Size() int {
	return xxx_messageInfo_EntryGroup.Size(m)
}
func (m *EntryGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_EntryGroup.DiscardUnknown(m)
}

var xxx_messageInfo_EntryGroup proto.InternalMessageInfo

func (m *EntryGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EntryGroup) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *EntryGroup) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EntryGroup) GetDataCatalogTimestamps() *SystemTimestamps {
	if m != nil {
		return m.DataCatalogTimestamps
	}
	return nil
}

// Request message for
// [CreateTagTemplate][google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplate].
type CreateTagTemplateRequest struct {
	// Required. The name of the project and the template location
	// [region](/compute/docs/regions-zones/#available).
	// NOTE: Currently, only the `us-central1 region` is supported.
	//
	// Example:
	//
	// * projects/{project_id}/locations/us-central1
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the tag template to create.
	TagTemplateId string `protobuf:"bytes,3,opt,name=tag_template_id,json=tagTemplateId,proto3" json:"tag_template_id,omitempty"`
	// Required. The tag template to create.
	TagTemplate          *TagTemplate `protobuf:"bytes,2,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateTagTemplateRequest) Reset()         { *m = CreateTagTemplateRequest{} }
func (m *CreateTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagTemplateRequest) ProtoMessage()    {}
func (*CreateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{15}
}

func (m *CreateTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagTemplateRequest.Unmarshal(m, b)
}
func (m *CreateTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagTemplateRequest.Merge(m, src)
}
func (m *CreateTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagTemplateRequest.Size(m)
}
func (m *CreateTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagTemplateRequest proto.InternalMessageInfo

func (m *CreateTagTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagTemplateRequest) GetTagTemplateId() string {
	if m != nil {
		return m.TagTemplateId
	}
	return ""
}

func (m *CreateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if m != nil {
		return m.TagTemplate
	}
	return nil
}

// Request message for
// [GetTagTemplate][google.cloud.datacatalog.v1.DataCatalog.GetTagTemplate].
type GetTagTemplateRequest struct {
	// Required. The name of the tag template. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTagTemplateRequest) Reset()         { *m = GetTagTemplateRequest{} }
func (m *GetTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*GetTagTemplateRequest) ProtoMessage()    {}
func (*GetTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{16}
}

func (m *GetTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTagTemplateRequest.Unmarshal(m, b)
}
func (m *GetTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *GetTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTagTemplateRequest.Merge(m, src)
}
func (m *GetTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_GetTagTemplateRequest.Size(m)
}
func (m *GetTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTagTemplateRequest proto.InternalMessageInfo

func (m *GetTagTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [UpdateTagTemplate][google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplate].
type UpdateTagTemplateRequest struct {
	// Required. The template to update. The "name" field must be set.
	TagTemplate *TagTemplate `protobuf:"bytes,1,opt,name=tag_template,json=tagTemplate,proto3" json:"tag_template,omitempty"`
	// The field mask specifies the parts of the template to overwrite.
	//
	// Allowed fields:
	//
	//   * `display_name`
	//
	// If absent or empty, all of the allowed fields above will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagTemplateRequest) Reset()         { *m = UpdateTagTemplateRequest{} }
func (m *UpdateTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagTemplateRequest) ProtoMessage()    {}
func (*UpdateTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{17}
}

func (m *UpdateTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagTemplateRequest.Unmarshal(m, b)
}
func (m *UpdateTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagTemplateRequest.Merge(m, src)
}
func (m *UpdateTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagTemplateRequest.Size(m)
}
func (m *UpdateTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagTemplateRequest proto.InternalMessageInfo

func (m *UpdateTagTemplateRequest) GetTagTemplate() *TagTemplate {
	if m != nil {
		return m.TagTemplate
	}
	return nil
}

func (m *UpdateTagTemplateRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTagTemplate][google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplate].
type DeleteTagTemplateRequest struct {
	// Required. The name of the tag template to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Currently, this field must always be set to `true`.
	// This confirms the deletion of any possible tags using this template.
	// `force = false` will be supported in the future.
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagTemplateRequest) Reset()         { *m = DeleteTagTemplateRequest{} }
func (m *DeleteTagTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagTemplateRequest) ProtoMessage()    {}
func (*DeleteTagTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{18}
}

func (m *DeleteTagTemplateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagTemplateRequest.Unmarshal(m, b)
}
func (m *DeleteTagTemplateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagTemplateRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagTemplateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagTemplateRequest.Merge(m, src)
}
func (m *DeleteTagTemplateRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagTemplateRequest.Size(m)
}
func (m *DeleteTagTemplateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagTemplateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagTemplateRequest proto.InternalMessageInfo

func (m *DeleteTagTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteTagTemplateRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Request message for
// [CreateTag][google.cloud.datacatalog.v1.DataCatalog.CreateTag].
type CreateTagRequest struct {
	// Required. The name of the resource to attach this tag to. Tags can be attached to
	// Entries. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	//
	// Note that this Tag and its child resources may not actually be stored in
	// the location in this name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tag to create.
	Tag                  *Tag     `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTagRequest) Reset()         { *m = CreateTagRequest{} }
func (m *CreateTagRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagRequest) ProtoMessage()    {}
func (*CreateTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{19}
}

func (m *CreateTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagRequest.Unmarshal(m, b)
}
func (m *CreateTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagRequest.Merge(m, src)
}
func (m *CreateTagRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagRequest.Size(m)
}
func (m *CreateTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagRequest proto.InternalMessageInfo

func (m *CreateTagRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagRequest) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

// Request message for
// [UpdateTag][google.cloud.datacatalog.v1.DataCatalog.UpdateTag].
type UpdateTagRequest struct {
	// Required. The updated tag. The "name" field must be set.
	Tag *Tag `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
	// The fields to update on the Tag. If absent or empty, all modifiable fields
	// are updated. Currently the only modifiable field is the field `fields`.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagRequest) Reset()         { *m = UpdateTagRequest{} }
func (m *UpdateTagRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagRequest) ProtoMessage()    {}
func (*UpdateTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{20}
}

func (m *UpdateTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagRequest.Unmarshal(m, b)
}
func (m *UpdateTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagRequest.Merge(m, src)
}
func (m *UpdateTagRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagRequest.Size(m)
}
func (m *UpdateTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagRequest proto.InternalMessageInfo

func (m *UpdateTagRequest) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *UpdateTagRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [DeleteTag][google.cloud.datacatalog.v1.DataCatalog.DeleteTag].
type DeleteTagRequest struct {
	// Required. The name of the tag to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagRequest) Reset()         { *m = DeleteTagRequest{} }
func (m *DeleteTagRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagRequest) ProtoMessage()    {}
func (*DeleteTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{21}
}

func (m *DeleteTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagRequest.Unmarshal(m, b)
}
func (m *DeleteTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagRequest.Merge(m, src)
}
func (m *DeleteTagRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagRequest.Size(m)
}
func (m *DeleteTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagRequest proto.InternalMessageInfo

func (m *DeleteTagRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [CreateTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.CreateTagTemplateField].
type CreateTagTemplateFieldRequest struct {
	// Required. The name of the project and the template location
	// [region](/compute/docs/regions-zones/#available).
	// NOTE: Currently, only the `us-central1 region` is supported.
	//
	// Example:
	//
	// * projects/{project_id}/locations/us-central1/tagTemplates/{tag_template_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the tag template field to create.
	// Field ids can contain letters (both uppercase and lowercase), numbers
	// (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
	// character long and at most 128 characters long. Field IDs must also be
	// unique within their template.
	TagTemplateFieldId string `protobuf:"bytes,2,opt,name=tag_template_field_id,json=tagTemplateFieldId,proto3" json:"tag_template_field_id,omitempty"`
	// Required. The tag template field to create.
	TagTemplateField     *TagTemplateField `protobuf:"bytes,3,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CreateTagTemplateFieldRequest) Reset()         { *m = CreateTagTemplateFieldRequest{} }
func (m *CreateTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagTemplateFieldRequest) ProtoMessage()    {}
func (*CreateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{22}
}

func (m *CreateTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *CreateTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *CreateTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagTemplateFieldRequest.Merge(m, src)
}
func (m *CreateTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagTemplateFieldRequest.Size(m)
}
func (m *CreateTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagTemplateFieldRequest proto.InternalMessageInfo

func (m *CreateTagTemplateFieldRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagTemplateFieldRequest) GetTagTemplateFieldId() string {
	if m != nil {
		return m.TagTemplateFieldId
	}
	return ""
}

func (m *CreateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if m != nil {
		return m.TagTemplateField
	}
	return nil
}

// Request message for
// [UpdateTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.UpdateTagTemplateField].
type UpdateTagTemplateFieldRequest struct {
	// Required. The name of the tag template field. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The template to update.
	TagTemplateField *TagTemplateField `protobuf:"bytes,2,opt,name=tag_template_field,json=tagTemplateField,proto3" json:"tag_template_field,omitempty"`
	// Optional. The field mask specifies the parts of the template to be updated.
	// Allowed fields:
	//
	//   * `display_name`
	//   * `type.enum_type`
	//   * `is_required`
	//
	// If `update_mask` is not set or empty, all of the allowed fields above will
	// be updated.
	//
	// When updating an enum type, the provided values will be merged with the
	// existing values. Therefore, enum values can only be added, existing enum
	// values cannot be deleted nor renamed. Updating a template field from
	// optional to required is NOT allowed.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateTagTemplateFieldRequest) Reset()         { *m = UpdateTagTemplateFieldRequest{} }
func (m *UpdateTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTagTemplateFieldRequest) ProtoMessage()    {}
func (*UpdateTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{23}
}

func (m *UpdateTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTagTemplateFieldRequest.Merge(m, src)
}
func (m *UpdateTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTagTemplateFieldRequest.Size(m)
}
func (m *UpdateTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTagTemplateFieldRequest proto.InternalMessageInfo

func (m *UpdateTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateTagTemplateFieldRequest) GetTagTemplateField() *TagTemplateField {
	if m != nil {
		return m.TagTemplateField
	}
	return nil
}

func (m *UpdateTagTemplateFieldRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for
// [RenameTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.RenameTagTemplateField].
type RenameTagTemplateFieldRequest struct {
	// Required. The name of the tag template. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The new ID of this tag template field. For example, `my_new_field`.
	NewTagTemplateFieldId string   `protobuf:"bytes,2,opt,name=new_tag_template_field_id,json=newTagTemplateFieldId,proto3" json:"new_tag_template_field_id,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *RenameTagTemplateFieldRequest) Reset()         { *m = RenameTagTemplateFieldRequest{} }
func (m *RenameTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*RenameTagTemplateFieldRequest) ProtoMessage()    {}
func (*RenameTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{24}
}

func (m *RenameTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *RenameTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *RenameTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RenameTagTemplateFieldRequest.Merge(m, src)
}
func (m *RenameTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_RenameTagTemplateFieldRequest.Size(m)
}
func (m *RenameTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RenameTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RenameTagTemplateFieldRequest proto.InternalMessageInfo

func (m *RenameTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RenameTagTemplateFieldRequest) GetNewTagTemplateFieldId() string {
	if m != nil {
		return m.NewTagTemplateFieldId
	}
	return ""
}

// Request message for
// [DeleteTagTemplateField][google.cloud.datacatalog.v1.DataCatalog.DeleteTagTemplateField].
type DeleteTagTemplateFieldRequest struct {
	// Required. The name of the tag template field to delete. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}/fields/{tag_template_field_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Currently, this field must always be set to `true`.
	// This confirms the deletion of this field from any tags using this field.
	// `force = false` will be supported in the future.
	Force                bool     `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagTemplateFieldRequest) Reset()         { *m = DeleteTagTemplateFieldRequest{} }
func (m *DeleteTagTemplateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagTemplateFieldRequest) ProtoMessage()    {}
func (*DeleteTagTemplateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{25}
}

func (m *DeleteTagTemplateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Unmarshal(m, b)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagTemplateFieldRequest.Merge(m, src)
}
func (m *DeleteTagTemplateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagTemplateFieldRequest.Size(m)
}
func (m *DeleteTagTemplateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagTemplateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagTemplateFieldRequest proto.InternalMessageInfo

func (m *DeleteTagTemplateFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteTagTemplateFieldRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// Request message for
// [ListTags][google.cloud.datacatalog.v1.DataCatalog.ListTags].
type ListTagsRequest struct {
	// Required. The name of the Data Catalog resource to list the tags of. The resource
	// could be an [Entry][google.cloud.datacatalog.v1.Entry] or an
	// [EntryGroup][google.cloud.datacatalog.v1.EntryGroup].
	//
	// Examples:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of tags to return. Default is 10. Max limit is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token that specifies which page is requested. If empty, the first page is
	// returned.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTagsRequest) Reset()         { *m = ListTagsRequest{} }
func (m *ListTagsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTagsRequest) ProtoMessage()    {}
func (*ListTagsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{26}
}

func (m *ListTagsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTagsRequest.Unmarshal(m, b)
}
func (m *ListTagsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTagsRequest.Marshal(b, m, deterministic)
}
func (m *ListTagsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTagsRequest.Merge(m, src)
}
func (m *ListTagsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTagsRequest.Size(m)
}
func (m *ListTagsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTagsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTagsRequest proto.InternalMessageInfo

func (m *ListTagsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTagsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTagsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for
// [ListTags][google.cloud.datacatalog.v1.DataCatalog.ListTags].
type ListTagsResponse struct {
	// [Tag][google.cloud.datacatalog.v1.Tag] details.
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no items
	// remain in results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTagsResponse) Reset()         { *m = ListTagsResponse{} }
func (m *ListTagsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTagsResponse) ProtoMessage()    {}
func (*ListTagsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{27}
}

func (m *ListTagsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTagsResponse.Unmarshal(m, b)
}
func (m *ListTagsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTagsResponse.Marshal(b, m, deterministic)
}
func (m *ListTagsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTagsResponse.Merge(m, src)
}
func (m *ListTagsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTagsResponse.Size(m)
}
func (m *ListTagsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTagsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTagsResponse proto.InternalMessageInfo

func (m *ListTagsResponse) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ListTagsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for
// [ListEntries][google.cloud.datacatalog.v1.DataCatalog.ListEntries].
type ListEntriesRequest struct {
	// Required. The name of the entry group that contains the entries, which can
	// be provided in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return. Default is 10. Max limit is 1000.
	// Throws an invalid argument for `page_size > 1000`.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token that specifies which page is requested. If empty, the first page is
	// returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The fields to return for each Entry. If not set or empty, all
	// fields are returned.
	// For example, setting read_mask to contain only one path "name" will cause
	// ListEntries to return a list of Entries with only "name" field.
	ReadMask             *field_mask.FieldMask `protobuf:"bytes,4,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListEntriesRequest) Reset()         { *m = ListEntriesRequest{} }
func (m *ListEntriesRequest) String() string { return proto.CompactTextString(m) }
func (*ListEntriesRequest) ProtoMessage()    {}
func (*ListEntriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{28}
}

func (m *ListEntriesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntriesRequest.Unmarshal(m, b)
}
func (m *ListEntriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntriesRequest.Marshal(b, m, deterministic)
}
func (m *ListEntriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntriesRequest.Merge(m, src)
}
func (m *ListEntriesRequest) XXX_Size() int {
	return xxx_messageInfo_ListEntriesRequest.Size(m)
}
func (m *ListEntriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntriesRequest proto.InternalMessageInfo

func (m *ListEntriesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListEntriesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListEntriesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListEntriesRequest) GetReadMask() *field_mask.FieldMask {
	if m != nil {
		return m.ReadMask
	}
	return nil
}

// Response message for
// [ListEntries][google.cloud.datacatalog.v1.DataCatalog.ListEntries].
type ListEntriesResponse struct {
	// Entry details.
	Entries []*Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no items
	// remain in results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListEntriesResponse) Reset()         { *m = ListEntriesResponse{} }
func (m *ListEntriesResponse) String() string { return proto.CompactTextString(m) }
func (*ListEntriesResponse) ProtoMessage()    {}
func (*ListEntriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_432e04443b4c65a3, []int{29}
}

func (m *ListEntriesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListEntriesResponse.Unmarshal(m, b)
}
func (m *ListEntriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListEntriesResponse.Marshal(b, m, deterministic)
}
func (m *ListEntriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListEntriesResponse.Merge(m, src)
}
func (m *ListEntriesResponse) XXX_Size() int {
	return xxx_messageInfo_ListEntriesResponse.Size(m)
}
func (m *ListEntriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListEntriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListEntriesResponse proto.InternalMessageInfo

func (m *ListEntriesResponse) GetEntries() []*Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *ListEntriesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.datacatalog.v1.EntryType", EntryType_name, EntryType_value)
	proto.RegisterType((*SearchCatalogRequest)(nil), "google.cloud.datacatalog.v1.SearchCatalogRequest")
	proto.RegisterType((*SearchCatalogRequest_Scope)(nil), "google.cloud.datacatalog.v1.SearchCatalogRequest.Scope")
	proto.RegisterType((*SearchCatalogResponse)(nil), "google.cloud.datacatalog.v1.SearchCatalogResponse")
	proto.RegisterType((*CreateEntryGroupRequest)(nil), "google.cloud.datacatalog.v1.CreateEntryGroupRequest")
	proto.RegisterType((*UpdateEntryGroupRequest)(nil), "google.cloud.datacatalog.v1.UpdateEntryGroupRequest")
	proto.RegisterType((*GetEntryGroupRequest)(nil), "google.cloud.datacatalog.v1.GetEntryGroupRequest")
	proto.RegisterType((*DeleteEntryGroupRequest)(nil), "google.cloud.datacatalog.v1.DeleteEntryGroupRequest")
	proto.RegisterType((*ListEntryGroupsRequest)(nil), "google.cloud.datacatalog.v1.ListEntryGroupsRequest")
	proto.RegisterType((*ListEntryGroupsResponse)(nil), "google.cloud.datacatalog.v1.ListEntryGroupsResponse")
	proto.RegisterType((*CreateEntryRequest)(nil), "google.cloud.datacatalog.v1.CreateEntryRequest")
	proto.RegisterType((*UpdateEntryRequest)(nil), "google.cloud.datacatalog.v1.UpdateEntryRequest")
	proto.RegisterType((*DeleteEntryRequest)(nil), "google.cloud.datacatalog.v1.DeleteEntryRequest")
	proto.RegisterType((*GetEntryRequest)(nil), "google.cloud.datacatalog.v1.GetEntryRequest")
	proto.RegisterType((*LookupEntryRequest)(nil), "google.cloud.datacatalog.v1.LookupEntryRequest")
	proto.RegisterType((*Entry)(nil), "google.cloud.datacatalog.v1.Entry")
	proto.RegisterType((*EntryGroup)(nil), "google.cloud.datacatalog.v1.EntryGroup")
	proto.RegisterType((*CreateTagTemplateRequest)(nil), "google.cloud.datacatalog.v1.CreateTagTemplateRequest")
	proto.RegisterType((*GetTagTemplateRequest)(nil), "google.cloud.datacatalog.v1.GetTagTemplateRequest")
	proto.RegisterType((*UpdateTagTemplateRequest)(nil), "google.cloud.datacatalog.v1.UpdateTagTemplateRequest")
	proto.RegisterType((*DeleteTagTemplateRequest)(nil), "google.cloud.datacatalog.v1.DeleteTagTemplateRequest")
	proto.RegisterType((*CreateTagRequest)(nil), "google.cloud.datacatalog.v1.CreateTagRequest")
	proto.RegisterType((*UpdateTagRequest)(nil), "google.cloud.datacatalog.v1.UpdateTagRequest")
	proto.RegisterType((*DeleteTagRequest)(nil), "google.cloud.datacatalog.v1.DeleteTagRequest")
	proto.RegisterType((*CreateTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1.CreateTagTemplateFieldRequest")
	proto.RegisterType((*UpdateTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1.UpdateTagTemplateFieldRequest")
	proto.RegisterType((*RenameTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1.RenameTagTemplateFieldRequest")
	proto.RegisterType((*DeleteTagTemplateFieldRequest)(nil), "google.cloud.datacatalog.v1.DeleteTagTemplateFieldRequest")
	proto.RegisterType((*ListTagsRequest)(nil), "google.cloud.datacatalog.v1.ListTagsRequest")
	proto.RegisterType((*ListTagsResponse)(nil), "google.cloud.datacatalog.v1.ListTagsResponse")
	proto.RegisterType((*ListEntriesRequest)(nil), "google.cloud.datacatalog.v1.ListEntriesRequest")
	proto.RegisterType((*ListEntriesResponse)(nil), "google.cloud.datacatalog.v1.ListEntriesResponse")
}

func init() {
	proto.RegisterFile("google/cloud/datacatalog/v1/datacatalog.proto", fileDescriptor_432e04443b4c65a3)
}

var fileDescriptor_432e04443b4c65a3 = []byte{
	// 3043 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x5a, 0x5b, 0x6c, 0x1b, 0xc7,
	0xd5, 0xce, 0x50, 0x92, 0x2d, 0x1d, 0xca, 0x96, 0x34, 0x8e, 0x24, 0x9a, 0xfe, 0xed, 0x28, 0x6b,
	0xfc, 0x8e, 0x42, 0xdb, 0xa4, 0xc5, 0xf8, 0xcf, 0x85, 0x8e, 0x1d, 0xaf, 0x2c, 0xea, 0xe2, 0xdf,
	0xb6, 0x94, 0x15, 0x93, 0x1f, 0x71, 0x02, 0x30, 0x2b, 0x72, 0xbc, 0x5a, 0x9b, 0xe4, 0xd2, 0xbb,
	0xcb, 0x38, 0x8a, 0xe3, 0x1f, 0x68, 0x0a, 0xf4, 0x82, 0xc4, 0x45, 0xd0, 0xcb, 0x4b, 0x0b, 0x14,
	0x01, 0x8a, 0xb6, 0x48, 0x81, 0xa2, 0x28, 0xfa, 0x56, 0x04, 0x45, 0x1f, 0xfa, 0x94, 0x02, 0x45,
	0xd1, 0xa2, 0x2f, 0x2c, 0x10, 0xa4, 0xb7, 0x97, 0xf4, 0xa5, 0x45, 0x51, 0xf4, 0xf2, 0x54, 0xec,
	0xcc, 0x2c, 0x39, 0xbb, 0x4b, 0x72, 0x77, 0x25, 0xe7, 0x49, 0xe2, 0x9c, 0x33, 0xe7, 0xf2, 0xcd,
	0x39, 0x67, 0xce, 0x1c, 0x12, 0x4e, 0x6b, 0x86, 0xa1, 0xd5, 0x48, 0xae, 0x52, 0x33, 0x5a, 0xd5,
	0x5c, 0x55, 0xb5, 0xd5, 0x8a, 0x6a, 0xab, 0x35, 0x43, 0xcb, 0xbd, 0xb6, 0x20, 0x7e, 0xcc, 0x36,
	0x4d, 0xc3, 0x36, 0xf0, 0x11, 0xc6, 0x9e, 0xa5, 0xec, 0x59, 0x91, 0xfe, 0xda, 0x42, 0xfa, 0xbf,
	0xb8, 0x2c, 0xb5, 0xa9, 0xe7, 0xd4, 0x46, 0xc3, 0xb0, 0x55, 0x5b, 0x37, 0x1a, 0x16, 0xdb, 0x9a,
	0x9e, 0x15, 0xa8, 0x95, 0x9a, 0x4e, 0x1a, 0x36, 0x27, 0x3c, 0x22, 0x10, 0x6e, 0xe8, 0xa4, 0x56,
	0x2d, 0x6f, 0x91, 0x6d, 0xf5, 0x35, 0xdd, 0x30, 0x39, 0xc3, 0x61, 0x81, 0xc1, 0x24, 0x96, 0xd1,
	0x32, 0x2b, 0x84, 0x93, 0xe6, 0x07, 0x99, 0x5f, 0x31, 0xea, 0x75, 0xa3, 0xc1, 0x39, 0xf3, 0x83,
	0x38, 0xb5, 0x8a, 0x55, 0xbe, 0xa1, 0xd7, 0x88, 0x45, 0xec, 0xb2, 0xd5, 0x24, 0x95, 0x28, 0xd2,
	0xad, 0xca, 0x36, 0xa9, 0xab, 0x91, 0x38, 0x89, 0x6a, 0x56, 0xb6, 0x39, 0xe7, 0xa9, 0x41, 0x9c,
	0xb6, 0xba, 0x55, 0x23, 0xa2, 0x05, 0x27, 0x06, 0x73, 0x6b, 0x56, 0x24, 0xa9, 0x7a, 0x9d, 0x58,
	0xb6, 0x5a, 0x6f, 0xba, 0xdc, 0xc7, 0x38, 0xb7, 0xae, 0xd6, 0x1d, 0xba, 0xae, 0xd6, 0xcb, 0x4d,
	0xa3, 0xa6, 0x57, 0x76, 0x38, 0x3d, 0xed, 0xa5, 0x7b, 0x68, 0x3c, 0x02, 0x72, 0xf4, 0xd3, 0x56,
	0xeb, 0x46, 0x8e, 0xd4, 0x9b, 0xb6, 0x4b, 0x9c, 0xf3, 0x13, 0xd9, 0x79, 0xd6, 0x55, 0xeb, 0x16,
	0xe3, 0x90, 0xde, 0x1a, 0x82, 0x87, 0x37, 0x29, 0x1e, 0x97, 0x98, 0x81, 0x0a, 0xb9, 0xdd, 0x22,
	0x96, 0x8d, 0x15, 0x18, 0xb1, 0x2a, 0x46, 0x93, 0xa4, 0xf6, 0xcd, 0xa1, 0xf9, 0x64, 0xfe, 0xa9,
	0xec, 0x80, 0x48, 0xcb, 0xf6, 0x92, 0x90, 0xdd, 0x74, 0xb6, 0x2f, 0x0e, 0x7d, 0x2c, 0x27, 0x14,
	0x26, 0x0a, 0x1f, 0x86, 0x91, 0xdb, 0x2d, 0x62, 0xee, 0xa4, 0xd0, 0x1c, 0x9a, 0x1f, 0xe3, 0x24,
	0xba, 0x82, 0x8f, 0xc0, 0x58, 0x53, 0xd5, 0x48, 0xd9, 0xd2, 0xdf, 0x20, 0xa9, 0xc4, 0x1c, 0x9a,
	0x1f, 0x51, 0x46, 0x9d, 0x85, 0x4d, 0xfd, 0x0d, 0x82, 0x25, 0x00, 0x4a, 0xb4, 0x8d, 0x5b, 0xa4,
	0x91, 0x1a, 0x72, 0x37, 0x23, 0x85, 0xee, 0x29, 0x39, 0xab, 0xf8, 0x30, 0x8c, 0x1a, 0x66, 0x95,
	0x98, 0xe5, 0xad, 0x9d, 0xd4, 0x88, 0xc3, 0xa1, 0xec, 0xa7, 0x9f, 0x17, 0x77, 0xd2, 0xdf, 0x44,
	0x30, 0x42, 0x8d, 0xc1, 0x27, 0x60, 0x42, 0x6f, 0x54, 0x6a, 0xad, 0x2a, 0x29, 0x1b, 0xa6, 0x56,
	0xd6, 0xab, 0x56, 0x2a, 0x31, 0x37, 0x34, 0x3f, 0xa6, 0x1c, 0xe0, 0xcb, 0xeb, 0xa6, 0xb6, 0x56,
	0xb5, 0x70, 0x16, 0x0e, 0xb9, 0x7c, 0x4d, 0xd3, 0xb8, 0x49, 0x2a, 0x36, 0xe5, 0x1d, 0xa2, 0xbc,
	0x53, 0x9c, 0xb4, 0xc1, 0x28, 0x0e, 0xff, 0x79, 0x38, 0xe2, 0xf2, 0x6b, 0x95, 0x66, 0xb9, 0xd9,
	0xda, 0xaa, 0xe9, 0x95, 0xb2, 0x03, 0x92, 0x45, 0x6c, 0x2b, 0xb5, 0x7f, 0x0e, 0xcd, 0x8f, 0x2a,
	0x29, 0xce, 0xb2, 0x52, 0x69, 0x6e, 0x50, 0x86, 0x25, 0x4e, 0x97, 0xde, 0x46, 0x30, 0xed, 0x83,
	0xd0, 0x6a, 0x1a, 0x0d, 0x8b, 0xe0, 0xcb, 0xb0, 0xdf, 0x24, 0x56, 0xab, 0x66, 0x5b, 0x29, 0x34,
	0x37, 0x34, 0x9f, 0xcc, 0x9f, 0x89, 0x73, 0x0e, 0xce, 0x46, 0xc5, 0x15, 0xe0, 0x38, 0xdf, 0x20,
	0xaf, 0xdb, 0x65, 0x3f, 0x94, 0xca, 0x01, 0x67, 0x79, 0xc3, 0x45, 0x52, 0xfa, 0x0d, 0x82, 0xd9,
	0x4b, 0x26, 0x51, 0x6d, 0x52, 0x6c, 0xd8, 0xe6, 0xce, 0x8a, 0x69, 0xb4, 0x9a, 0x6e, 0x54, 0x14,
	0x61, 0x5f, 0x53, 0x35, 0x49, 0xc3, 0xe6, 0x47, 0x78, 0xfa, 0x63, 0x39, 0xf1, 0x6f, 0xf9, 0x31,
	0xfc, 0xdf, 0xa2, 0x21, 0xcc, 0x42, 0xb5, 0xa9, 0x5b, 0xd9, 0x8a, 0x51, 0xcf, 0x09, 0x52, 0xf8,
	0x66, 0xfc, 0x38, 0x1c, 0x24, 0xce, 0x6a, 0x59, 0x73, 0x96, 0xcb, 0x7a, 0xb5, 0x7b, 0xa8, 0x09,
	0x65, 0x9c, 0x74, 0x36, 0xac, 0x55, 0xf1, 0x2a, 0x24, 0x05, 0x56, 0x1a, 0x1a, 0xc9, 0xfc, 0x63,
	0x03, 0x51, 0x10, 0x14, 0x42, 0x57, 0x96, 0xf4, 0x6d, 0x04, 0xb3, 0x2f, 0x34, 0xab, 0x3d, 0xfd,
	0xba, 0xea, 0xd5, 0x82, 0x62, 0x69, 0x61, 0x66, 0x0b, 0xaa, 0xf0, 0x39, 0x48, 0xb6, 0xa8, 0x26,
	0x9a, 0x6a, 0xdc, 0xe8, 0xb4, 0x2b, 0xce, 0xcd, 0xc6, 0xec, 0xb2, 0x93, 0x8d, 0x57, 0x55, 0xeb,
	0x96, 0x02, 0x8c, 0xdd, 0xf9, 0x5f, 0xfa, 0x32, 0x82, 0x87, 0x57, 0x88, 0x1d, 0x34, 0x52, 0x86,
	0xe1, 0x86, 0x5a, 0x27, 0x5e, 0xe8, 0x21, 0x22, 0xf4, 0x74, 0x2b, 0x7e, 0x0a, 0xc6, 0x4c, 0xa2,
	0x56, 0xa3, 0x9a, 0x35, 0xea, 0x30, 0x53, 0xa3, 0xee, 0xc0, 0xec, 0x12, 0xa9, 0x91, 0x5e, 0xd8,
	0x3d, 0x00, 0xb3, 0x0e, 0xc3, 0xc8, 0x0d, 0xc3, 0xac, 0xb0, 0xcc, 0x1f, 0x65, 0xb9, 0xcd, 0x56,
	0x9c, 0x53, 0x9b, 0xb9, 0xa2, 0x5b, 0x02, 0x1c, 0x56, 0x48, 0x30, 0x42, 0xcc, 0x60, 0x9c, 0x0b,
	0x94, 0x1e, 0x66, 0x40, 0xac, 0xfa, 0x23, 0xdd, 0x47, 0x30, 0x1b, 0xb0, 0xb3, 0x93, 0xc5, 0xe3,
	0x42, 0x74, 0xb9, 0xa9, 0x1c, 0x39, 0x88, 0x93, 0xdd, 0xc8, 0xea, 0x99, 0xc5, 0x89, 0x5e, 0x59,
	0xfc, 0x63, 0x04, 0x58, 0xc8, 0xe2, 0x07, 0x8c, 0xd9, 0x31, 0x18, 0x65, 0x1e, 0x79, 0x53, 0x77,
	0x3f, 0x5d, 0x5c, 0xab, 0xe2, 0xf3, 0x30, 0x42, 0xff, 0xe5, 0x31, 0x26, 0x85, 0xbb, 0xca, 0x6f,
	0x03, 0xba, 0x4b, 0x7a, 0x17, 0x01, 0x16, 0x52, 0xd5, 0x35, 0xbe, 0x23, 0x15, 0xed, 0x46, 0xea,
	0xde, 0xb2, 0x52, 0x01, 0x2c, 0x24, 0x80, 0x6b, 0xd1, 0xb3, 0x9e, 0xd8, 0x9f, 0xa7, 0x60, 0x4a,
	0x30, 0x17, 0x06, 0x26, 0x0b, 0x7b, 0x69, 0x1d, 0x26, 0xdc, 0x44, 0x7f, 0x30, 0x02, 0x2d, 0xc0,
	0x57, 0x0c, 0xe3, 0x56, 0xab, 0xe9, 0x91, 0xf9, 0x38, 0x4c, 0xd4, 0xf4, 0xc6, 0x2d, 0x52, 0x2d,
	0xbb, 0xdd, 0x1a, 0x13, 0xbf, 0xfa, 0x90, 0x72, 0x90, 0x11, 0x14, 0xbe, 0x8e, 0x8f, 0xc3, 0xb8,
	0x75, 0xbb, 0xd6, 0xe5, 0x1b, 0xe2, 0x7c, 0x49, 0xeb, 0x76, 0xcd, 0x65, 0x5a, 0x3c, 0x00, 0x49,
	0x5b, 0x35, 0x35, 0x62, 0x97, 0xa9, 0xd2, 0x1f, 0x8d, 0xc2, 0x08, 0xd5, 0x87, 0x2f, 0x78, 0x8c,
	0xcf, 0xc4, 0x2e, 0x03, 0x8f, 0x05, 0x0d, 0x1d, 0xa3, 0xb1, 0xed, 0x37, 0xf3, 0x59, 0x18, 0xb6,
	0x77, 0x9a, 0x2c, 0x5b, 0x0f, 0xe6, 0x4f, 0x84, 0xc7, 0x41, 0x69, 0xa7, 0x49, 0x56, 0x1f, 0x52,
	0xe8, 0x2e, 0x7c, 0x06, 0x0e, 0xb5, 0x2c, 0x62, 0xd2, 0xbe, 0x4e, 0xbf, 0xa1, 0x93, 0x6a, 0x99,
	0x0a, 0x9b, 0xe4, 0xbe, 0x4e, 0x39, 0xc4, 0x4d, 0x97, 0xe6, 0xec, 0xc4, 0x2a, 0x4c, 0xe9, 0x0d,
	0x9b, 0x68, 0xa6, 0x6a, 0x93, 0x6a, 0xd9, 0xda, 0xb1, 0x6c, 0x52, 0x4f, 0x4d, 0x51, 0xe5, 0xa7,
	0x07, 0x2a, 0x5f, 0xeb, 0xec, 0xda, 0xa4, 0x9b, 0x9c, 0x78, 0x1c, 0x5a, 0x45, 0xca, 0xa4, 0xee,
	0x23, 0xe0, 0xb3, 0x30, 0xed, 0x33, 0x8a, 0xab, 0xc1, 0xd4, 0x2c, 0xa4, 0x1c, 0xf2, 0x98, 0xc5,
	0x77, 0xfd, 0x1f, 0x4c, 0xfa, 0x7b, 0x65, 0xde, 0xb0, 0x9d, 0x1c, 0x68, 0xd7, 0x4a, 0xc5, 0x5a,
	0x66, 0x7b, 0x1c, 0x89, 0xab, 0x09, 0xe5, 0xa0, 0xe6, 0x59, 0xc1, 0xaf, 0xc2, 0xa1, 0x2d, 0x5d,
	0xa3, 0xbd, 0x59, 0xb9, 0xdb, 0x05, 0xa7, 0xc6, 0xa9, 0xec, 0xec, 0x40, 0xd9, 0x8b, 0xba, 0xf6,
	0xbc, 0xb3, 0xaf, 0xe4, 0x6c, 0xe3, 0xe2, 0xa7, 0x5c, 0x61, 0x9d, 0x45, 0x6c, 0x41, 0xba, 0xa3,
	0x81, 0x26, 0xa5, 0xb5, 0xad, 0x9a, 0x55, 0xc7, 0x6f, 0x47, 0xd1, 0x04, 0x55, 0x74, 0x36, 0x92,
	0xa2, 0x25, 0xd5, 0x26, 0x9b, 0x6c, 0x33, 0x57, 0x37, 0xeb, 0x4a, 0xf6, 0x91, 0xf0, 0xa3, 0x30,
	0x5e, 0xd5, 0xad, 0x66, 0x4d, 0xdd, 0xa1, 0xb1, 0xcb, 0x1b, 0xa0, 0x24, 0x5f, 0xbb, 0xe6, 0x04,
	0xe1, 0x1c, 0x24, 0xab, 0xc4, 0xaa, 0x98, 0x7a, 0xd3, 0x79, 0x2d, 0xa5, 0x86, 0x39, 0x47, 0x77,
	0x09, 0x9f, 0x83, 0x7d, 0xec, 0xb1, 0x41, 0x1b, 0xcd, 0x64, 0xfe, 0xf8, 0xe0, 0x9e, 0x8c, 0xb2,
	0x2a, 0x7c, 0x0b, 0xd6, 0x20, 0xc5, 0x82, 0x98, 0x9f, 0x6f, 0xb9, 0xfb, 0x1a, 0xa0, 0x7d, 0x62,
	0x32, 0x24, 0xa2, 0xd8, 0xc1, 0x97, 0x3a, 0x9b, 0x94, 0x19, 0x26, 0xce, 0xbf, 0x5e, 0x78, 0xfd,
	0x13, 0xb9, 0x15, 0x5e, 0x38, 0xf0, 0xf3, 0xbc, 0xc1, 0xb5, 0x72, 0x77, 0xf9, 0x7f, 0xf7, 0x72,
	0x35, 0xa3, 0xc2, 0x9e, 0x8a, 0xb9, 0xbb, 0xee, 0xbf, 0xf7, 0x72, 0xc2, 0x25, 0x94, 0xbb, 0x2b,
	0x5c, 0x67, 0x8c, 0xa2, 0x13, 0x77, 0xf5, 0xde, 0xe2, 0x38, 0xb0, 0x5e, 0x88, 0xa6, 0xd5, 0xe2,
	0x28, 0xec, 0x63, 0x9e, 0x2e, 0x26, 0x61, 0xcc, 0x59, 0xa1, 0x07, 0x2c, 0xfd, 0x34, 0x01, 0xd0,
	0x2d, 0x00, 0x18, 0x8b, 0xa5, 0x83, 0x97, 0x03, 0xff, 0x61, 0x25, 0x42, 0x0f, 0x6b, 0x28, 0x78,
	0x58, 0x37, 0x61, 0xd6, 0xc1, 0xa0, 0xcc, 0x41, 0x10, 0xe1, 0x1e, 0xde, 0x05, 0xdc, 0x34, 0x81,
	0x95, 0x69, 0x87, 0x8b, 0xb7, 0xd9, 0x02, 0xe4, 0xf5, 0x4f, 0xe4, 0x9b, 0x11, 0x2b, 0x1e, 0x96,
	0xf7, 0x8c, 0xbb, 0xf4, 0x3b, 0x04, 0x29, 0x76, 0xc5, 0x97, 0x54, 0xad, 0x44, 0xea, 0xcd, 0x9a,
	0x6a, 0x13, 0xb7, 0xe8, 0x2f, 0xfb, 0x2e, 0xfa, 0x2c, 0xbd, 0x4a, 0xe6, 0xf1, 0x89, 0x01, 0xe6,
	0x89, 0x62, 0xdc, 0x9b, 0xfe, 0x24, 0x4c, 0xd8, 0xaa, 0x56, 0xb6, 0xf9, 0xba, 0xef, 0xc2, 0x3f,
	0x60, 0x77, 0xb7, 0xac, 0x55, 0xf1, 0x06, 0x8c, 0x8b, 0xcc, 0xfc, 0x8a, 0x9d, 0x1f, 0x88, 0xb0,
	0xa0, 0x94, 0xc9, 0x4c, 0x0a, 0x32, 0xa5, 0x97, 0x61, 0x7a, 0x85, 0xd8, 0x3d, 0xfc, 0x5b, 0xf4,
	0xdc, 0x35, 0xdc, 0x3b, 0x88, 0xea, 0x1d, 0xbb, 0x2e, 0xdf, 0x47, 0x90, 0x62, 0x6d, 0x46, 0x0f,
	0x05, 0x7e, 0x5f, 0xd0, 0x5e, 0x7d, 0xd9, 0x5b, 0xff, 0xb1, 0x03, 0x29, 0xd6, 0x7f, 0x7c, 0x3a,
	0x58, 0xf4, 0x68, 0xc1, 0x13, 0x6e, 0x0b, 0xfe, 0x36, 0x82, 0xc9, 0x4e, 0x9c, 0xb9, 0x3a, 0x2f,
	0xf8, 0xe2, 0xeb, 0x04, 0xd5, 0x3a, 0x07, 0xc7, 0x06, 0x6b, 0xed, 0xc4, 0xd5, 0x53, 0x30, 0x64,
	0xab, 0x1a, 0x07, 0x61, 0x2e, 0x0c, 0x55, 0x66, 0x8f, 0xb3, 0x43, 0xfa, 0x02, 0x82, 0xc9, 0xce,
	0xa1, 0xb9, 0xd6, 0x70, 0x69, 0x28, 0xae, 0xb4, 0xbd, 0x9d, 0xc9, 0x35, 0x98, 0xec, 0x9c, 0x89,
	0x6b, 0x49, 0xc1, 0x73, 0x16, 0x1c, 0x15, 0x1c, 0x86, 0x0a, 0x8b, 0xc7, 0xcf, 0x24, 0xe0, 0x68,
	0x20, 0xa1, 0xa9, 0xea, 0x90, 0xac, 0x86, 0xb8, 0x59, 0xfd, 0x24, 0x4c, 0x7b, 0xb2, 0x9a, 0xcd,
	0x85, 0xf4, 0x2a, 0xab, 0xb1, 0x0c, 0x1f, 0x6c, 0xfb, 0x8c, 0x58, 0xab, 0xe2, 0x57, 0x01, 0x07,
	0xf7, 0xd1, 0x82, 0x10, 0x56, 0x48, 0xfd, 0x1e, 0x31, 0x1d, 0x93, 0x7e, 0x1d, 0xd2, 0x3b, 0x09,
	0x38, 0x1a, 0xc8, 0x49, 0x0f, 0x06, 0x2b, 0x1e, 0x84, 0x9f, 0xa0, 0x08, 0x9c, 0x86, 0x93, 0xd1,
	0x10, 0x60, 0x92, 0x58, 0xc8, 0xf7, 0x76, 0x26, 0xf1, 0xe0, 0x9c, 0xc1, 0x17, 0xbd, 0xd1, 0x35,
	0x14, 0x16, 0x5d, 0xec, 0x55, 0x29, 0x86, 0xd8, 0x77, 0x11, 0x1c, 0x55, 0x88, 0x63, 0xee, 0xa7,
	0x0e, 0xc7, 0x79, 0x38, 0xdc, 0x20, 0x77, 0xca, 0xa1, 0x71, 0x31, 0xdd, 0x20, 0x77, 0x4a, 0x81,
	0xd0, 0x90, 0x3e, 0x8b, 0xe0, 0x68, 0xa0, 0x42, 0x7d, 0x3a, 0x96, 0x0e, 0xa8, 0x55, 0xf7, 0x11,
	0x4c, 0x38, 0xcf, 0xf0, 0x92, 0xaa, 0x59, 0x21, 0xa5, 0x0a, 0x47, 0x2d, 0x55, 0x03, 0x67, 0x93,
	0x47, 0x83, 0xb3, 0x01, 0x71, 0x2c, 0xd0, 0x84, 0xc9, 0xae, 0x39, 0x7c, 0x1c, 0x70, 0x16, 0x86,
	0x6d, 0x55, 0x73, 0xc7, 0x00, 0xa1, 0xd5, 0x4a, 0xa1, 0xdc, 0x91, 0x1f, 0xfe, 0xbf, 0x44, 0x80,
	0xdd, 0x41, 0x84, 0x4e, 0x1e, 0xf4, 0xb0, 0x64, 0x0f, 0x58, 0x78, 0x87, 0x4f, 0xc3, 0x31, 0x86,
	0x4f, 0x77, 0xe1, 0x90, 0xc7, 0x23, 0x8e, 0xe3, 0xb3, 0xb0, 0x9f, 0xb7, 0x9e, 0x1c, 0xca, 0x08,
	0x03, 0x01, 0xc5, 0xdd, 0x12, 0x15, 0xcf, 0xcc, 0xcb, 0x30, 0xd6, 0x79, 0x42, 0xe2, 0x34, 0xcc,
	0x14, 0xaf, 0x95, 0x94, 0x97, 0xca, 0xa5, 0x97, 0x36, 0x8a, 0xe5, 0x17, 0xae, 0x6d, 0x6e, 0x14,
	0x2f, 0xad, 0x2d, 0xaf, 0x15, 0x97, 0x26, 0x1f, 0xc2, 0x63, 0x30, 0x52, 0x92, 0x17, 0xaf, 0x14,
	0x27, 0x13, 0xce, 0xbf, 0x57, 0xd7, 0x97, 0x8a, 0x57, 0x26, 0x47, 0xf0, 0x04, 0x24, 0x97, 0xe4,
	0x92, 0x5c, 0xde, 0x2c, 0x29, 0x45, 0xf9, 0xea, 0xe4, 0x10, 0x4e, 0xc2, 0xfe, 0xe5, 0xb5, 0x2b,
	0xc5, 0xcd, 0x62, 0x69, 0x72, 0x38, 0xff, 0x6e, 0x0e, 0x92, 0x4b, 0xdd, 0x5e, 0x12, 0x7f, 0x0b,
	0xc1, 0x01, 0xcf, 0x10, 0x17, 0x2f, 0xc4, 0x1e, 0xbc, 0xa7, 0xf3, 0xb1, 0x66, 0xc4, 0x14, 0x4b,
	0xe9, 0x64, 0x5b, 0x4e, 0xd2, 0x21, 0xfd, 0x29, 0xfa, 0x6e, 0x7a, 0xeb, 0xd7, 0x7f, 0xfc, 0x4a,
	0x62, 0x56, 0xc2, 0xf4, 0x6b, 0x1b, 0xc6, 0x5a, 0x60, 0x5f, 0x9b, 0x14, 0x50, 0x06, 0xff, 0xb6,
	0xd3, 0x10, 0x08, 0x0d, 0xed, 0xe0, 0xb7, 0x5a, 0x9f, 0x81, 0x72, 0x3a, 0xea, 0x10, 0x4c, 0xda,
	0x6e, 0xcb, 0x8f, 0xb2, 0x18, 0x3c, 0xe5, 0x1d, 0x1d, 0x8b, 0x1f, 0xa9, 0xd9, 0x17, 0xa4, 0x9c,
	0x63, 0xf6, 0x5d, 0xc6, 0x7d, 0xbe, 0xd3, 0x67, 0x67, 0x84, 0xfe, 0x3a, 0xe3, 0xe9, 0xab, 0x0b,
	0xe2, 0xf0, 0x17, 0x7f, 0x80, 0xe0, 0x80, 0x67, 0xfe, 0x1a, 0x72, 0x06, 0xbd, 0x66, 0xb5, 0xd1,
	0xfd, 0x5a, 0x6f, 0xcb, 0xb4, 0xa8, 0xb5, 0xe5, 0x83, 0xce, 0x9f, 0x53, 0x9d, 0x0c, 0xa1, 0xbe,
	0x2c, 0x60, 0xe6, 0x8b, 0x43, 0xea, 0xe3, 0x89, 0xe7, 0x81, 0x90, 0xb9, 0x87, 0xff, 0xdc, 0xe9,
	0x8f, 0x22, 0x1f, 0x4e, 0x9f, 0xa9, 0x78, 0x74, 0x27, 0x5e, 0x6f, 0xcb, 0x22, 0x84, 0x6d, 0x79,
	0x56, 0xf8, 0x74, 0x4a, 0xb8, 0x02, 0xa9, 0x53, 0x97, 0xf3, 0xe7, 0xa8, 0x53, 0x02, 0x4f, 0x36,
	0xba, 0x83, 0xde, 0xc3, 0x7a, 0x0f, 0xb9, 0x3d, 0x58, 0x64, 0x6f, 0xfb, 0xcc, 0xb1, 0xd3, 0x33,
	0x81, 0x5a, 0x54, 0xac, 0x37, 0xed, 0x1d, 0xe9, 0x02, 0x3f, 0x21, 0x76, 0x20, 0x99, 0xd8, 0x07,
	0xf2, 0x13, 0x7e, 0x25, 0x09, 0x93, 0x61, 0xfc, 0xc4, 0x40, 0x0b, 0x7b, 0xcf, 0xbb, 0xd3, 0x67,
	0xe3, 0x6d, 0xe2, 0x99, 0x7d, 0xb1, 0x2d, 0xf3, 0xe2, 0xed, 0x89, 0xa8, 0xe8, 0xd9, 0x81, 0x7f,
	0x86, 0x20, 0x29, 0xe4, 0x2f, 0xce, 0x45, 0xcd, 0x74, 0xd7, 0xf0, 0x08, 0x75, 0x59, 0x7a, 0xb5,
	0x2d, 0x4f, 0x7b, 0xf2, 0xdb, 0xcd, 0x6c, 0x6a, 0xf5, 0xa2, 0xf4, 0x4c, 0xb8, 0xd5, 0x3e, 0xe0,
	0xdd, 0xb9, 0x44, 0x81, 0x8f, 0x7f, 0x7f, 0x81, 0x20, 0x29, 0x44, 0x7a, 0x88, 0x1b, 0xc1, 0xf1,
	0x73, 0x24, 0x37, 0x6e, 0xb6, 0x65, 0xa6, 0xae, 0x2d, 0x4f, 0xd1, 0xbf, 0x81, 0xe8, 0x5f, 0xcd,
	0x3f, 0xd7, 0x8d, 0xfe, 0xe8, 0x71, 0xdf, 0x99, 0xb2, 0x64, 0xee, 0xb9, 0x0e, 0xbd, 0x87, 0x20,
	0x29, 0x04, 0x73, 0x88, 0x43, 0xc1, 0xe9, 0x75, 0xdf, 0x88, 0x5f, 0x15, 0x23, 0xfe, 0x5c, 0xe6,
	0x99, 0x78, 0x11, 0x2f, 0x58, 0x8a, 0xbf, 0x83, 0x60, 0xd4, 0xad, 0x8f, 0xf8, 0x54, 0xa4, 0x32,
	0x1a, 0x07, 0x6d, 0xaf, 0xa1, 0x78, 0x0f, 0x86, 0xfe, 0x3f, 0x24, 0x85, 0xc9, 0x79, 0x08, 0x94,
	0xc1, 0x19, 0x7b, 0x24, 0x6b, 0xd3, 0xd4, 0xcc, 0x87, 0x31, 0xbd, 0x55, 0xdd, 0xe0, 0xac, 0x51,
	0x59, 0xce, 0xa5, 0x93, 0x14, 0x7a, 0x9c, 0x30, 0x03, 0x02, 0xfd, 0x5d, 0xfa, 0x4c, 0xf4, 0x0d,
	0xbc, 0x30, 0x5c, 0xf6, 0x16, 0x06, 0x17, 0xbe, 0xdd, 0xa4, 0x18, 0xfe, 0x3d, 0x82, 0xa9, 0xc0,
	0xcb, 0x15, 0xff, 0x4f, 0x84, 0x42, 0x11, 0x1c, 0x67, 0xa4, 0x23, 0xcf, 0x58, 0xa4, 0x5a, 0x5b,
	0x3e, 0xce, 0x8b, 0x86, 0x6f, 0x48, 0xe5, 0xf9, 0x4c, 0xfd, 0xbb, 0x28, 0x9d, 0x89, 0x52, 0xf8,
	0x84, 0x37, 0x9c, 0x55, 0xf0, 0x4c, 0x80, 0xf0, 0x0f, 0x10, 0x1c, 0xf4, 0x0e, 0xa3, 0x70, 0x3e,
	0x2c, 0xa4, 0xf7, 0xe4, 0xde, 0x73, 0x62, 0x78, 0xe7, 0xf1, 0x99, 0xd0, 0xf0, 0x16, 0x8d, 0x77,
	0xa2, 0xfa, 0x6f, 0x08, 0xa6, 0x02, 0x8f, 0xe9, 0x90, 0x63, 0xe9, 0x37, 0x10, 0x8b, 0x61, 0xf7,
	0xbd, 0xb6, 0xec, 0x41, 0xae, 0x2d, 0xa7, 0xc4, 0x8f, 0x81, 0x92, 0x78, 0x35, 0x7f, 0x9e, 0xba,
	0x26, 0x32, 0x65, 0x63, 0xf8, 0xe9, 0x3b, 0xa7, 0xf7, 0x11, 0x4c, 0x05, 0x5e, 0xa2, 0x21, 0x5e,
	0xf7, 0x9b, 0xad, 0xf5, 0xad, 0x91, 0xc5, 0xb6, 0x0c, 0xb4, 0x61, 0xa3, 0xef, 0x4e, 0x76, 0x42,
	0x99, 0xf8, 0x27, 0x74, 0x3f, 0x01, 0x33, 0xbd, 0x47, 0x3e, 0xb8, 0x10, 0x2f, 0x7b, 0xc4, 0xa7,
	0x76, 0x3a, 0xde, 0xf8, 0x42, 0xfa, 0x3c, 0x6a, 0xcb, 0xb9, 0x5e, 0x89, 0xe4, 0xbe, 0xff, 0x7b,
	0xac, 0x52, 0x97, 0xd7, 0x23, 0xdd, 0xcb, 0x3e, 0xa7, 0xd9, 0xaf, 0x90, 0xac, 0x42, 0x8f, 0xe9,
	0x0b, 0xfe, 0x46, 0x02, 0x66, 0x7a, 0x8f, 0x7f, 0x42, 0xf0, 0x18, 0x38, 0x33, 0x8a, 0x8b, 0xc7,
	0xd7, 0x50, 0x5b, 0x9e, 0xa5, 0xa7, 0x1b, 0x34, 0xb1, 0x2d, 0x1f, 0xef, 0x43, 0x09, 0xc4, 0xf5,
	0x7a, 0xfe, 0x99, 0x98, 0x01, 0xc1, 0xa1, 0x71, 0x62, 0xba, 0x17, 0x3a, 0x7f, 0x45, 0x30, 0xd3,
	0x7b, 0x1a, 0x14, 0x82, 0xce, 0xc0, 0x11, 0x52, 0x5c, 0x74, 0x6a, 0x6d, 0xf9, 0x18, 0x85, 0xa0,
	0xef, 0xb8, 0x88, 0x7a, 0x5f, 0x94, 0x2e, 0xee, 0xde, 0x7b, 0x93, 0x1a, 0xec, 0x3c, 0x36, 0x3f,
	0x40, 0x30, 0xd3, 0x7b, 0xae, 0x14, 0xe2, 0xf3, 0xc0, 0x61, 0x54, 0xdf, 0xbc, 0xbe, 0x16, 0xcc,
	0xeb, 0x28, 0x1d, 0x50, 0x3f, 0x47, 0xf0, 0xbf, 0x10, 0x8c, 0x75, 0x72, 0x15, 0x9f, 0x8e, 0x96,
	0xd3, 0xae, 0x91, 0xa1, 0xb3, 0x21, 0xe9, 0xeb, 0xa8, 0x2d, 0x43, 0x37, 0x73, 0xa9, 0xbd, 0x9f,
	0x43, 0x1c, 0xf9, 0x18, 0x57, 0xb9, 0xd0, 0x0b, 0xd1, 0xdf, 0x31, 0x16, 0x86, 0x6c, 0x55, 0xbb,
	0x7e, 0x5e, 0x7a, 0x32, 0x7e, 0x4f, 0xd0, 0xd9, 0x8e, 0xdf, 0x49, 0xc0, 0x58, 0x27, 0x2f, 0x43,
	0x7c, 0xf7, 0x8f, 0xf4, 0x23, 0xf8, 0xfe, 0x7d, 0xd4, 0x96, 0x1d, 0x3d, 0x6d, 0x79, 0xc2, 0x56,
	0xb5, 0x40, 0xf6, 0x7d, 0x09, 0xe5, 0x97, 0xdc, 0x6b, 0x65, 0x37, 0x7d, 0x36, 0x75, 0xc4, 0x89,
	0x45, 0x0a, 0x85, 0x9c, 0x2f, 0xec, 0x42, 0x98, 0x28, 0x02, 0x7f, 0x84, 0x60, 0xac, 0x13, 0x94,
	0x21, 0x70, 0xf8, 0xbf, 0x57, 0xe8, 0x1b, 0xaf, 0x5f, 0x44, 0x62, 0x93, 0xf0, 0x66, 0xe6, 0xe2,
	0x6e, 0x7b, 0x60, 0xd7, 0xd6, 0xeb, 0x4f, 0x67, 0x9e, 0x8c, 0x29, 0x83, 0xef, 0xc4, 0x7f, 0x47,
	0x30, 0xea, 0x4e, 0x3b, 0x43, 0xba, 0x7d, 0xdf, 0x8c, 0x36, 0xa4, 0x04, 0xf9, 0x47, 0xa8, 0xd2,
	0xdb, 0xc8, 0xdb, 0xbc, 0xbe, 0x89, 0xf7, 0x1c, 0xf1, 0xd7, 0x9f, 0xc6, 0xbb, 0x0c, 0x76, 0xfc,
	0x31, 0x82, 0xf1, 0x4d, 0x62, 0xaf, 0xa9, 0xf5, 0x0d, 0xfa, 0xd3, 0x5c, 0xdc, 0x79, 0x0d, 0xe8,
	0x6a, 0x9d, 0xcd, 0xdc, 0xba, 0x44, 0xd7, 0xe3, 0x69, 0x1f, 0x0f, 0xa3, 0x4a, 0x5f, 0x45, 0xd4,
	0xa1, 0xfb, 0x48, 0x92, 0xa9, 0x35, 0xee, 0x2f, 0x61, 0xa2, 0xb6, 0x42, 0x96, 0xa0, 0xaa, 0x80,
	0x32, 0xd7, 0xdd, 0x2a, 0x1c, 0x26, 0xc7, 0x37, 0x64, 0xf1, 0x89, 0xc1, 0x3f, 0x4c, 0xc0, 0xf8,
	0xca, 0x20, 0x17, 0x57, 0xa2, 0xbb, 0xf8, 0x27, 0xe6, 0xe2, 0x47, 0xbb, 0x75, 0x51, 0x7b, 0x30,
	0x2e, 0xfa, 0xc5, 0xac, 0x4b, 0x97, 0xe3, 0x8b, 0x11, 0x9f, 0xe5, 0x3e, 0x81, 0xf8, 0x0f, 0x09,
	0xc0, 0x25, 0x62, 0xd1, 0x45, 0x62, 0xd6, 0x75, 0xcb, 0x72, 0x24, 0xe0, 0x79, 0x1f, 0x2a, 0x41,
	0x16, 0x17, 0xbf, 0xc7, 0x23, 0x70, 0xf2, 0x84, 0xf8, 0x07, 0xc3, 0xf4, 0x2f, 0x48, 0x5a, 0xd9,
	0x15, 0xa6, 0x76, 0x40, 0xb4, 0x03, 0xc9, 0xff, 0x4a, 0xcb, 0xbb, 0x41, 0xb6, 0xb7, 0xb0, 0x17,
	0xa4, 0x8d, 0xbd, 0xe1, 0xdb, 0x53, 0x6c, 0xfa, 0xda, 0x87, 0x72, 0xba, 0xff, 0x77, 0x18, 0xbf,
	0x92, 0xb3, 0xdb, 0xb6, 0xdd, 0xb4, 0x0a, 0xb9, 0xdc, 0x9d, 0x3b, 0x77, 0xfc, 0x5f, 0x70, 0xa8,
	0x2d, 0x7b, 0x9b, 0xfd, 0x46, 0xff, 0xb4, 0x03, 0xc5, 0x0d, 0xc3, 0xac, 0x2f, 0xfe, 0x1c, 0xc1,
	0x23, 0x15, 0xa3, 0x3e, 0xa8, 0x1e, 0x6d, 0xa0, 0xeb, 0xcb, 0x9c, 0xac, 0x19, 0x35, 0xb5, 0xa1,
	0x65, 0x0d, 0x53, 0xcb, 0x69, 0xa4, 0x41, 0x6b, 0x73, 0xae, 0xab, 0xa4, 0xe7, 0xef, 0xff, 0xcf,
	0x09, 0x1f, 0xff, 0x89, 0xd0, 0xf7, 0x12, 0x47, 0x56, 0x98, 0xac, 0x4b, 0x54, 0x95, 0xf0, 0x75,
	0x40, 0xf6, 0xc5, 0x85, 0x0f, 0x5d, 0xea, 0x2b, 0x94, 0xfa, 0x8a, 0x40, 0x7d, 0xe5, 0xc5, 0x85,
	0x4f, 0x12, 0xc7, 0x18, 0xb5, 0x50, 0xa0, 0xe4, 0x42, 0x41, 0xa0, 0x17, 0x0a, 0x2f, 0x2e, 0x6c,
	0xed, 0xa3, 0x26, 0x3d, 0xf1, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x67, 0x97, 0x76, 0xad, 0x58,
	0x32, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataCatalogClient interface {
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequentally call `Get` methods.
	//
	// Note that Data Catalog search queries do not guarantee full recall. Query
	// results that match your query may not be returned, even in subsequent
	// result pages. Also note that results returned (and not returned) can vary
	// across repeated search queries.
	//
	// See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference) for more information.
	SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error)
	// Creates an EntryGroup.
	//
	// An entry group contains logically related entries together with Cloud
	// Identity and Access Management policies that specify the users who can
	// create, edit, and view entries within the entry group.
	//
	// Data Catalog automatically creates an entry group for BigQuery entries
	// ("@bigquery") and Pub/Sub topics ("@pubsub"). Users create their own entry
	// group to contain Cloud Storage fileset entries or custom type entries,
	// and the IAM policies associated with those entries. Entry groups, like
	// entries, can be searched.
	//
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Gets an EntryGroup.
	GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Updates an EntryGroup. The user should enable the Data Catalog API in the
	// project identified by the `entry_group.name` parameter (see [Data Catalog
	// Resource Project] (/data-catalog/docs/concepts/resource-project) for more
	// information).
	UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error)
	// Deletes an EntryGroup. Only entry groups that do not contain entries can be
	// deleted. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists entry groups.
	ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error)
	// Creates an entry. Only entries of 'FILESET' type or user-specified type can
	// be created.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	//
	// A maximum of 100,000 entries may be created per entry group.
	CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Updates an existing entry.
	// Users should enable the Data Catalog API in the project identified by
	// the `entry.name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Deletes an existing entry. Only entries created through
	// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
	// method can be deleted.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets an entry.
	GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error)
	// Lists entries.
	ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error)
	// Creates a tag template. The user should enable the Data Catalog API in
	// the project identified by the `parent` parameter (see [Data Catalog
	// Resource Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	// Users should enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error)
	// Deletes a tag template and all tags using the template.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `parent` parameter (see
	// [Data Catalog Resource
	// Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Updates a field in a tag template. This method cannot be used to update the
	// field type. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Renames a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `name` parameter (see [Data Catalog
	// Resource Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of that field.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1.Entry].
	// Note: The project identified by the `parent` parameter for the
	// [tag](/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the
	// [tag
	// template](/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be from the same organization.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists the tags on an [Entry][google.cloud.datacatalog.v1.Entry].
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entries.setIamPolicy` to set policies on entries.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entries.getIamPolicy` to get policies on entries.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type dataCatalogClient struct {
	cc grpc.ClientConnInterface
}

func NewDataCatalogClient(cc grpc.ClientConnInterface) DataCatalogClient {
	return &dataCatalogClient{cc}
}

func (c *dataCatalogClient) SearchCatalog(ctx context.Context, in *SearchCatalogRequest, opts ...grpc.CallOption) (*SearchCatalogResponse, error) {
	out := new(SearchCatalogResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/SearchCatalog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateEntryGroup(ctx context.Context, in *CreateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntryGroup(ctx context.Context, in *GetEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateEntryGroup(ctx context.Context, in *UpdateEntryGroupRequest, opts ...grpc.CallOption) (*EntryGroup, error) {
	out := new(EntryGroup)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteEntryGroup(ctx context.Context, in *DeleteEntryGroupRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntryGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListEntryGroups(ctx context.Context, in *ListEntryGroupsRequest, opts ...grpc.CallOption) (*ListEntryGroupsResponse, error) {
	out := new(ListEntryGroupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListEntryGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateEntry(ctx context.Context, in *CreateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateEntry(ctx context.Context, in *UpdateEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteEntry(ctx context.Context, in *DeleteEntryRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetEntry(ctx context.Context, in *GetEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) LookupEntry(ctx context.Context, in *LookupEntryRequest, opts ...grpc.CallOption) (*Entry, error) {
	out := new(Entry)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/LookupEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListEntries(ctx context.Context, in *ListEntriesRequest, opts ...grpc.CallOption) (*ListEntriesResponse, error) {
	out := new(ListEntriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplate(ctx context.Context, in *CreateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetTagTemplate(ctx context.Context, in *GetTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplate(ctx context.Context, in *UpdateTagTemplateRequest, opts ...grpc.CallOption) (*TagTemplate, error) {
	out := new(TagTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplate(ctx context.Context, in *DeleteTagTemplateRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTagTemplateField(ctx context.Context, in *CreateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTagTemplateField(ctx context.Context, in *UpdateTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) RenameTagTemplateField(ctx context.Context, in *RenameTagTemplateFieldRequest, opts ...grpc.CallOption) (*TagTemplateField, error) {
	out := new(TagTemplateField)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTagTemplateField(ctx context.Context, in *DeleteTagTemplateFieldRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/CreateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/UpdateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/DeleteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/ListTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.datacatalog.v1.DataCatalog/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
type DataCatalogServer interface {
	// Searches Data Catalog for multiple resources like entries, tags that
	// match a query.
	//
	// This is a custom method
	// (https://cloud.google.com/apis/design/custom_methods) and does not return
	// the complete resource, only the resource identifier and high level
	// fields. Clients can subsequentally call `Get` methods.
	//
	// Note that Data Catalog search queries do not guarantee full recall. Query
	// results that match your query may not be returned, even in subsequent
	// result pages. Also note that results returned (and not returned) can vary
	// across repeated search queries.
	//
	// See [Data Catalog Search
	// Syntax](/data-catalog/docs/how-to/search-reference) for more information.
	SearchCatalog(context.Context, *SearchCatalogRequest) (*SearchCatalogResponse, error)
	// Creates an EntryGroup.
	//
	// An entry group contains logically related entries together with Cloud
	// Identity and Access Management policies that specify the users who can
	// create, edit, and view entries within the entry group.
	//
	// Data Catalog automatically creates an entry group for BigQuery entries
	// ("@bigquery") and Pub/Sub topics ("@pubsub"). Users create their own entry
	// group to contain Cloud Storage fileset entries or custom type entries,
	// and the IAM policies associated with those entries. Entry groups, like
	// entries, can be searched.
	//
	// A maximum of 10,000 entry groups may be created per organization across all
	// locations.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	CreateEntryGroup(context.Context, *CreateEntryGroupRequest) (*EntryGroup, error)
	// Gets an EntryGroup.
	GetEntryGroup(context.Context, *GetEntryGroupRequest) (*EntryGroup, error)
	// Updates an EntryGroup. The user should enable the Data Catalog API in the
	// project identified by the `entry_group.name` parameter (see [Data Catalog
	// Resource Project] (/data-catalog/docs/concepts/resource-project) for more
	// information).
	UpdateEntryGroup(context.Context, *UpdateEntryGroupRequest) (*EntryGroup, error)
	// Deletes an EntryGroup. Only entry groups that do not contain entries can be
	// deleted. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteEntryGroup(context.Context, *DeleteEntryGroupRequest) (*empty.Empty, error)
	// Lists entry groups.
	ListEntryGroups(context.Context, *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error)
	// Creates an entry. Only entries of 'FILESET' type or user-specified type can
	// be created.
	//
	// Users should enable the Data Catalog API in the project identified by
	// the `parent` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	//
	// A maximum of 100,000 entries may be created per entry group.
	CreateEntry(context.Context, *CreateEntryRequest) (*Entry, error)
	// Updates an existing entry.
	// Users should enable the Data Catalog API in the project identified by
	// the `entry.name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateEntry(context.Context, *UpdateEntryRequest) (*Entry, error)
	// Deletes an existing entry. Only entries created through
	// [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
	// method can be deleted.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteEntry(context.Context, *DeleteEntryRequest) (*empty.Empty, error)
	// Gets an entry.
	GetEntry(context.Context, *GetEntryRequest) (*Entry, error)
	// Get an entry by target resource name. This method allows clients to use
	// the resource name from the source Google Cloud Platform service to get the
	// Data Catalog Entry.
	LookupEntry(context.Context, *LookupEntryRequest) (*Entry, error)
	// Lists entries.
	ListEntries(context.Context, *ListEntriesRequest) (*ListEntriesResponse, error)
	// Creates a tag template. The user should enable the Data Catalog API in
	// the project identified by the `parent` parameter (see [Data Catalog
	// Resource Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	CreateTagTemplate(context.Context, *CreateTagTemplateRequest) (*TagTemplate, error)
	// Gets a tag template.
	GetTagTemplate(context.Context, *GetTagTemplateRequest) (*TagTemplate, error)
	// Updates a tag template. This method cannot be used to update the fields of
	// a template. The tag template fields are represented as separate resources
	// and should be updated using their own create/update/delete methods.
	// Users should enable the Data Catalog API in the project identified by
	// the `tag_template.name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateTagTemplate(context.Context, *UpdateTagTemplateRequest) (*TagTemplate, error)
	// Deletes a tag template and all tags using the template.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteTagTemplate(context.Context, *DeleteTagTemplateRequest) (*empty.Empty, error)
	// Creates a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `parent` parameter (see
	// [Data Catalog Resource
	// Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	CreateTagTemplateField(context.Context, *CreateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Updates a field in a tag template. This method cannot be used to update the
	// field type. Users should enable the Data Catalog API in the project
	// identified by the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	UpdateTagTemplateField(context.Context, *UpdateTagTemplateFieldRequest) (*TagTemplateField, error)
	// Renames a field in a tag template. The user should enable the Data Catalog
	// API in the project identified by the `name` parameter (see [Data Catalog
	// Resource Project](/data-catalog/docs/concepts/resource-project) for more
	// information).
	RenameTagTemplateField(context.Context, *RenameTagTemplateFieldRequest) (*TagTemplateField, error)
	// Deletes a field in a tag template and all uses of that field.
	// Users should enable the Data Catalog API in the project identified by
	// the `name` parameter (see [Data Catalog Resource Project]
	// (/data-catalog/docs/concepts/resource-project) for more information).
	DeleteTagTemplateField(context.Context, *DeleteTagTemplateFieldRequest) (*empty.Empty, error)
	// Creates a tag on an [Entry][google.cloud.datacatalog.v1.Entry].
	// Note: The project identified by the `parent` parameter for the
	// [tag](/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
	// and the
	// [tag
	// template](/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
	// used to create the tag must be from the same organization.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Updates an existing tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*empty.Empty, error)
	// Lists the tags on an [Entry][google.cloud.datacatalog.v1.Entry].
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Sets the access control policy for a resource. Replaces any existing
	// policy.
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
	//     templates.
	//   - `datacatalog.entries.setIamPolicy` to set policies on entries.
	//   - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a resource. A `NOT_FOUND` error
	// is returned if the resource does not exist. An empty policy is returned
	// if the resource exists but does not have a policy set on it.
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// Callers must have following Google IAM permission
	//   - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
	//     templates.
	//   - `datacatalog.entries.getIamPolicy` to get policies on entries.
	//   - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns the caller's permissions on a resource.
	// If the resource does not exist, an empty set of permissions is returned
	// (We don't return a `NOT_FOUND` error).
	//
	// Supported resources are:
	//   - Tag templates.
	//   - Entries.
	//   - Entry groups.
	// Note, this method cannot be used to manage policies for BigQuery, Pub/Sub
	// and any external Google Cloud Platform resources synced to Data Catalog.
	//
	// A caller is not required to have Google IAM permission to make this
	// request.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedDataCatalogServer can be embedded to have forward compatible implementations.
type UnimplementedDataCatalogServer struct {
}

func (*UnimplementedDataCatalogServer) SearchCatalog(ctx context.Context, req *SearchCatalogRequest) (*SearchCatalogResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCatalog not implemented")
}
func (*UnimplementedDataCatalogServer) CreateEntryGroup(ctx context.Context, req *CreateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) GetEntryGroup(ctx context.Context, req *GetEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateEntryGroup(ctx context.Context, req *UpdateEntryGroupRequest) (*EntryGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteEntryGroup(ctx context.Context, req *DeleteEntryGroupRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntryGroup not implemented")
}
func (*UnimplementedDataCatalogServer) ListEntryGroups(ctx context.Context, req *ListEntryGroupsRequest) (*ListEntryGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntryGroups not implemented")
}
func (*UnimplementedDataCatalogServer) CreateEntry(ctx context.Context, req *CreateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntry not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateEntry(ctx context.Context, req *UpdateEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntry not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteEntry(ctx context.Context, req *DeleteEntryRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntry not implemented")
}
func (*UnimplementedDataCatalogServer) GetEntry(ctx context.Context, req *GetEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntry not implemented")
}
func (*UnimplementedDataCatalogServer) LookupEntry(ctx context.Context, req *LookupEntryRequest) (*Entry, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEntry not implemented")
}
func (*UnimplementedDataCatalogServer) ListEntries(ctx context.Context, req *ListEntriesRequest) (*ListEntriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntries not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTagTemplate(ctx context.Context, req *CreateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) GetTagTemplate(ctx context.Context, req *GetTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTagTemplate(ctx context.Context, req *UpdateTagTemplateRequest) (*TagTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTagTemplate(ctx context.Context, req *DeleteTagTemplateRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplate not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTagTemplateField(ctx context.Context, req *CreateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTagTemplateField(ctx context.Context, req *UpdateTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) RenameTagTemplateField(ctx context.Context, req *RenameTagTemplateFieldRequest) (*TagTemplateField, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTagTemplateField(ctx context.Context, req *DeleteTagTemplateFieldRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagTemplateField not implemented")
}
func (*UnimplementedDataCatalogServer) CreateTag(ctx context.Context, req *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (*UnimplementedDataCatalogServer) UpdateTag(ctx context.Context, req *UpdateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTag not implemented")
}
func (*UnimplementedDataCatalogServer) DeleteTag(ctx context.Context, req *DeleteTagRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (*UnimplementedDataCatalogServer) ListTags(ctx context.Context, req *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (*UnimplementedDataCatalogServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedDataCatalogServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedDataCatalogServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterDataCatalogServer(s *grpc.Server, srv DataCatalogServer) {
	s.RegisterService(&_DataCatalog_serviceDesc, srv)
}

func _DataCatalog_SearchCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SearchCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/SearchCatalog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SearchCatalog(ctx, req.(*SearchCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntryGroup(ctx, req.(*CreateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntryGroup(ctx, req.(*GetEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntryGroup(ctx, req.(*UpdateEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntryGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntryGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntryGroup(ctx, req.(*DeleteEntryGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntryGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntryGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListEntryGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntryGroups(ctx, req.(*ListEntryGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateEntry(ctx, req.(*CreateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateEntry(ctx, req.(*UpdateEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteEntry(ctx, req.(*DeleteEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetEntry(ctx, req.(*GetEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_LookupEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).LookupEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/LookupEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).LookupEntry(ctx, req.(*LookupEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListEntries(ctx, req.(*ListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplate(ctx, req.(*CreateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetTagTemplate(ctx, req.(*GetTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplate(ctx, req.(*UpdateTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplate(ctx, req.(*DeleteTagTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTagTemplateField(ctx, req.(*CreateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTagTemplateField(ctx, req.(*UpdateTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_RenameTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/RenameTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).RenameTagTemplateField(ctx, req.(*RenameTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTagTemplateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagTemplateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTagTemplateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTagTemplateField(ctx, req.(*DeleteTagTemplateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/CreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/UpdateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/DeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/ListTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.datacatalog.v1.DataCatalog/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataCatalog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.datacatalog.v1.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchCatalog",
			Handler:    _DataCatalog_SearchCatalog_Handler,
		},
		{
			MethodName: "CreateEntryGroup",
			Handler:    _DataCatalog_CreateEntryGroup_Handler,
		},
		{
			MethodName: "GetEntryGroup",
			Handler:    _DataCatalog_GetEntryGroup_Handler,
		},
		{
			MethodName: "UpdateEntryGroup",
			Handler:    _DataCatalog_UpdateEntryGroup_Handler,
		},
		{
			MethodName: "DeleteEntryGroup",
			Handler:    _DataCatalog_DeleteEntryGroup_Handler,
		},
		{
			MethodName: "ListEntryGroups",
			Handler:    _DataCatalog_ListEntryGroups_Handler,
		},
		{
			MethodName: "CreateEntry",
			Handler:    _DataCatalog_CreateEntry_Handler,
		},
		{
			MethodName: "UpdateEntry",
			Handler:    _DataCatalog_UpdateEntry_Handler,
		},
		{
			MethodName: "DeleteEntry",
			Handler:    _DataCatalog_DeleteEntry_Handler,
		},
		{
			MethodName: "GetEntry",
			Handler:    _DataCatalog_GetEntry_Handler,
		},
		{
			MethodName: "LookupEntry",
			Handler:    _DataCatalog_LookupEntry_Handler,
		},
		{
			MethodName: "ListEntries",
			Handler:    _DataCatalog_ListEntries_Handler,
		},
		{
			MethodName: "CreateTagTemplate",
			Handler:    _DataCatalog_CreateTagTemplate_Handler,
		},
		{
			MethodName: "GetTagTemplate",
			Handler:    _DataCatalog_GetTagTemplate_Handler,
		},
		{
			MethodName: "UpdateTagTemplate",
			Handler:    _DataCatalog_UpdateTagTemplate_Handler,
		},
		{
			MethodName: "DeleteTagTemplate",
			Handler:    _DataCatalog_DeleteTagTemplate_Handler,
		},
		{
			MethodName: "CreateTagTemplateField",
			Handler:    _DataCatalog_CreateTagTemplateField_Handler,
		},
		{
			MethodName: "UpdateTagTemplateField",
			Handler:    _DataCatalog_UpdateTagTemplateField_Handler,
		},
		{
			MethodName: "RenameTagTemplateField",
			Handler:    _DataCatalog_RenameTagTemplateField_Handler,
		},
		{
			MethodName: "DeleteTagTemplateField",
			Handler:    _DataCatalog_DeleteTagTemplateField_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _DataCatalog_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _DataCatalog_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _DataCatalog_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _DataCatalog_ListTags_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _DataCatalog_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _DataCatalog_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _DataCatalog_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/datacatalog/v1/datacatalog.proto",
}
