if (NOT CMAKE_BUILD_TYPE)
  set(CMAKE_BUILD_TYPE "Release")
endif ()

option(CMAKE_UNITY_BUILD "Use unity build" ON)
if (DEFINED ENV{CMAKE_UNITY_BUILD})
  set(CMAKE_UNITY_BUILD $ENV{CMAKE_UNITY_BUILD})
endif ()

set(CMAKE_UNITY_BUILD_BATCH_SIZE "50" CACHE STRING "Batch size for unity build")
option(USE_CCACHE "Use ccache" ON)
option(WITH_SYSTEM_PROVIDED_3PARTY "Enable compilation with system provided dependencies" OFF)
option(BUILD_DESIGNER "Build application as design tool" OFF)
option(BUILD_STANDALONE "Build standalone application" OFF)
option(USE_ASAN "Enable Address Sanitizer" OFF)
option(USE_TSAN "Enable Thread Sanitizer" OFF)
option(USE_LIBFUZZER "Enable LibFuzzer" OFF)
option(USE_HEAPPROF "Enable heap profiler" OFF)
option(PYBINDINGS "Create makefiles for building python bindings" OFF)
option(SKIP_QT_GUI "Skip building of Qt GUI" OFF)
option(USE_PCH "Use precompiled headers" OFF)
option(NJOBS "Number of parallel processes" OFF)
option(ENABLE_VULKAN_DIAGNOSTICS "Enable Vulkan diagnostics" OFF)
option(ENABLE_TRACE "Enable Tracing" OFF)
option(USE_PPROF "Enable Google Profiler" OFF)
option(COVERAGE_REPORT "Configure for coverage report" OFF)
