#! /bin/sh

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

set -ue
## set -x

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_MAIN_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/samples.db

sqlite3 ${TMP_DB_FILE} < tests/inputs/samples-r92.sql
sqlite3 ${TMP_DB_FILE} <<END
    create view sample_experiment_epma_epma_mineral as
    select SolsaID, measurement_date, analytical_conditions, formula_struct,
           experiment_epma.uuid as experiment_epma_uuid,
           epma_mineral.uuid as epma_mineral_uuid
        from sample join experiment_epma on sample.id = sample_id
                    join epma_mineral on experiment_id = experiment_epma.id;
END


sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} < tests/inputs/samples-metadata-r92.sql
sqlite3 ${TMP_DB_META} "update description set dbname = '${TMP_DB_MAIN_ABS}'"

export REQUEST_URI="/~saulius/restful/website/samples.db/sample_experiment_epma_epma_mineral"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

echo "==="

perl -lne 'print "$_\r"' <<EOF |
--------------------------b989696a28305e74
Content-Disposition: form-data; name="jsonfile"; filename="fill.csv"
Content-Type: text/plain

{
   "data" : [
      {
         "type" : "sample_experiment_epma_epma_mineral",
         "attributes" : {
            "SolsaID" : "VU-TEST-0001",
            "analytical_conditions" : "dark",
            "formula_struct" : "H2 O",
            "experiment_epma_uuid" : "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaaa",
            "epma_mineral_uuid" : "aaaaaaaa-aaaa-aaaa-aaaa-aaaaaaaaaaab"
         }
      }
   ]
}

--------------------------b989696a28305e74--
EOF
${INPUT_SCRIPT} | sed "s/\/tmp\/tmp-.*samples\.db/samples.db/"

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from sample order by id';
sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from experiment_epma order by id';
sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from epma_mineral order by id';

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
